/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.core.tests.model;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import junit.framework.Protectable;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestResult;
import junit.framework.TestSuite;
import org.eclipse.dltk.core.tests.TestSupport;

public abstract class SuiteOfTestCases
extends TestCase {
    public SuiteOfTestCases(String name) {
        super(name);
    }

    public void setUpSuite() throws Exception {
    }

    public void tearDownSuite() throws Exception {
    }

    public boolean notYetImplemented() {
        return TestSupport.notYetImplemented(this);
    }

    public static class Suite
    extends TestSuite {
        public SuiteOfTestCases currentTestCase;

        public Suite(Class theClass) {
            super(theClass);
        }

        public Suite(Class theClass, String methodName) {
            this(theClass, new String[]{methodName});
        }

        public Suite(Class theClass, String[] methodNames) {
            super(theClass.getName());
            int i = 0;
            while (i < methodNames.length) {
                String methodName = methodNames[i];
                try {
                    Method method = theClass.getMethod(methodName, new Class[0]);
                    if (Modifier.isPublic(method.getModifiers()) && !Modifier.isStatic(method.getModifiers())) {
                        this.addTest(Suite.createTest((Class)theClass, (String)methodName));
                    } else {
                        this.warning(methodName, "Wrong modifiers");
                    }
                }
                catch (SecurityException e) {
                    this.warning(methodName, e.toString());
                }
                catch (NoSuchMethodException e) {
                    this.warning(methodName, e.toString());
                }
                ++i;
            }
        }

        private void warning(String name, final String message) {
            this.addTest((Test)new TestCase(name){

                protected void runTest() {
                    1.fail((String)message);
                }
            });
        }

        public Suite(String name) {
            super(name);
        }

        private void initialize(SuiteOfTestCases test) {
            Class<?> currentClass = ((Object)((Object)test)).getClass();
            while (currentClass != null && !currentClass.equals(SuiteOfTestCases.class)) {
                Field[] fields = currentClass.getDeclaredFields();
                int i = 0;
                int length = fields.length;
                while (i < length) {
                    Field field = fields[i];
                    int modifiers = field.getModifiers();
                    if (!Modifier.isStatic(modifiers) && !Modifier.isFinal(modifiers)) {
                        field.setAccessible(true);
                        try {
                            Object value = field.get((Object)this.currentTestCase);
                            field.set((Object)test, value);
                        }
                        catch (IllegalAccessException illegalAccessException) {}
                    }
                    ++i;
                }
                currentClass = currentClass.getSuperclass();
            }
        }

        public void run(final TestResult result) {
            Protectable p = new Protectable(){

                public void protect() throws Exception {
                    try {
                        Suite.this.superRun(result);
                    }
                    finally {
                        if (Suite.this.currentTestCase != null) {
                            Suite.this.currentTestCase.tearDownSuite();
                        }
                    }
                }
            };
            result.runProtected((Test)this, p);
        }

        public void superRun(TestResult result) {
            super.run(result);
        }

        public void runTest(Test test, TestResult result) {
            if (test instanceof SuiteOfTestCases) {
                SuiteOfTestCases current = (SuiteOfTestCases)test;
                if (this.currentTestCase == null) {
                    try {
                        current.setUpSuite();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                } else {
                    this.initialize(current);
                }
                try {
                    super.runTest(test, result);
                }
                finally {
                    this.currentTestCase = current;
                }
            } else {
                super.runTest(test, result);
            }
        }
    }
}

