/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.xotcl.testing.internal.xounit;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.ast.declarations.MethodDeclaration;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.ast.declarations.TypeDeclaration;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.SourceParserUtil;
import org.eclipse.dltk.core.environment.IDeployment;
import org.eclipse.dltk.launching.AbstractScriptLaunchConfigurationDelegate;
import org.eclipse.dltk.launching.InterpreterConfig;
import org.eclipse.dltk.tcl.core.TclParseUtil;
import org.eclipse.dltk.tcl.testing.ITclTestingEngine;
import org.eclipse.dltk.testing.ITestingProcessor;
import org.eclipse.dltk.xotcl.core.ast.xotcl.XOTclMethodDeclaration;
import org.eclipse.dltk.xotcl.testing.internal.xounit.Activator;
import org.eclipse.dltk.xotcl.testing.internal.xounit.XOUnitOutputProcessor;

public class XOUnitTestingEngine
implements ITclTestingEngine {
    public String getId() {
        return "org.eclipse.dltk.xotcl.testing.xounit.testingEngine";
    }

    public String getName() {
        return "XOUnit";
    }

    public ITestingProcessor getProcessor(ILaunch launch) {
        return new XOUnitOutputProcessor(launch);
    }

    public boolean isValidModule(ISourceModule module) {
        ModuleDeclaration moduleDeclaration = SourceParserUtil.getModuleDeclaration((ISourceModule)module, null);
        TypeDeclaration[] findTests = XOUnitTestingEngine.findTests(moduleDeclaration);
        return findTests.length > 0;
    }

    public static TypeDeclaration[] findTests(final ModuleDeclaration decl) {
        ArrayList ndes;
        block5: {
            ndes = new ArrayList();
            if (decl != null) {
                try {
                    decl.traverse(new ASTVisitor(){

                        public boolean visitGeneral(ASTNode node) throws Exception {
                            if (node instanceof TypeDeclaration && (((TypeDeclaration)node).getModifiers() & 0x80000) != 0) {
                                TypeDeclaration typeDeclaration = (TypeDeclaration)node;
                                String fqn = TclParseUtil.getElementFQN((ASTNode)node, (String)"::", (ModuleDeclaration)decl);
                                if (!fqn.endsWith("::test::" + typeDeclaration.getName())) {
                                    return true;
                                }
                                List superClassNames = typeDeclaration.getSuperClassNames();
                                boolean passTestCaseSuper = false;
                                Iterator iterator = superClassNames.iterator();
                                while (iterator.hasNext()) {
                                    String name = (String)iterator.next();
                                    if (!name.endsWith("TestCase")) continue;
                                    passTestCaseSuper = true;
                                    break;
                                }
                                if (!passTestCaseSuper) {
                                    return true;
                                }
                                MethodDeclaration[] methods = typeDeclaration.getMethods();
                                int i = 0;
                                while (i < methods.length) {
                                    XOTclMethodDeclaration method;
                                    MethodDeclaration childNode = methods[i];
                                    if (childNode instanceof XOTclMethodDeclaration && (method = (XOTclMethodDeclaration)childNode).getName().startsWith("test")) {
                                        ndes.add(typeDeclaration);
                                        break;
                                    }
                                    ++i;
                                }
                            }
                            return true;
                        }
                    });
                }
                catch (CoreException e) {
                    if (DLTKCore.DEBUG) {
                        e.printStackTrace();
                    }
                }
                catch (Exception e) {
                    if (!DLTKCore.DEBUG) break block5;
                    e.printStackTrace();
                }
            }
        }
        return ndes.toArray(new TypeDeclaration[ndes.size()]);
    }

    public void correctLaunchConfiguration(InterpreterConfig config, ILaunchConfiguration configuration, ILaunch launch) {
        block8: {
            try {
                IDeployment deployment = config.getExecutionEnvironment().createDeployment();
                IPath runner = deployment.add(Activator.getDefault().getBundle(), "scripts/xounitTestingEngine.tcl");
                IPath scriptFilePath = config.getScriptFilePath();
                runner = new Path(deployment.getFile(runner).toOSString());
                config.setScriptFile(runner);
                if (scriptFilePath != null) {
                    config.addScriptArg(scriptFilePath.toOSString(), 0);
                }
                String projectName = AbstractScriptLaunchConfigurationDelegate.getScriptProjectName((ILaunchConfiguration)configuration);
                String mainScriptName = AbstractScriptLaunchConfigurationDelegate.getMainScriptName((ILaunchConfiguration)configuration);
                IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
                IFile script = project.getFile(mainScriptName);
                ISourceModule module = (ISourceModule)DLTKCore.create((IFile)script);
                ModuleDeclaration moduleDeclaration = SourceParserUtil.getModuleDeclaration((ISourceModule)module, null);
                TypeDeclaration[] findTests = XOUnitTestingEngine.findTests(moduleDeclaration);
                String namespace = "";
                String tests = "";
                int i = 0;
                while (i < findTests.length) {
                    ASTNode parent = TclParseUtil.getPrevParent((ModuleDeclaration)moduleDeclaration, (ASTNode)findTests[i]);
                    while (parent != null && parent instanceof TypeDeclaration) {
                        if ((((TypeDeclaration)parent).getModifiers() & 0x80000) == 0) break;
                        parent = TclParseUtil.getPrevParent((ModuleDeclaration)moduleDeclaration, (ASTNode)parent);
                    }
                    if (parent != null && parent instanceof TypeDeclaration) {
                        String elementFQN = TclParseUtil.getElementFQN((ASTNode)parent, (String)"::", (ModuleDeclaration)moduleDeclaration);
                        namespace = elementFQN.substring(0, elementFQN.length() - "::test".length());
                        config.addEnvVar("XOUNIT_TEST_NAMESPACE", namespace);
                    }
                    tests = String.valueOf(tests) + findTests[i].getName() + (i == findTests.length - 1 ? "" : " ");
                    ++i;
                }
                config.addEnvVar("XOUNIT_TEST_NAMES", tests);
            }
            catch (IOException e) {
                if (DLTKCore.DEBUG) {
                    e.printStackTrace();
                }
            }
            catch (CoreException e) {
                if (!DLTKCore.DEBUG) break block8;
                e.printStackTrace();
            }
        }
    }

    public static TypeDeclaration[] getTests(TypeDeclaration typeDeclaration) {
        return typeDeclaration.getTypes();
    }

    public static MethodDeclaration[] getTestCases(TypeDeclaration typeDeclaration) {
        ArrayList<MethodDeclaration> testCases = new ArrayList<MethodDeclaration>();
        MethodDeclaration[] methods = typeDeclaration.getMethods();
        int i = 0;
        while (i < methods.length) {
            if (methods[i].getName().startsWith("test") && (methods[i].getModifiers() & 0x80000) != 0) {
                testCases.add(methods[i]);
            }
            ++i;
        }
        return testCases.toArray(new MethodDeclaration[testCases.size()]);
    }
}

