/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.indexing;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.compiler.ISourceElementRequestor;
import org.eclipse.dltk.compiler.problem.IProblemReporter;
import org.eclipse.dltk.compiler.problem.ProblemCollector;
import org.eclipse.dltk.compiler.util.Util;
import org.eclipse.dltk.core.DLTKContentTypeManager;
import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.core.caching.ArchiveCacheIndexBuilder;
import org.eclipse.dltk.core.caching.ArchiveIndexContentChecker;
import org.eclipse.dltk.core.caching.MixinModelCollector;
import org.eclipse.dltk.core.caching.StructureModelCollector;
import org.eclipse.dltk.core.mixin.IMixinRequestor;
import org.eclipse.dltk.tcl.ast.TclModule;
import org.eclipse.dltk.tcl.core.TclLanguageToolkit;
import org.eclipse.dltk.tcl.indexing.NullIndexer;
import org.eclipse.dltk.tcl.internal.core.TclSourceIndexerRequestor;
import org.eclipse.dltk.tcl.internal.core.search.mixin.TclMixinBuildVisitor;
import org.eclipse.dltk.tcl.internal.core.serialization.TclASTSaver;
import org.eclipse.dltk.tcl.internal.parser.NewTclSourceParser;
import org.eclipse.dltk.tcl.internal.parser.TclSourceElementRequestVisitor;
import org.eclipse.dltk.tcl.parser.ITclErrorReporter;
import org.eclipse.dltk.tcl.parser.TclErrorCollector;
import org.eclipse.dltk.tcl.parser.TclParser;
import org.eclipse.dltk.tcl.parser.definitions.DefinitionManager;
import org.eclipse.dltk.tcl.parser.definitions.IScopeProcessor;
import org.eclipse.dltk.utils.TextUtils;

public class DLTKTclIndexer {
    private long totalSize = 0L;
    private long totalIndexesSize = 0L;
    private long totalASTIndexesSize = 0L;
    public static final long VERSION = 200905291444L;

    public boolean isFoderRebuild() {
        return false;
    }

    public void buildIndexFor(File folder, boolean recursive) {
        if (!folder.isDirectory()) {
            return;
        }
        File[] files = folder.listFiles();
        ArrayList<File> toIndex = new ArrayList<File>();
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.isDirectory() && recursive) {
                if (file.canWrite()) {
                    this.buildIndexFor(file, recursive);
                }
            } else if (this.needIndexing(file)) {
                toIndex.add(file);
            }
            ++n2;
        }
        if (!toIndex.isEmpty()) {
            ArchiveIndexContentChecker astChecker;
            ArchiveIndexContentChecker checker;
            boolean buildRequired = this.isFoderRebuild();
            File indexFile = new File(folder, ".dltk.index");
            File astIndexFile = new File(folder, ".dltk.index.ast");
            if (!buildRequired && !indexFile.exists()) {
                buildRequired = true;
            }
            if (!buildRequired && !astIndexFile.exists()) {
                buildRequired = true;
            }
            if (!buildRequired && (checker = new ArchiveIndexContentChecker(indexFile, 200905291444L, TclLanguageToolkit.getDefault())).containChanges()) {
                buildRequired = true;
            }
            if (!buildRequired && (astChecker = new ArchiveIndexContentChecker(astIndexFile, 200905291444L, TclLanguageToolkit.getDefault())).containChanges()) {
                buildRequired = true;
            }
            if (!buildRequired) {
                this.logIndexConsistent(folder);
                return;
            }
            this.logBeginOfFolder(folder);
            this.deleteIndexFiles(indexFile, astIndexFile);
            long filesSize = 0L;
            try {
                ArchiveCacheIndexBuilder builder = new ArchiveCacheIndexBuilder((OutputStream)new FileOutputStream(indexFile), 200905291444L);
                ArchiveCacheIndexBuilder astIndexBuilder = new ArchiveCacheIndexBuilder((OutputStream)new FileOutputStream(astIndexFile), 200905291444L);
                for (File file : toIndex) {
                    String content = new String(Util.getFileByteContent((File)file));
                    filesSize += (long)content.length();
                    ProblemCollector dltkProblems = new ProblemCollector();
                    TclModule module = this.makeModule(content, dltkProblems);
                    File canonicalFile = file.getCanonicalFile();
                    long timestamp = file.lastModified();
                    if (!canonicalFile.getAbsolutePath().equals(file.getAbsolutePath())) {
                        timestamp = canonicalFile.lastModified();
                    }
                    ByteArrayOutputStream bout = new ByteArrayOutputStream();
                    TclASTSaver saver = new TclASTSaver(module, (OutputStream)bout);
                    saver.store(dltkProblems);
                    astIndexBuilder.addEntry(file.getName(), timestamp, "_ast", (InputStream)new ByteArrayInputStream(bout.toByteArray()));
                    TclSourceIndexerRequestor req = new TclSourceIndexerRequestor();
                    req.setIndexer(new NullIndexer());
                    StructureModelCollector collector = new StructureModelCollector((ISourceElementRequestor)req);
                    NewTclSourceParser parser = new NewTclSourceParser();
                    ModuleDeclaration ast = parser.parse(null, module, null);
                    TclSourceElementRequestVisitor requestor = new TclSourceElementRequestVisitor((ISourceElementRequestor)collector, null);
                    ast.traverse((ASTVisitor)requestor);
                    byte[] structure_index = collector.getBytes();
                    builder.addEntry(file.getName(), timestamp, "_sind", (InputStream)new ByteArrayInputStream(structure_index));
                    MixinModelCollector mixinCollector = new MixinModelCollector();
                    TclMixinBuildVisitor mixinVisitor = new TclMixinBuildVisitor(ast, null, false, (IMixinRequestor)mixinCollector);
                    ast.traverse((ASTVisitor)mixinVisitor);
                    byte[] mixin_index = mixinCollector.getBytes();
                    builder.addEntry(file.getName(), timestamp, "_smix", (InputStream)new ByteArrayInputStream(mixin_index));
                }
                builder.done();
                astIndexBuilder.done();
                this.logEntry(indexFile, filesSize);
                this.totalSize += filesSize;
                this.totalIndexesSize += indexFile.length();
                this.totalASTIndexesSize += astIndexFile.length();
            }
            catch (FileNotFoundException fileNotFoundException) {
                this.deleteIndexFiles(indexFile, astIndexFile);
            }
            catch (IOException iOException) {
                this.deleteIndexFiles(indexFile, astIndexFile);
            }
            catch (Exception exception) {
                this.reportUnknownError(folder);
                this.deleteIndexFiles(indexFile, astIndexFile);
            }
        }
    }

    private void deleteIndexFiles(File indexFile, File astIndexFile) {
        try {
            if (indexFile.exists()) {
                indexFile.delete();
            }
            if (astIndexFile.exists()) {
                astIndexFile.delete();
            }
        }
        catch (Exception exception) {}
    }

    protected void logIndexConsistent(File folder) {
    }

    public void logBeginOfFolder(File folder) {
    }

    public void logEntry(File indexFile, long filesSize) {
    }

    protected void reportUnknownError(File folder) {
    }

    private TclModule makeModule(String content, ProblemCollector dltkProblems) {
        TclParser parser = new TclParser();
        TclErrorCollector collector = new TclErrorCollector();
        TclModule module = parser.parseModule(content, (ITclErrorReporter)collector, (IScopeProcessor)DefinitionManager.getInstance().getCoreProcessor());
        if (dltkProblems != null) {
            collector.reportAll((IProblemReporter)dltkProblems, TextUtils.createLineTracker((String)content));
        }
        return module;
    }

    private boolean needIndexing(File file) {
        if (!file.isFile()) {
            return false;
        }
        return DLTKContentTypeManager.isValidFileNameForContentType((IDLTKLanguageToolkit)TclLanguageToolkit.getDefault(), (IPath)new Path(file.getAbsolutePath()));
    }

    public long getTotalSize() {
        return this.totalSize;
    }

    public long getTotalIndexesSize() {
        return this.totalIndexesSize + this.totalASTIndexesSize;
    }

    public long getBasicIndexesSize() {
        return this.totalIndexesSize;
    }

    public long getASTIndexesSize() {
        return this.totalASTIndexesSize;
    }
}

