/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.core.tests.xml;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DOMSerializer {
    private String indent = "";
    private String lineSeparator = "\n";
    private String encoding = "UTF8";
    private boolean displayAttributesOnSeperateLine = true;
    private boolean skipEmptyText = true;

    public void setLineSeparator(String lineSeparator) {
        this.lineSeparator = lineSeparator;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void setIndent(int numSpaces) {
        char[] buffer = new char[numSpaces];
        Arrays.fill(buffer, ' ');
        this.indent = new String(buffer);
    }

    public void serialize(Document doc, OutputStream out) throws IOException {
        OutputStreamWriter writer = new OutputStreamWriter(out, this.encoding);
        this.serialize(doc, writer);
    }

    public void serialize(Document doc, File file) throws IOException {
        FileWriter writer = new FileWriter(file);
        this.serialize(doc, writer);
    }

    public void serialize(Document doc, Writer writer) throws IOException {
        doc.normalize();
        this.serializeNode(doc, writer, "");
        writer.flush();
    }

    public String serialize(Document doc) throws IOException {
        StringWriter writer = new StringWriter();
        this.serialize(doc, writer);
        return writer.toString();
    }

    private void serializeNode(Node node, Writer writer, String indentLevel) throws IOException {
        switch (node.getNodeType()) {
            case 9: {
                Node[] nodes = this.collectChildren(node);
                if (nodes == null) break;
                int i = 0;
                while (i < nodes.length) {
                    this.serializeNode(nodes[i], writer, "");
                    ++i;
                }
                break;
            }
            case 1: {
                String name = node.getNodeName();
                writer.write(String.valueOf(indentLevel) + "<" + name);
                this.writeAttributes(node, writer, indentLevel);
                Node[] children = this.collectChildren(node);
                if (children != null) {
                    writer.write(">");
                    if (children[0].getNodeType() == 1) {
                        writer.write(this.lineSeparator);
                    }
                    int i = 0;
                    while (i < children.length) {
                        this.serializeNode(children[i], writer, String.valueOf(indentLevel) + this.indent);
                        ++i;
                    }
                    if (children[children.length - 1].getNodeType() == 1) {
                        writer.write(indentLevel);
                    }
                    writer.write("</" + name + ">");
                } else {
                    writer.write("/>");
                }
                writer.write(this.lineSeparator);
                break;
            }
            case 3: {
                String value = node.getNodeValue();
                if (this.skipEmptyText && DOMSerializer.isBlank(value)) break;
                this.print(writer, value);
                break;
            }
            case 4: {
                writer.write("<![CDATA[");
                this.print(writer, node.getNodeValue());
                writer.write("]]>");
                break;
            }
            case 8: {
                writer.write(String.valueOf(indentLevel) + "<!-- " + node.getNodeValue() + " -->");
                writer.write(this.lineSeparator);
                break;
            }
            case 7: {
                writer.write("<?" + node.getNodeName() + " " + node.getNodeValue() + "?>");
                writer.write(this.lineSeparator);
                break;
            }
            case 5: {
                writer.write("&" + node.getNodeName() + ";");
                break;
            }
            case 10: {
                DocumentType docType = (DocumentType)node;
                String publicId = docType.getPublicId();
                String systemId = docType.getSystemId();
                String internalSubset = docType.getInternalSubset();
                writer.write("<!DOCTYPE " + docType.getName());
                if (publicId != null) {
                    writer.write(" PUBLIC \"" + publicId + "\" ");
                } else {
                    writer.write(" SYSTEM ");
                }
                writer.write("\"" + systemId + "\"");
                if (internalSubset != null) {
                    writer.write(" [" + internalSubset + "]");
                }
                writer.write(">");
                writer.write(this.lineSeparator);
            }
        }
    }

    private void writeAttributes(Node node, Writer writer, String indentLevel) throws IOException {
        NamedNodeMap attributes = node.getAttributes();
        Object[] attributeNames = new String[attributes.getLength()];
        int i = 0;
        while (i < attributes.getLength()) {
            attributeNames[i] = attributes.item(i).getNodeName();
            ++i;
        }
        Arrays.sort(attributeNames);
        i = 0;
        while (i < attributes.getLength()) {
            Node current = attributes.getNamedItem((String)attributeNames[i]);
            String attributeSeperator = " ";
            if (this.displayAttributesOnSeperateLine && attributes.getLength() != 1) {
                attributeSeperator = String.valueOf(this.lineSeparator) + indentLevel + this.indent;
            }
            String attributeStr = String.valueOf(attributeSeperator) + current.getNodeName() + "=\"";
            writer.write(attributeStr);
            this.print(writer, current.getNodeValue());
            writer.write("\"");
            ++i;
        }
    }

    private Node[] collectChildren(Node parent) {
        NodeList children = parent.getChildNodes();
        if (children != null && children.getLength() > 0) {
            ArrayList<Node> result = new ArrayList<Node>();
            int i = 0;
            while (i < children.getLength()) {
                Node child = children.item(i);
                if (!(child == null || this.skipEmptyText && child.getNodeType() == 3 && DOMSerializer.isBlank(child.getNodeValue()))) {
                    result.add(child);
                }
                ++i;
            }
            if (!result.isEmpty()) {
                return result.toArray(new Node[result.size()]);
            }
        }
        return null;
    }

    private static boolean isBlank(String str) {
        if (str == null) {
            return true;
        }
        int strLen = str.length();
        if (strLen == 0) {
            return true;
        }
        int i = 0;
        while (i < strLen) {
            if (!Character.isWhitespace(str.charAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private void print(Writer writer, String s) throws IOException {
        if (s == null) {
            return;
        }
        int i = 0;
        int len = s.length();
        while (i < len) {
            char c = s.charAt(i);
            switch (c) {
                case '<': {
                    writer.write("&lt;");
                    break;
                }
                case '>': {
                    writer.write("&gt;");
                    break;
                }
                case '&': {
                    writer.write("&amp;");
                    break;
                }
                case '\r': {
                    writer.write("&#xD;");
                    break;
                }
                default: {
                    writer.write(c);
                }
            }
            ++i;
        }
    }

    public boolean isDisplayAttributesOnSeperateLine() {
        return this.displayAttributesOnSeperateLine;
    }

    public void setDisplayAttributesOnSeperateLine(boolean displayAttributesOnSeperateLine) {
        this.displayAttributesOnSeperateLine = displayAttributesOnSeperateLine;
    }
}

