/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ruby.internal.ui.text.hyperlink;

import java.util.ArrayList;
import org.eclipse.core.runtime.Path;
import org.eclipse.dltk.core.IScriptFolder;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ModelException;

public class SourceModuleLookup {
    public static ISourceModule[] lookup(IScriptProject project, String modulePath, String suffix) throws ModelException {
        ArrayList<ISourceModule> result = new ArrayList<ISourceModule>();
        Path path = new Path(modulePath);
        String fileName = path.lastSegment();
        String folderPath = path.removeLastSegments(1).toString();
        IScriptFolder[] folders = project.getScriptFolders();
        int i = 0;
        while (i < folders.length) {
            IScriptFolder folder = folders[i];
            if (folderPath.length() == 0 || folder.getElementName().endsWith(folderPath)) {
                ISourceModule[] modules = folder.getSourceModules();
                int j = 0;
                while (j < modules.length) {
                    ISourceModule module = modules[j];
                    String moduleName = module.getElementName();
                    if (fileName.equals(moduleName)) {
                        result.add(module);
                    } else if (suffix != null && moduleName.length() == fileName.length() + suffix.length() && moduleName.startsWith(fileName) && moduleName.endsWith(suffix)) {
                        result.add(module);
                    }
                    ++j;
                }
            }
            ++i;
        }
        return result.toArray(new ISourceModule[result.size()]);
    }
}

