/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ui.wizards;

import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Observable;
import java.util.Observer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.environment.EnvironmentChangedListener;
import org.eclipse.dltk.core.environment.EnvironmentManager;
import org.eclipse.dltk.core.environment.IEnvironment;
import org.eclipse.dltk.core.environment.IEnvironmentChangedListener;
import org.eclipse.dltk.core.environment.IFileHandle;
import org.eclipse.dltk.internal.corext.util.Messages;
import org.eclipse.dltk.internal.ui.wizards.NewWizardMessages;
import org.eclipse.dltk.internal.ui.wizards.dialogfields.ComboDialogField;
import org.eclipse.dltk.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.dltk.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.dltk.internal.ui.wizards.dialogfields.IStringButtonAdapter;
import org.eclipse.dltk.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.dltk.internal.ui.wizards.dialogfields.SelectionButtonDialogField;
import org.eclipse.dltk.internal.ui.wizards.dialogfields.StringButtonDialogField;
import org.eclipse.dltk.internal.ui.wizards.dialogfields.StringDialogField;
import org.eclipse.dltk.launching.IInterpreterInstall;
import org.eclipse.dltk.launching.IInterpreterInstallType;
import org.eclipse.dltk.launching.InterpreterStandin;
import org.eclipse.dltk.launching.ScriptRuntime;
import org.eclipse.dltk.ui.DLTKUIPlugin;
import org.eclipse.dltk.ui.dialogs.StatusInfo;
import org.eclipse.dltk.ui.environment.IEnvironmentUI;
import org.eclipse.dltk.ui.wizards.ILocationGroup;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.PreferencesUtil;

public abstract class ProjectWizardFirstPage
extends WizardPage
implements ILocationGroup {
    protected NameGroup fNameGroup;
    protected LocationGroup fLocationGroup;
    private boolean interpretersPresent;
    protected DetectGroup fDetectGroup;
    private Validator fValidator;
    protected String fInitialName;
    private static final String PAGE_NAME = NewWizardMessages.ScriptProjectWizardFirstPage_page_pageName;
    private IInterpreterGroup fInterpreterGroup;
    private LocationObservers locationObservers = new LocationObservers();

    protected IStatus validateProject() {
        String name = this.fNameGroup.getName();
        if (name.length() == 0) {
            return new StatusInfo(0, NewWizardMessages.ScriptProjectWizardFirstPage_Message_enterProjectName);
        }
        IStatus nameStatus = DLTKUIPlugin.getWorkspace().validateName(name, 4);
        if (!nameStatus.isOK()) {
            return nameStatus;
        }
        IProject handle = this.getProjectHandle();
        if (handle.exists()) {
            return new StatusInfo(4, NewWizardMessages.ScriptProjectWizardFirstPage_Message_projectAlreadyExists);
        }
        return null;
    }

    protected boolean isValidProject() {
        return this.validateProject() == null;
    }

    public ProjectWizardFirstPage() {
        super(PAGE_NAME);
        this.setPageComplete(false);
        this.setTitle(NewWizardMessages.ScriptProjectWizardFirstPage_page_title);
        this.setDescription(NewWizardMessages.ScriptProjectWizardFirstPage_page_description);
        this.fInitialName = "";
    }

    public void setName(String name) {
        this.fInitialName = name;
        if (this.fNameGroup != null) {
            this.fNameGroup.setName(name);
        }
    }

    public boolean isInterpretersPresent() {
        return this.interpretersPresent;
    }

    protected abstract boolean interpeterRequired();

    protected boolean supportInterpreter() {
        return true;
    }

    protected abstract IInterpreterGroup createInterpreterGroup(Composite var1);

    protected IInterpreterGroup getInterpreterGroup() {
        return this.fInterpreterGroup;
    }

    protected void handlePossibleInterpreterChange() {
        if (this.fInterpreterGroup != null) {
            this.fInterpreterGroup.handlePossibleInterpreterChange();
        }
    }

    protected Observable getInterpreterGroupObservable() {
        if (this.fInterpreterGroup instanceof Observable) {
            return (Observable)((Object)this.fInterpreterGroup);
        }
        return null;
    }

    protected IInterpreterInstall getInterpreter() {
        return this.fInterpreterGroup != null ? this.fInterpreterGroup.getSelectedInterpreter() : null;
    }

    protected IEnvironment getInterpreterEnvironment() {
        return this.fInterpreterGroup.getEnvironment();
    }

    public IInterpreterInstall getSelectedInterpreter() {
        return this.getInterpreter();
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        composite.setFont(parent.getFont());
        composite.setLayout((Layout)this.initGridLayout(new GridLayout(1, false), true));
        composite.setLayoutData((Object)new GridData(256));
        this.fNameGroup = new NameGroup(composite, this.fInitialName);
        this.fLocationGroup = this.createLocationGroup();
        this.fLocationGroup.createControls(composite);
        this.fInterpreterGroup = this.supportInterpreter() ? this.createInterpreterGroup(composite) : null;
        this.createCustomGroups(composite);
        this.fDetectGroup = new DetectGroup(composite);
        this.fNameGroup.addObserver(this.fLocationGroup);
        this.fLocationGroup.addObserver(this.fDetectGroup);
        this.fLocationGroup.addObserver(this.locationObservers);
        this.fNameGroup.notifyObservers();
        this.fValidator = new Validator();
        Observable interpreterGroupObservable = this.getInterpreterGroupObservable();
        if (this.supportInterpreter() && interpreterGroupObservable != null) {
            interpreterGroupObservable.addObserver(this.fValidator);
            this.handlePossibleInterpreterChange();
        }
        this.fNameGroup.addObserver(this.fValidator);
        this.fLocationGroup.addObserver(this.fValidator);
        this.setControl((Control)composite);
        Dialog.applyDialogFont((Control)composite);
        if (DLTKCore.DEBUG) {
            System.err.println("Add help support here...");
        }
    }

    protected LocationGroup createLocationGroup() {
        return new LocationGroup();
    }

    protected void createCustomGroups(Composite composite) {
    }

    public URI getLocationURI() {
        IEnvironment environment = this.getEnvironment();
        return environment.getURI(this.fLocationGroup.getLocation());
    }

    public IEnvironment getEnvironment() {
        return this.fLocationGroup.getEnvironment();
    }

    public IPath getLocation() {
        return this.fLocationGroup.getLocation();
    }

    public void addLocationListener(ILocationGroup.Listener listener) {
        this.locationObservers.observers.add((Object)listener);
    }

    public IProject getProjectHandle() {
        return ResourcesPlugin.getWorkspace().getRoot().getProject(this.fNameGroup.getName());
    }

    public boolean isInWorkspace() {
        return this.fLocationGroup.isInWorkspace();
    }

    public String getProjectName() {
        return this.fNameGroup.getName();
    }

    public boolean getDetect() {
        return this.fDetectGroup.mustDetect();
    }

    public boolean isSrc() {
        return false;
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.fNameGroup.postSetFocus();
        }
    }

    public void dispose() {
        this.fLocationGroup.dispose();
        super.dispose();
    }

    protected GridLayout initGridLayout(GridLayout layout, boolean margins) {
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        if (margins) {
            layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
            layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        } else {
            layout.marginWidth = 0;
            layout.marginHeight = 0;
        }
        return layout;
    }

    protected GridData setButtonLayoutData(Button button) {
        return super.setButtonLayoutData(button);
    }

    protected abstract class AbstractInterpreterGroup
    extends Observable
    implements Observer,
    SelectionListener,
    IDialogFieldListener,
    IInterpreterGroup {
        protected final ComboDialogField fInterpreterEnvironment;
        protected final SelectionButtonDialogField fUseDefaultInterpreter;
        protected final SelectionButtonDialogField fUseProjectInterpreter;
        protected final ComboDialogField fInterpreterCombo;
        private final Group fGroup;
        private String[] fComplianceLabels;
        private final Link fPreferenceLink;
        private IInterpreterInstall[] fInstalledInterpreters;
        private IEnvironment[] fEnvironments = null;

        public AbstractInterpreterGroup(Composite composite) {
            this.fGroup = new Group(composite, 0);
            this.fGroup.setFont(composite.getFont());
            this.fGroup.setLayoutData((Object)new GridData(768));
            GridLayout groupLayout = ProjectWizardFirstPage.this.initGridLayout(new GridLayout(3, false), true);
            groupLayout.marginHeight /= 2;
            this.fGroup.setLayout((Layout)groupLayout);
            this.fGroup.setText(NewWizardMessages.ScriptProjectWizardFirstPage_InterpreterEnvironmentGroup_title);
            if (this.isTargetEnvironmentAllowed()) {
                Composite interpreterEnvironmentComposite = new Composite((Composite)this.fGroup, 0);
                interpreterEnvironmentComposite.setLayout((Layout)ProjectWizardFirstPage.this.initGridLayout(new GridLayout(2, false), false));
                GridData interpreterEnvironmentData = new GridData(768);
                interpreterEnvironmentData.horizontalSpan = 3;
                interpreterEnvironmentComposite.setLayoutData((Object)interpreterEnvironmentData);
                this.fInterpreterEnvironment = new ComboDialogField(2056);
                this.fInterpreterEnvironment.setLabelText(NewWizardMessages.ProjectWizardFirstPage_InterpreterTargetEnvironment);
                this.fInterpreterEnvironment.doFillIntoGrid(interpreterEnvironmentComposite, 2);
                LayoutUtil.setHorizontalGrabbing((Control)this.fInterpreterEnvironment.getComboControl(null));
                this.fInterpreterEnvironment.setDialogFieldListener(this);
            } else {
                this.fInterpreterEnvironment = null;
            }
            this.fUseDefaultInterpreter = new SelectionButtonDialogField(16);
            this.fUseDefaultInterpreter.setLabelText(this.getDefaultInterpreterLabel());
            this.fUseDefaultInterpreter.doFillIntoGrid((Composite)this.fGroup, 2);
            this.fPreferenceLink = new Link((Composite)this.fGroup, 0);
            this.fPreferenceLink.setFont(this.fGroup.getFont());
            this.fPreferenceLink.setText(NewWizardMessages.ScriptProjectWizardFirstPage_InterpreterEnvironmentGroup_link_description);
            this.fPreferenceLink.setLayoutData((Object)new GridData(3, 2, false, false));
            this.fPreferenceLink.addSelectionListener((SelectionListener)this);
            this.fUseProjectInterpreter = new SelectionButtonDialogField(16);
            this.fUseProjectInterpreter.setLabelText(NewWizardMessages.ScriptProjectWizardFirstPage_InterpreterEnvironmentGroup_specific_compliance);
            this.fUseProjectInterpreter.doFillIntoGrid((Composite)this.fGroup, 1);
            this.fUseProjectInterpreter.setDialogFieldListener(this);
            this.fInterpreterCombo = new ComboDialogField(8);
            this.fillInstalledInterpreters(this.fInterpreterCombo);
            this.fInterpreterCombo.setDialogFieldListener(this);
            Combo comboControl = this.fInterpreterCombo.getComboControl((Composite)this.fGroup);
            GridData gridData = new GridData(1, 2, true, false);
            gridData.minimumWidth = 100;
            comboControl.setLayoutData((Object)gridData);
            comboControl.setVisibleItemCount(20);
            this.fUseDefaultInterpreter.setSelection(true);
            this.fInterpreterCombo.setEnabled(this.fUseProjectInterpreter.isSelected());
        }

        public IEnvironment getEnvironment() {
            int index;
            if (this.isTargetEnvironmentAllowed() && ProjectWizardFirstPage.this.fLocationGroup.isInWorkspace() && this.fEnvironments != null && (index = this.fInterpreterEnvironment.getSelectionIndex()) >= 0 && index < this.fEnvironments.length) {
                return this.fEnvironments[index];
            }
            return ProjectWizardFirstPage.this.fLocationGroup.getEnvironment();
        }

        private void fillInstalledInterpreters(ComboDialogField comboField) {
            String selectedItem = null;
            int selectionIndex = -1;
            if (this.fUseProjectInterpreter.isSelected() && (selectionIndex = comboField.getSelectionIndex()) != -1) {
                selectedItem = comboField.getItems()[selectionIndex];
            }
            this.fInstalledInterpreters = this.getWorkspaceInterpeters();
            selectionIndex = -1;
            this.fComplianceLabels = new String[this.fInstalledInterpreters.length];
            int i = 0;
            while (i < this.fInstalledInterpreters.length) {
                this.fComplianceLabels[i] = this.fInstalledInterpreters[i].getName();
                if (selectedItem != null && this.fComplianceLabels[i].equals(selectedItem)) {
                    selectionIndex = i;
                }
                ++i;
            }
            comboField.setItems(this.fComplianceLabels);
            if (selectionIndex == -1) {
                this.fInterpreterCombo.selectItem(this.getDefaultInterpreterName());
            } else {
                this.fInterpreterCombo.selectItem(selectedItem);
            }
            ProjectWizardFirstPage.this.interpretersPresent = this.fInstalledInterpreters.length > 0;
        }

        private IInterpreterInstall[] getWorkspaceInterpeters() {
            ArrayList<InterpreterStandin> standins = new ArrayList<InterpreterStandin>();
            IInterpreterInstallType[] types = ScriptRuntime.getInterpreterInstallTypes((String)this.getCurrentLanguageNature());
            IEnvironment environment = this.getEnvironment();
            int i = 0;
            while (i < types.length) {
                IInterpreterInstallType type = types[i];
                IInterpreterInstall[] installs = type.getInterpreterInstalls();
                int j = 0;
                while (j < installs.length) {
                    IInterpreterInstall install = installs[j];
                    String envId = install.getEnvironmentId();
                    if (envId != null && envId.equals(environment.getId())) {
                        standins.add(new InterpreterStandin(install));
                    }
                    ++j;
                }
                ++i;
            }
            return standins.toArray(new IInterpreterInstall[standins.size()]);
        }

        private String getDefaultInterpreterName() {
            IInterpreterInstall inst = ScriptRuntime.getDefaultInterpreterInstall((ScriptRuntime.DefaultInterpreterEntry)new ScriptRuntime.DefaultInterpreterEntry(this.getCurrentLanguageNature(), this.getEnvironment().getId()));
            if (inst != null) {
                return inst.getName();
            }
            return "undefined";
        }

        private String getDefaultInterpreterLabel() {
            return Messages.format(NewWizardMessages.ScriptProjectWizardFirstPage_InterpreterEnvironmentGroup_default_compliance, this.getDefaultInterpreterName());
        }

        public void update(Observable o, Object arg) {
            this.updateEnableState();
        }

        private void updateEnableState() {
            if (ProjectWizardFirstPage.this.fDetectGroup == null) {
                return;
            }
            boolean detect = ProjectWizardFirstPage.this.fDetectGroup.mustDetect() && ProjectWizardFirstPage.this.interpretersPresent;
            this.fUseDefaultInterpreter.setEnabled(!detect);
            this.fUseProjectInterpreter.setEnabled(!detect);
            this.fInterpreterCombo.setEnabled(!detect && this.fUseProjectInterpreter.isSelected());
            this.fPreferenceLink.setEnabled(!detect);
            this.fGroup.setEnabled(!detect);
        }

        public void widgetSelected(SelectionEvent e) {
            this.widgetDefaultSelected(e);
        }

        void showInterpreterPreferencePage() {
            String pageId = this.getIntereprtersPreferencePageId();
            PreferencesUtil.createPreferenceDialogOn((Shell)ProjectWizardFirstPage.this.getShell(), (String)pageId, (String[])new String[]{pageId}, null).open();
        }

        protected abstract String getIntereprtersPreferencePageId();

        protected abstract String getCurrentLanguageNature();

        protected boolean isTargetEnvironmentAllowed() {
            return true;
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.showInterpreterPreferencePage();
            this.handlePossibleInterpreterChange();
            this.updateEnableState();
        }

        public void handlePossibleInterpreterChange() {
            if (this.isTargetEnvironmentAllowed()) {
                this.refreshEnvironments();
            }
            this.refreshInterpreters();
        }

        private void refreshInterpreters() {
            this.fUseDefaultInterpreter.setLabelText(this.getDefaultInterpreterLabel());
            this.fillInstalledInterpreters(this.fInterpreterCombo);
            this.setChanged();
            this.notifyObservers();
        }

        private void refreshEnvironments() {
            int index;
            IEnvironment selection = ProjectWizardFirstPage.this.fLocationGroup.isExternalProject() ? ProjectWizardFirstPage.this.fLocationGroup.getEnvironment() : ((index = this.fInterpreterEnvironment.getSelectionIndex()) >= 0 && index < this.fEnvironments.length ? this.fEnvironments[index] : ProjectWizardFirstPage.this.fLocationGroup.getEnvironment());
            Object[] environments = ProjectWizardFirstPage.this.fLocationGroup.environments;
            if (!Arrays.equals(environments, this.fEnvironments)) {
                this.fEnvironments = environments;
                String[] items = new String[environments.length];
                int selectionIndex = -1;
                int i = 0;
                while (i < items.length) {
                    Object env = environments[i];
                    items[i] = env.getName();
                    if (selection != null && selection.equals(env)) {
                        selectionIndex = i;
                    }
                    ++i;
                }
                this.fInterpreterEnvironment.setItems(items);
                this.fInterpreterEnvironment.selectItem(selectionIndex);
            } else if (selection != null) {
                int i = 0;
                while (i < environments.length) {
                    if (selection.equals(environments[i])) {
                        this.fInterpreterEnvironment.selectItem(i);
                    }
                    ++i;
                }
            }
            this.fInterpreterEnvironment.setEnabled(ProjectWizardFirstPage.this.fLocationGroup.isInWorkspace());
        }

        public void dialogFieldChanged(DialogField field) {
            if (field == this.fInterpreterEnvironment && this.isTargetEnvironmentAllowed()) {
                this.refreshInterpreters();
            }
            this.updateEnableState();
        }

        public boolean isUseSpecific() {
            return this.fUseProjectInterpreter.isSelected();
        }

        public IInterpreterInstall getSelectedInterpreter() {
            int index;
            if (this.fUseProjectInterpreter.isSelected() && (index = this.fInterpreterCombo.getSelectionIndex()) >= 0 && index < this.fComplianceLabels.length) {
                return this.fInstalledInterpreters[index];
            }
            return null;
        }
    }

    protected final class DetectGroup
    extends Observable
    implements Observer,
    SelectionListener {
        private final Link fHintText;
        private boolean fDetect;

        public DetectGroup(Composite composite) {
            this.fHintText = new Link(composite, 64);
            this.fHintText.setFont(composite.getFont());
            this.fHintText.addSelectionListener((SelectionListener)this);
            GridData gd = new GridData(4, 4, true, true);
            gd.widthHint = ProjectWizardFirstPage.this.convertWidthInCharsToPixels(50);
            this.fHintText.setLayoutData((Object)gd);
            if (ProjectWizardFirstPage.this.supportInterpreter()) {
                ProjectWizardFirstPage.this.handlePossibleInterpreterChange();
            }
        }

        private boolean isValidProjectName(String name) {
            if (name.length() == 0) {
                return false;
            }
            IWorkspace workspace = DLTKUIPlugin.getWorkspace();
            return workspace.validateName(name, 4).isOK() && workspace.getRoot().findMember(name) == null;
        }

        public void update(Observable o, Object arg) {
            if (o instanceof LocationGroup) {
                boolean oldDetectState = this.fDetect;
                IPath location = ProjectWizardFirstPage.this.fLocationGroup.getLocation();
                if (ProjectWizardFirstPage.this.fLocationGroup.isInWorkspace()) {
                    if (!this.isValidProjectName(ProjectWizardFirstPage.this.getProjectName())) {
                        this.fDetect = false;
                    } else {
                        IEnvironment environment = ProjectWizardFirstPage.this.fLocationGroup.getEnvironment();
                        IFileHandle directory = environment.getFile(location.append(ProjectWizardFirstPage.this.getProjectName()));
                        this.fDetect = directory.isDirectory();
                    }
                } else {
                    IEnvironment environment = ProjectWizardFirstPage.this.fLocationGroup.getEnvironment();
                    if (location.toPortableString().length() > 0) {
                        IFileHandle directory = environment.getFile(location);
                        this.fDetect = directory.isDirectory();
                    }
                }
                if (oldDetectState != this.fDetect) {
                    this.setChanged();
                    this.notifyObservers();
                    if (this.fDetect) {
                        this.fHintText.setVisible(true);
                        this.fHintText.setText(NewWizardMessages.ScriptProjectWizardFirstPage_DetectGroup_message);
                    } else {
                        this.fHintText.setVisible(false);
                    }
                    if (ProjectWizardFirstPage.this.supportInterpreter()) {
                        ProjectWizardFirstPage.this.handlePossibleInterpreterChange();
                    }
                }
            }
        }

        public boolean mustDetect() {
            return this.fDetect;
        }

        public void widgetSelected(SelectionEvent e) {
            this.widgetDefaultSelected(e);
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            if (DLTKCore.DEBUG) {
                System.err.println("DetectGroup show compilancePreferencePage...");
            }
            if (ProjectWizardFirstPage.this.supportInterpreter()) {
                ProjectWizardFirstPage.this.handlePossibleInterpreterChange();
            }
        }
    }

    protected static interface IInterpreterGroup {
        public IEnvironment getEnvironment();

        public IInterpreterInstall getSelectedInterpreter();

        public void handlePossibleInterpreterChange();
    }

    public class LocationGroup
    extends Observable
    implements Observer,
    IStringButtonAdapter,
    IDialogFieldListener {
        protected final SelectionButtonDialogField fWorkspaceRadio = new SelectionButtonDialogField(16);
        protected final SelectionButtonDialogField fExternalRadio;
        protected final StringButtonDialogField fLocation;
        protected final ComboDialogField fEnvironment;
        private IEnvironment[] environments;
        private String fPreviousExternalLocation = "";
        private static final String DIALOGSTORE_LAST_EXTERNAL_LOC = "org.eclipse.dltk.ui.last.external.project";
        private static final String DIALOGSTORE_LAST_EXTERNAL_ENVIRONMENT = "org.eclipse.dltk.ui.last.external.environment";
        private IEnvironmentChangedListener environmentChangedListener = null;
        protected static final int ANY = 0;
        protected static final int WORKSPACE = 1;
        protected static final int EXTERNAL = 2;

        public LocationGroup() {
            this.fWorkspaceRadio.setDialogFieldListener(this);
            this.fWorkspaceRadio.setLabelText(NewWizardMessages.ScriptProjectWizardFirstPage_LocationGroup_workspace_desc);
            this.fExternalRadio = new SelectionButtonDialogField(16);
            this.fExternalRadio.setDialogFieldListener(this);
            this.fExternalRadio.setLabelText(NewWizardMessages.ScriptProjectWizardFirstPage_LocationGroup_external_desc);
            this.fLocation = new StringButtonDialogField(this);
            this.fLocation.setDialogFieldListener(this);
            this.fLocation.setLabelText(NewWizardMessages.ScriptProjectWizardFirstPage_LocationGroup_locationLabel_desc);
            this.fLocation.setButtonLabel(NewWizardMessages.ScriptProjectWizardFirstPage_LocationGroup_browseButton_desc);
            this.fEnvironment = new ComboDialogField(12);
            this.fEnvironment.setLabelText(NewWizardMessages.ProjectWizardFirstPage_host);
            this.fEnvironment.setDialogFieldListener(this);
            this.fEnvironment.setDialogFieldListener(new IDialogFieldListener(){

                public void dialogFieldChanged(DialogField field) {
                    LocationGroup.this.updateInterpreters();
                }
            });
        }

        public void createControls(Composite composite) {
            Group group = new Group(composite, 0);
            group.setLayoutData((Object)new GridData(768));
            group.setLayout((Layout)ProjectWizardFirstPage.this.initGridLayout(new GridLayout(3, false), true));
            group.setText(NewWizardMessages.ScriptProjectWizardFirstPage_LocationGroup_title);
            this.createControls(group, 3);
        }

        protected void createControls(Group group, int numColumns) {
            this.fWorkspaceRadio.doFillIntoGrid((Composite)group, numColumns);
            this.fExternalRadio.doFillIntoGrid((Composite)group, numColumns);
            this.fLocation.doFillIntoGrid((Composite)group, numColumns);
            LayoutUtil.setHorizontalGrabbing((Control)this.fLocation.getTextControl(null));
            this.environmentChangedListener = new EnvironmentChangedListener(){

                public void environmentsModified() {
                    Display.getDefault().asyncExec(new Runnable(){

                        public void run() {
                            block2: {
                                try {
                                    LocationGroup.this.initEnvironments(false);
                                }
                                catch (Exception e) {
                                    if (!DLTKCore.DEBUG) break block2;
                                    e.printStackTrace();
                                }
                            }
                        }
                    });
                }
            };
            EnvironmentManager.addEnvironmentChangedListener((IEnvironmentChangedListener)this.environmentChangedListener);
            this.initEnvironments(true);
            this.fEnvironment.doFillIntoGrid((Composite)group, numColumns);
            LayoutUtil.setHorizontalGrabbing((Control)this.fEnvironment.getComboControl(null));
            this.fWorkspaceRadio.setSelection(true);
            this.fExternalRadio.setSelection(false);
        }

        private void initEnvironments(boolean initializeWithLocal) {
            int index;
            IEnvironment selection = !initializeWithLocal && this.environments != null ? ((index = this.fEnvironment.getSelectionIndex()) >= 0 && index < this.environments.length ? this.environments[index] : null) : null;
            this.environments = EnvironmentManager.getEnvironments((boolean)false);
            String[] items = new String[this.environments.length];
            int selectionIndex = 0;
            int i = 0;
            while (i < items.length) {
                IEnvironment env = this.environments[i];
                items[i] = env.getName();
                if (selection == null ? env.isLocal() : selection.equals(env)) {
                    selectionIndex = i;
                }
                ++i;
            }
            this.fEnvironment.setItems(items);
            this.fEnvironment.selectItem(selectionIndex);
        }

        protected void fireEvent() {
            this.setChanged();
            this.notifyObservers();
        }

        private void updateInterpreters() {
            ProjectWizardFirstPage.this.handlePossibleInterpreterChange();
        }

        protected String getDefaultPath(String name) {
            IEnvironment environment = this.getEnvironment();
            if (environment != null && environment.isLocal()) {
                IPath path = Platform.getLocation().append(name);
                return path.toOSString();
            }
            return "";
        }

        public void update(Observable o, Object arg) {
            if (this.isInWorkspace()) {
                this.fLocation.setText(this.getDefaultPath(ProjectWizardFirstPage.this.fNameGroup.getName()));
            }
            this.fireEvent();
        }

        public IPath getLocation() {
            if (this.isInWorkspace()) {
                return Platform.getLocation();
            }
            return new Path(this.fLocation.getText().trim());
        }

        public boolean isInWorkspace() {
            return this.fWorkspaceRadio.isSelected();
        }

        public boolean isExternalProject() {
            return this.fExternalRadio.isSelected();
        }

        public IEnvironment getEnvironment() {
            if (this.isInWorkspace()) {
                return EnvironmentManager.getLocalEnvironment();
            }
            int index = this.fEnvironment.getSelectionIndex();
            if (index >= 0 && index < this.environments.length) {
                return this.environments[index];
            }
            return EnvironmentManager.getLocalEnvironment();
        }

        public void changeControlPressed(DialogField field) {
            IEnvironment environment = this.getEnvironment();
            IEnvironmentUI environmentUI = (IEnvironmentUI)environment.getAdapter(IEnvironmentUI.class);
            if (environmentUI != null) {
                String selectedDirectory;
                String prevLocation;
                IDialogSettings dSettings;
                String savedEnvId;
                String directoryName = this.fLocation.getText().trim();
                if (directoryName.length() == 0 && ((savedEnvId = (dSettings = DLTKUIPlugin.getDefault().getDialogSettings()).get(DIALOGSTORE_LAST_EXTERNAL_ENVIRONMENT)) == null || savedEnvId.equals(environment.getId())) && (prevLocation = dSettings.get(DIALOGSTORE_LAST_EXTERNAL_LOC)) != null) {
                    directoryName = prevLocation;
                }
                if ((selectedDirectory = environmentUI.selectFolder(ProjectWizardFirstPage.this.getShell(), directoryName)) != null) {
                    IDialogSettings dSettings2 = DLTKUIPlugin.getDefault().getDialogSettings();
                    this.fLocation.setText(selectedDirectory);
                    dSettings2.put(DIALOGSTORE_LAST_EXTERNAL_LOC, selectedDirectory);
                    dSettings2.put(DIALOGSTORE_LAST_EXTERNAL_ENVIRONMENT, environment.getId());
                }
            }
        }

        protected boolean isModeField(DialogField field, int kind) {
            switch (kind) {
                case 0: {
                    return field == this.fWorkspaceRadio || field == this.fExternalRadio;
                }
                case 1: {
                    return field == this.fWorkspaceRadio;
                }
                case 2: {
                    return field == this.fExternalRadio;
                }
            }
            return false;
        }

        public void dialogFieldChanged(DialogField field) {
            if (this.isModeField(field, 0)) {
                boolean external = this.isExternalProject();
                this.fLocation.setEnabled(external);
                this.fEnvironment.setEnabled(external);
            }
            if (this.isModeField(field, 1)) {
                boolean checked = this.isInWorkspace();
                if (checked) {
                    this.fPreviousExternalLocation = this.fLocation.getText();
                    this.fLocation.setText(this.getDefaultPath(ProjectWizardFirstPage.this.fNameGroup.getName()));
                } else {
                    IEnvironment environment = this.getEnvironment();
                    if (environment != null && environment.isLocal()) {
                        this.fLocation.setText(this.fPreviousExternalLocation);
                    } else {
                        this.fLocation.setText("");
                    }
                }
                this.updateInterpreters();
            }
            if (this.isModeField(field, 2)) {
                this.updateInterpreters();
            }
            this.fireEvent();
        }

        protected void dispose() {
            if (this.environmentChangedListener != null) {
                EnvironmentManager.removeEnvironmentChangedListener((IEnvironmentChangedListener)this.environmentChangedListener);
                this.environmentChangedListener = null;
            }
        }

        public IStatus validate(IProject handle) {
            IStatus locationStatus;
            String location = this.getLocation().toOSString();
            if (location.length() == 0) {
                return new StatusInfo(2, NewWizardMessages.ScriptProjectWizardFirstPage_Message_enterLocation);
            }
            if (!Path.EMPTY.isValidPath(location)) {
                return new StatusInfo(4, NewWizardMessages.ScriptProjectWizardFirstPage_Message_invalidDirectory);
            }
            IPath projectPath = Path.fromOSString((String)location);
            IEnvironment environment = this.getEnvironment();
            if (!this.isInWorkspace() && environment.isLocal() && Platform.getLocation().isPrefixOf(projectPath)) {
                return new StatusInfo(4, NewWizardMessages.ScriptProjectWizardFirstPage_Message_cannotCreateInWorkspace);
            }
            if (!this.isInWorkspace() && environment.isLocal() && !(locationStatus = DLTKUIPlugin.getWorkspace().validateProjectLocation(handle, projectPath)).isOK()) {
                return new StatusInfo(4, locationStatus.getMessage());
            }
            return Status.OK_STATUS;
        }
    }

    private class LocationObservers
    implements Observer {
        final ListenerList observers = new ListenerList();

        private LocationObservers() {
        }

        public void update(Observable o, Object arg) {
            Object[] listeners = this.observers.getListeners();
            int i = 0;
            while (i < listeners.length) {
                ((ILocationGroup.Listener)listeners[i]).update(ProjectWizardFirstPage.this, arg);
                ++i;
            }
        }
    }

    public final class NameGroup
    extends Observable
    implements IDialogFieldListener {
        protected final StringDialogField fNameField;

        public NameGroup(Composite composite, String initialName) {
            Composite nameComposite = new Composite(composite, 0);
            nameComposite.setFont(composite.getFont());
            nameComposite.setLayout((Layout)ProjectWizardFirstPage.this.initGridLayout(new GridLayout(2, false), false));
            nameComposite.setLayoutData((Object)new GridData(768));
            this.fNameField = new StringDialogField();
            this.fNameField.setLabelText(NewWizardMessages.ScriptProjectWizardFirstPage_NameGroup_label_text);
            this.fNameField.setDialogFieldListener(this);
            this.setName(initialName);
            this.fNameField.doFillIntoGrid(nameComposite, 2);
            LayoutUtil.setHorizontalGrabbing((Control)this.fNameField.getTextControl(null));
        }

        protected void fireEvent() {
            this.setChanged();
            this.notifyObservers();
        }

        public String getName() {
            return this.fNameField.getText().trim();
        }

        public void postSetFocus() {
            this.fNameField.postSetFocusOnDialogField(ProjectWizardFirstPage.this.getShell().getDisplay());
        }

        public void setName(String name) {
            this.fNameField.setText(name);
        }

        public void dialogFieldChanged(DialogField field) {
            this.fireEvent();
        }
    }

    private final class Validator
    implements Observer {
        private Validator() {
        }

        public void update(Observable o, Object arg) {
            IStatus projectStatus = ProjectWizardFirstPage.this.validateProject();
            if (projectStatus == null && (projectStatus = ProjectWizardFirstPage.this.fLocationGroup.validate(ProjectWizardFirstPage.this.getProjectHandle())).isOK()) {
                projectStatus = null;
            }
            if (projectStatus != null) {
                if (projectStatus.getSeverity() != 4) {
                    ProjectWizardFirstPage.this.setErrorMessage(null);
                    ProjectWizardFirstPage.this.setMessage(projectStatus.getMessage());
                } else {
                    ProjectWizardFirstPage.this.setErrorMessage(projectStatus.getMessage());
                }
                ProjectWizardFirstPage.this.setPageComplete(false);
                return;
            }
            if (ProjectWizardFirstPage.this.supportInterpreter() && ProjectWizardFirstPage.this.interpeterRequired() && !ProjectWizardFirstPage.this.interpretersPresent) {
                ProjectWizardFirstPage.this.setErrorMessage(NewWizardMessages.ProjectWizardFirstPage_atLeastOneInterpreterMustBeConfigured);
                ProjectWizardFirstPage.this.setPageComplete(false);
                return;
            }
            ProjectWizardFirstPage.this.setPageComplete(true);
            ProjectWizardFirstPage.this.setErrorMessage(null);
            ProjectWizardFirstPage.this.setMessage(null);
        }
    }
}

