/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.internal.ui.editor;

import org.eclipse.dltk.internal.ui.editor.BracketInserter;
import org.eclipse.dltk.internal.ui.editor.ScriptEditor;
import org.eclipse.dltk.tcl.internal.ui.TclUI;
import org.eclipse.dltk.ui.DLTKUIPlugin;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.texteditor.ITextEditorExtension3;

public class TclBracketInserter
extends BracketInserter {
    TclBracketInserter(ScriptEditor scriptEditor) {
        super(scriptEditor);
    }

    private boolean isCloseStrings() {
        return TclUI.getDefault().getPreferenceStore().getBoolean("closeStrings");
    }

    public void verifyKey(VerifyEvent event) {
        if (!event.doit || this.editor.getInsertMode() != ITextEditorExtension3.SMART_INSERT) {
            return;
        }
        switch (event.character) {
            case '\"': {
                break;
            }
            default: {
                return;
            }
        }
        ISourceViewer sourceViewer = this.editor.getScriptSourceViewer();
        IDocument document = sourceViewer.getDocument();
        Point selection = sourceViewer.getSelectedRange();
        int offset = selection.x;
        int length = selection.y;
        try {
            IRegion startLine = document.getLineInformationOfOffset(offset);
            IRegion endLine = document.getLineInformationOfOffset(offset + length);
            char nextToken = offset + length < endLine.getOffset() + endLine.getLength() ? document.getChar(offset + length) : (char)'\u0000';
            char prevToken = offset > startLine.getOffset() ? document.getChar(offset - 1) : (char)'\u0000';
            switch (event.character) {
                case '\"': {
                    if (this.isCloseStrings() && (nextToken == '\u0000' || Character.isWhitespace(nextToken)) && (prevToken == '\u0000' || Character.isWhitespace(prevToken))) break;
                    return;
                }
                default: {
                    return;
                }
            }
            int correctedOffset = document.getLength() > 0 && document.getLength() == offset ? offset - 1 : offset;
            ITypedRegion partition = TextUtilities.getPartition((IDocument)document, (String)"__tcl_partitioning", (int)correctedOffset, (boolean)true);
            if (!"__dftl_partition_content_type".equals(partition.getType())) {
                return;
            }
            if (!this.editor.validateEditorInputState()) {
                return;
            }
            this.insertBrackets(document, offset, length, event.character, TclBracketInserter.getPeerCharacter((char)event.character));
            event.doit = false;
        }
        catch (BadLocationException e) {
            DLTKUIPlugin.log((Throwable)e);
        }
        catch (BadPositionCategoryException e) {
            DLTKUIPlugin.log((Throwable)e);
        }
    }
}

