/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.utils;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LazyExtensionManager<E>
implements Iterable<E> {
    private final String extensionPoint;
    protected final String classAttr = "class";
    private List<Descriptor<E>> extensions;

    public LazyExtensionManager(String extensionPoint) {
        this.extensionPoint = extensionPoint;
    }

    public Descriptor<E>[] getDescriptors() {
        return this.internalGetInstances();
    }

    private synchronized Descriptor<E>[] internalGetInstances() {
        if (this.extensions == null) {
            this.initialize();
        }
        Descriptor[] resultArray = new Descriptor[this.extensions.size()];
        this.extensions.toArray(resultArray);
        return resultArray;
    }

    @Override
    public Iterator<E> iterator() {
        return new InstanceIterator<E>(this.internalGetInstances());
    }

    public Iterator<Descriptor<E>> descriptorIterator() {
        return new DescriptorIterator<E>(this.internalGetInstances());
    }

    synchronized void remove(Descriptor<E> descriptor) {
        if (this.extensions != null) {
            this.extensions.remove(descriptor);
        }
    }

    private void initialize() {
        this.extensions = new ArrayList<Descriptor<E>>(5);
        this.registerConfigurationElements();
        this.initializeDescriptors(this.extensions);
    }

    protected void registerConfigurationElements() {
        this.registerConfigurationElements(Platform.getExtensionRegistry().getConfigurationElementsFor(this.extensionPoint));
    }

    protected void registerConfigurationElements(IConfigurationElement[] confElements) {
        int i = 0;
        while (i < confElements.length) {
            IConfigurationElement confElement = confElements[i];
            Descriptor<E> descriptor = this.createDescriptor(confElement);
            if (this.isValidDescriptor(descriptor)) {
                this.extensions.add(descriptor);
            }
            ++i;
        }
    }

    protected Descriptor<E> createDescriptor(IConfigurationElement confElement) {
        return new Descriptor(this, confElement);
    }

    protected boolean isValidDescriptor(Descriptor<E> descriptor) {
        return descriptor != null;
    }

    protected void initializeDescriptors(List<Descriptor<E>> descriptors) {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Descriptor<E> {
        private final LazyExtensionManager<E> manager;
        private final IConfigurationElement configurationElement;
        private E instance;
        private boolean valid;

        public Descriptor(LazyExtensionManager<E> manager, IConfigurationElement configurationElement) {
            this.manager = manager;
            this.configurationElement = configurationElement;
            this.valid = true;
        }

        public synchronized E get() {
            if (this.instance != null) {
                return this.instance;
            }
            if (!this.valid) {
                return null;
            }
            try {
                this.instance = this.configurationElement.createExecutableExtension(this.manager.classAttr);
                return this.instance;
            }
            catch (CoreException coreException) {
                this.valid = false;
                this.manager.remove(this);
                return null;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DescriptorIterator<E>
    implements Iterator<Descriptor<E>> {
        private final Descriptor<E>[] descriptors;
        private int index = 0;
        private boolean nextEvaluated = false;
        private Descriptor<E> next = null;

        public DescriptorIterator(Descriptor<E>[] descriptors) {
            this.descriptors = descriptors;
        }

        @Override
        public boolean hasNext() {
            if (!this.nextEvaluated) {
                this.evaluateNext();
                this.nextEvaluated = true;
            }
            return this.next != null;
        }

        private void evaluateNext() {
            while (this.index < this.descriptors.length) {
                this.next = this.descriptors[this.index++];
                if (this.next == null) continue;
                return;
            }
        }

        @Override
        public Descriptor<E> next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Descriptor<E> result = this.next;
            this.next = null;
            this.nextEvaluated = false;
            return result;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class InstanceIterator<E>
    implements Iterator<E> {
        private final Descriptor<E>[] descriptors;
        private int index = 0;
        private boolean nextEvaluated = false;
        private E next = null;

        public InstanceIterator(Descriptor<E>[] descriptors) {
            this.descriptors = descriptors;
        }

        @Override
        public boolean hasNext() {
            if (!this.nextEvaluated) {
                this.evaluateNext();
                this.nextEvaluated = true;
            }
            return this.next != null;
        }

        private void evaluateNext() {
            while (this.index < this.descriptors.length) {
                this.next = this.descriptors[this.index++].get();
                if (this.next == null) continue;
                return;
            }
        }

        @Override
        public E next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            E result = this.next;
            this.next = null;
            this.nextEvaluated = false;
            return result;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

