/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.core.builder;

import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.dltk.compiler.problem.CategorizedProblem;
import org.eclipse.dltk.compiler.problem.IProblem;
import org.eclipse.dltk.compiler.problem.ProblemCollector;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.internal.core.builder.Messages;
import org.eclipse.dltk.internal.core.util.Util;

public class BuildProblemReporter
extends ProblemCollector {
    private final IResource resource;
    private boolean oldMarkersDeleted = false;

    public BuildProblemReporter(IResource resource) {
        this.resource = resource;
    }

    public void flush() {
        try {
            if (!this.oldMarkersDeleted) {
                this.oldMarkersDeleted = true;
                this.resource.deleteMarkers("org.eclipse.dltk.core.problem", true, 2);
                this.resource.deleteMarkers("org.eclipse.dltk.core.task", true, 2);
            }
            for (IProblem problem : this.problems) {
                String[] arguments;
                String markerType = problem instanceof CategorizedProblem ? ((CategorizedProblem)problem).getMarkerType() : "org.eclipse.dltk.core.problem";
                IMarker m = this.resource.createMarker(markerType);
                m.setAttribute("lineNumber", problem.getSourceLineNumber() + 1);
                m.setAttribute("message", (Object)problem.getMessage());
                m.setAttribute("charStart", problem.getSourceStart());
                m.setAttribute("charEnd", problem.getSourceEnd());
                if ("org.eclipse.dltk.core.problem".equals(markerType)) {
                    int severity = 0;
                    if (problem.isError()) {
                        severity = 2;
                    } else if (problem.isWarning()) {
                        severity = 1;
                    }
                    m.setAttribute("severity", severity);
                } else {
                    m.setAttribute("userEditable", (Object)Boolean.FALSE);
                    if (problem instanceof ProblemCollector.TaskInfo) {
                        m.setAttribute("priority", ((ProblemCollector.TaskInfo)problem).getPriority());
                    }
                }
                if (problem.getID() != 0) {
                    m.setAttribute("id", problem.getID());
                }
                if ((arguments = problem.getArguments()) == null || arguments.length == 0) continue;
                m.setAttribute("arguments", (Object)Util.getProblemArgumentsForMarker(arguments));
            }
            this.problems.clear();
        }
        catch (CoreException e) {
            DLTKCore.error(Messages.BuildProblemReporter_errorUpdatingMarkers, e);
        }
    }
}

