/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.core.search.indexing.core;

import java.io.IOException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.search.index.Index;
import org.eclipse.dltk.core.search.indexing.IProjectIndexer;
import org.eclipse.dltk.core.search.indexing.ReadWriteMonitor;
import org.eclipse.dltk.core.search.indexing.core.IndexRequest;

public class SourceModuleRequest
extends IndexRequest {
    protected final ISourceModule module;
    protected final IDLTKLanguageToolkit toolkit;

    public SourceModuleRequest(IProjectIndexer indexer, ISourceModule module, IDLTKLanguageToolkit toolkit) {
        super(indexer);
        this.module = module;
        this.toolkit = toolkit;
    }

    protected String getName() {
        return this.module.getElementName();
    }

    protected void run() throws CoreException, IOException {
        IScriptProject project = this.module.getScriptProject();
        Index index = this.getIndexer().getProjectIndex(project);
        ReadWriteMonitor imon = index.monitor;
        imon.enterWrite();
        try {
            this.getIndexer().indexSourceModule(index, this.toolkit, this.module, project.getPath());
        }
        finally {
            imon.exitWrite();
        }
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.module == null ? 0 : this.module.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SourceModuleRequest other = (SourceModuleRequest)obj;
        return !(this.module == null ? other.module != null : !this.module.equals(other.module));
    }
}

