/*
 * Decompiled with CFR 0.152.
 */
package com.xored.org.mozilla.javascript;

import com.xored.org.mozilla.javascript.Context;
import com.xored.org.mozilla.javascript.Function;
import com.xored.org.mozilla.javascript.IdFunctionCall;
import com.xored.org.mozilla.javascript.IdFunctionObject;
import com.xored.org.mozilla.javascript.Kit;
import com.xored.org.mozilla.javascript.NativeJavaPackage;
import com.xored.org.mozilla.javascript.Scriptable;
import com.xored.org.mozilla.javascript.ScriptableObject;
import com.xored.org.mozilla.javascript.Wrapper;

public class NativeJavaTopPackage
extends NativeJavaPackage
implements Function,
IdFunctionCall {
    static final long serialVersionUID = -1455787259477709999L;
    private static final String commonPackages = "java.lang;java.lang.reflect;java.io;java.math;java.net;java.util;java.util.zip;java.text;java.text.resources;java.applet;javax.swing;";
    private static final Object FTAG = new Object();
    private static final int Id_getClass = 1;

    NativeJavaTopPackage(ClassLoader loader) {
        super(true, "", loader);
    }

    public Object call(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        return this.construct(cx, scope, args);
    }

    public Scriptable construct(Context cx, Scriptable scope, Object[] args) {
        ClassLoader loader = null;
        if (args.length != 0) {
            Object arg = args[0];
            if (arg instanceof Wrapper) {
                arg = ((Wrapper)arg).unwrap();
            }
            if (arg instanceof ClassLoader) {
                loader = (ClassLoader)arg;
            }
        }
        if (loader == null) {
            Context.reportRuntimeError0("msg.not.classloader");
            return null;
        }
        return new NativeJavaPackage(true, "", loader);
    }

    public static void init(Context cx, Scriptable scope, boolean sealed) {
        ClassLoader loader = cx.getApplicationClassLoader();
        NativeJavaTopPackage top = new NativeJavaTopPackage(loader);
        top.setPrototype(NativeJavaTopPackage.getObjectPrototype(scope));
        top.setParentScope(scope);
        String[] names = Kit.semicolonSplit(commonPackages);
        int i = 0;
        while (i != names.length) {
            top.forcePackage(names[i], scope);
            ++i;
        }
        IdFunctionObject getClass = new IdFunctionObject(top, FTAG, 1, "getClass", 1, scope);
        NativeJavaPackage javaAlias = (NativeJavaPackage)top.get("java", (Scriptable)top);
        ScriptableObject global = (ScriptableObject)scope;
        if (sealed) {
            getClass.sealObject();
        }
        getClass.exportAsScopeProperty();
        global.defineProperty("Packages", top, 2);
        global.defineProperty("java", javaAlias, 2);
    }

    public Object execIdCall(IdFunctionObject f, Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        if (f.hasTag(FTAG) && f.methodId() == 1) {
            return this.js_getClass(cx, scope, args);
        }
        throw f.unknown();
    }

    private Scriptable js_getClass(Context cx, Scriptable scope, Object[] args) {
        if (args.length > 0 && args[0] instanceof Wrapper) {
            int index;
            String propName;
            Object prop;
            Scriptable result = this;
            Class<?> cl = ((Wrapper)args[0]).unwrap().getClass();
            String name = cl.getName();
            int offset = 0;
            while ((prop = result.get(propName = (index = name.indexOf(46, offset)) == -1 ? name.substring(offset) : name.substring(offset, index), result)) instanceof Scriptable) {
                result = (Scriptable)prop;
                if (index == -1) {
                    return result;
                }
                offset = index + 1;
            }
        }
        throw Context.reportRuntimeError0("msg.not.java.obj");
    }
}

