/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.validators.core;

import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.environment.EnvironmentManager;
import org.eclipse.dltk.core.environment.IEnvironment;
import org.eclipse.dltk.validators.core.IValidator;
import org.eclipse.dltk.validators.core.IValidatorType;
import org.eclipse.dltk.validators.core.ValidatorRuntime;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class AbstractValidator
implements IValidator,
Cloneable {
    private static final String ATTR_ACTIVE = "active";
    private static final String ATTR_NAME = "name";
    private final String id;
    private String name;
    private final IValidatorType type;
    private boolean automatic = true;
    private boolean workingCopy;

    protected AbstractValidator(String id, String name, IValidatorType type) {
        this.id = id;
        this.type = type;
        this.name = name;
    }

    public String getID() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public final void loadFrom(Element element) {
        boolean savedWorkingCopy = this.workingCopy;
        this.workingCopy = true;
        try {
            this.load(element);
        }
        finally {
            this.workingCopy = savedWorkingCopy;
        }
    }

    protected void load(Element element) {
        if (!this.type.isBuiltin()) {
            this.name = element.getAttribute(ATTR_NAME);
        }
        this.automatic = this.loadBoolean(element, ATTR_ACTIVE);
    }

    protected boolean loadBoolean(Element element, String attribute) {
        return Boolean.valueOf(element.getAttribute(attribute));
    }

    public void storeTo(Document doc, Element element) {
        element.setAttribute(ATTR_NAME, this.getName());
        element.setAttribute(ATTR_ACTIVE, Boolean.toString(this.isAutomatic()));
    }

    public IValidatorType getValidatorType() {
        return this.type;
    }

    public void setName(String name) {
        this.name = name;
        this.fireChanged();
    }

    public boolean isAutomatic() {
        return this.automatic;
    }

    public boolean isAutomatic(IScriptProject project) {
        return this.isAutomatic();
    }

    public void setAutomatic(boolean value) {
        this.automatic = value;
        this.fireChanged();
    }

    protected void fireChanged() {
        if (!this.workingCopy) {
            ValidatorRuntime.fireValidatorChanged(this);
        }
    }

    public boolean isWorkingCopy() {
        return this.workingCopy;
    }

    public IValidator getWorkingCopy() {
        if (this.isWorkingCopy()) {
            return this;
        }
        try {
            AbstractValidator copy = (AbstractValidator)this.clone();
            copy.workingCopy = true;
            return copy;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    protected IEnvironment getEnvrironment(IScriptProject project) {
        return EnvironmentManager.getEnvironment((IModelElement)project);
    }
}

