/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.core.tests.model;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourceAttributes;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IBuildpathEntry;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IParent;
import org.eclipse.dltk.core.IProjectFragment;
import org.eclipse.dltk.core.IScriptFolder;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.tests.model.AbstractModelTests;
import org.eclipse.dltk.core.tests.util.Util;
import org.eclipse.dltk.internal.core.ModelElement;

public class ModifyingResourceTests
extends AbstractModelTests {
    public ModifyingResourceTests(String testProjectName, String name) {
        super(testProjectName, name);
    }

    protected void assertElementDescendants(String message, String expected, IModelElement element) throws CoreException {
        String actual = this.expandAll(element);
        if (!expected.equals(actual)) {
            System.out.println(Util.displayString(actual, 4));
        }
        ModifyingResourceTests.assertEquals((String)message, (String)expected, (String)actual);
    }

    protected IFile createFile(String path, InputStream content) throws CoreException {
        IFile file = this.getFile(path);
        file.create(content, true, null);
        return file;
    }

    protected IFile createFile(String path, byte[] content) throws CoreException {
        return this.createFile(path, new ByteArrayInputStream(content));
    }

    protected IFile createFile(String path, String content) throws CoreException {
        return this.createFile(path, content.getBytes());
    }

    protected IFile createFile(String path, String content, String charsetName) throws CoreException, UnsupportedEncodingException {
        return this.createFile(path, content.getBytes(charsetName));
    }

    protected IFolder createFolder(String path) throws CoreException {
        return this.createFolder((IPath)new Path(path));
    }

    protected void deleteFile(String filePath) throws CoreException {
        this.deleteResource((IResource)this.getFile(filePath));
    }

    protected void deleteFolder(String folderPath) throws CoreException {
        this.deleteFolder((IPath)new Path(folderPath));
    }

    protected IFile editFile(String path, String content) throws CoreException {
        IFile file = this.getFile(path);
        ByteArrayInputStream input = new ByteArrayInputStream(content.getBytes());
        file.setContents((InputStream)input, 1, null);
        return file;
    }

    protected String expandAll(IModelElement element) throws CoreException {
        StringBuffer buffer = new StringBuffer();
        this.expandAll(element, 0, buffer);
        return buffer.toString();
    }

    private void expandAll(IModelElement element, int tab, StringBuffer buffer) throws CoreException {
        IModelElement[] children = null;
        if (element instanceof IParent) {
            IParent parent = (IParent)element;
            children = parent.getChildren();
        }
        ((ModelElement)element).toStringInfo(tab, buffer);
        if (children != null) {
            int i = 0;
            int length = children.length;
            while (i < length) {
                buffer.append("\n");
                this.expandAll(children[i], tab + 1, buffer);
                ++i;
            }
        }
    }

    protected void renameProject(String project, String newName) throws CoreException {
        this.getProject(project).move((IPath)new Path(newName), true, null);
    }

    protected ISourceModule getSourceModule(String path) {
        return (ISourceModule)DLTKCore.create((IFile)this.getFile(path));
    }

    protected IFolder getFolder(String path) {
        return this.getFolder((IPath)new Path(path));
    }

    protected IScriptFolder getPackage(String path) {
        if (path.indexOf(47, 1) != -1) {
            IModelElement element = DLTKCore.create((IResource)this.getFolder(path));
            if (element instanceof IProjectFragment) {
                return ((IProjectFragment)element).getScriptFolder((IPath)new Path(""));
            }
            return (IScriptFolder)element;
        }
        IProject project = this.getProject(path);
        return DLTKCore.create((IProject)project).getProjectFragment((IResource)project).getScriptFolder((IPath)new Path(""));
    }

    protected IProjectFragment getProjectFragment(String path) {
        if (path.indexOf(47, 1) != -1) {
            if (path.endsWith(".jar")) {
                return (IProjectFragment)DLTKCore.create((IFile)this.getFile(path));
            }
            return (IProjectFragment)DLTKCore.create((IResource)this.getFolder(path));
        }
        IProject project = this.getProject(path);
        return DLTKCore.create((IProject)project).getProjectFragment((IResource)project);
    }

    protected void moveFile(String sourcePath, String destPath) throws CoreException {
        this.getFile(sourcePath).move(this.getFile(destPath).getFullPath(), false, null);
    }

    protected void moveFolder(String sourcePath, String destPath) throws CoreException {
        this.getFolder(sourcePath).move(this.getFolder(destPath).getFullPath(), false, null);
    }

    protected void swapFiles(String firstPath, String secondPath) throws CoreException {
        final IFile first = this.getFile(firstPath);
        final IFile second = this.getFile(secondPath);
        IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                IPath tempPath = first.getParent().getFullPath().append("swappingFile.temp");
                first.move(tempPath, false, monitor);
                second.move(first.getFullPath(), false, monitor);
                ModifyingResourceTests.this.getWorkspaceRoot().getFile(tempPath).move(second.getFullPath(), false, monitor);
            }
        };
        this.getWorkspace().run(runnable, null);
    }

    protected IBuildpathEntry[] createBuildpath(String[] foldersAndPatterns) {
        int length = foldersAndPatterns.length;
        int increment = 1;
        IBuildpathEntry[] buildpath = new IBuildpathEntry[length / increment];
        int i = 0;
        while (i < length) {
            String src = foldersAndPatterns[i];
            Path folderPath = new Path(src);
            buildpath[i / increment] = DLTKCore.newSourceEntry((IPath)folderPath);
            i += increment;
        }
        return buildpath;
    }

    protected IBuildpathEntry[] createBuildpath(String[] foldersAndPatterns, boolean hasInclusionPatterns, boolean hasExclusionPatterns) {
        int length = foldersAndPatterns.length;
        int increment = 1;
        if (hasInclusionPatterns) {
            ++increment;
        }
        if (hasExclusionPatterns) {
            ++increment;
        }
        IBuildpathEntry[] buildpath = new IBuildpathEntry[length / increment];
        int i = 0;
        while (i < length) {
            String src = foldersAndPatterns[i];
            IPath[] accessibleFiles = new IPath[]{};
            if (hasInclusionPatterns) {
                String patterns = foldersAndPatterns[i + 1];
                StringTokenizer tokenizer = new StringTokenizer(patterns, "|");
                int patternsCount = tokenizer.countTokens();
                accessibleFiles = new IPath[patternsCount];
                int j = 0;
                while (j < patternsCount) {
                    accessibleFiles[j] = new Path(tokenizer.nextToken());
                    ++j;
                }
            }
            IPath[] nonAccessibleFiles = new IPath[]{};
            if (hasExclusionPatterns) {
                String patterns = foldersAndPatterns[i + increment - 1];
                StringTokenizer tokenizer = new StringTokenizer(patterns, "|");
                int patternsCount = tokenizer.countTokens();
                nonAccessibleFiles = new IPath[patternsCount];
                int j = 0;
                while (j < patternsCount) {
                    nonAccessibleFiles[j] = new Path(tokenizer.nextToken());
                    ++j;
                }
            }
            Path folderPath = new Path(src);
            buildpath[i / increment] = DLTKCore.newSourceEntry((IPath)folderPath, (IPath[])accessibleFiles, (IPath[])nonAccessibleFiles);
            i += increment;
        }
        return buildpath;
    }

    public void setReadOnly(IResource resource, boolean readOnly) throws CoreException {
        ResourceAttributes resourceAttributes = resource.getResourceAttributes();
        if (resourceAttributes != null) {
            resourceAttributes.setReadOnly(readOnly);
            resource.setResourceAttributes(resourceAttributes);
        }
    }

    public boolean isReadOnly(IResource resource) throws CoreException {
        ResourceAttributes resourceAttributes = resource.getResourceAttributes();
        if (resourceAttributes != null) {
            return resourceAttributes.isReadOnly();
        }
        return false;
    }
}

