/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.formatter.internal.nodes;

import org.eclipse.dltk.formatter.FormatterTextNode;
import org.eclipse.dltk.formatter.IFormatterContext;
import org.eclipse.dltk.formatter.IFormatterDocument;
import org.eclipse.dltk.formatter.IFormatterWriter;
import org.eclipse.dltk.javascript.formatter.internal.JavaScriptFormatterContext;

public class FormatterCommentNode
extends FormatterTextNode {
    private final boolean multiLine;

    public FormatterCommentNode(IFormatterDocument document, int startOffset, int endOffset, boolean multiLine) {
        super(document, startOffset, endOffset);
        this.multiLine = multiLine;
    }

    public void accept(IFormatterContext context, IFormatterWriter visitor) throws Exception {
        context.setComment(true);
        if (this.multiLine) {
            visitor.ensureLineStarted(context);
            JavaScriptFormatterContext copy = (JavaScriptFormatterContext)context.copy();
            copy.setAdditionalIndent(" ");
            super.accept((IFormatterContext)copy, visitor);
        } else {
            super.accept(context, visitor);
            visitor.disableAppendToPreviousLine();
        }
        context.setComment(false);
    }
}

