/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.debug.ui.interpreters;

import java.io.File;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.internal.ui.DebugPluginImages;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchConfigurationsMessages;
import org.eclipse.dltk.core.environment.IEnvironment;
import org.eclipse.dltk.core.environment.IExecutionEnvironment;
import org.eclipse.dltk.core.environment.IFileHandle;
import org.eclipse.dltk.internal.debug.ui.interpreters.AddScriptInterpreterDialog;
import org.eclipse.dltk.internal.debug.ui.interpreters.EnvironmentVariableContentProvider;
import org.eclipse.dltk.internal.debug.ui.interpreters.EnvironmentVariablesFileUtils;
import org.eclipse.dltk.internal.debug.ui.interpreters.InterpretersMessages;
import org.eclipse.dltk.internal.debug.ui.interpreters.MultipleInputDialog;
import org.eclipse.dltk.launching.EnvironmentVariable;
import org.eclipse.dltk.launching.IInterpreterInstall;
import org.eclipse.dltk.launching.IInterpreterInstallType;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.ui.dialogs.ListSelectionDialog;

public abstract class AbstractInterpreterEnvironmentVariablesBlock
implements SelectionListener,
ISelectionChangedListener {
    private static final String VALUE_LABEL = InterpretersMessages.AbstractInterpreterEnvironmentVariablesBlock_value;
    private static final String NAME_LABEL = InterpretersMessages.AbstractInterpreterEnvironmentVariablesBlock_name;
    protected static final String LAST_PATH_SETTING = "LAST_PATH_SETTING";
    protected static final String DIALOG_SETTINGS_PREFIX = "AbstractInterpreterEnvironmentVariablesBlock";
    protected boolean fInCallback = false;
    protected IInterpreterInstall fInterpreterInstall;
    protected IInterpreterInstallType fInterpreterInstallType;
    protected EnvironmentVariableContentProvider fEnvironmentVariablesContentProvider;
    protected TreeViewer fVariablesViewer;
    private Button fRemoveButton;
    private Button fAddExistedButton;
    private Button fAddButton;
    private Button fEditButton;
    private Button fImportButton;
    private Button fExportButton;
    protected AddScriptInterpreterDialog fDialog;
    static /* synthetic */ Class class$0;

    protected AbstractInterpreterEnvironmentVariablesBlock(AddScriptInterpreterDialog dialog) {
        this.fDialog = dialog;
    }

    public Control createControl(Composite parent) {
        Font font = parent.getFont();
        Composite comp = new Composite(parent, 0);
        GridLayout topLayout = new GridLayout();
        topLayout.numColumns = 2;
        topLayout.marginHeight = 0;
        topLayout.marginWidth = 0;
        comp.setLayout((Layout)topLayout);
        GridData gd = new GridData(1808);
        comp.setLayoutData((Object)gd);
        this.fVariablesViewer = new TreeViewer(comp);
        gd = new GridData(1808);
        gd.heightHint = 6;
        this.fVariablesViewer.getControl().setLayoutData((Object)gd);
        this.fEnvironmentVariablesContentProvider = new EnvironmentVariableContentProvider();
        this.fVariablesViewer.setContentProvider((IContentProvider)this.fEnvironmentVariablesContentProvider);
        this.fVariablesViewer.setLabelProvider(this.getLabelProvider());
        this.fVariablesViewer.setInput((Object)this);
        this.fVariablesViewer.addSelectionChangedListener((ISelectionChangedListener)this);
        Composite pathButtonComp = new Composite(comp, 0);
        GridLayout pathButtonLayout = new GridLayout();
        pathButtonLayout.marginHeight = 0;
        pathButtonLayout.marginWidth = 0;
        pathButtonComp.setLayout((Layout)pathButtonLayout);
        gd = new GridData(258);
        pathButtonComp.setLayoutData((Object)gd);
        pathButtonComp.setFont(font);
        this.fAddButton = this.createPushButton(pathButtonComp, InterpretersMessages.AbstractInterpreterEnvironmentVariablesBlock_add);
        this.fAddButton.addSelectionListener((SelectionListener)this);
        this.fAddExistedButton = this.createPushButton(pathButtonComp, InterpretersMessages.AbstractInterpreterEnvironmentVariablesBlock_addFromEnvironment);
        this.fAddExistedButton.addSelectionListener((SelectionListener)this);
        this.fEditButton = this.createPushButton(pathButtonComp, InterpretersMessages.AbstractInterpreterEnvironmentVariablesBlock_edit);
        this.fEditButton.addSelectionListener((SelectionListener)this);
        this.fRemoveButton = this.createPushButton(pathButtonComp, InterpretersMessages.InterpreterLibraryBlock_6);
        this.fRemoveButton.addSelectionListener((SelectionListener)this);
        this.fImportButton = this.createPushButton(pathButtonComp, InterpretersMessages.AbstractInterpreterEnvironmentVariablesBlock_import);
        this.fImportButton.addSelectionListener((SelectionListener)this);
        this.fExportButton = this.createPushButton(pathButtonComp, InterpretersMessages.AbstractInterpreterEnvironmentVariablesBlock_export);
        this.fExportButton.addSelectionListener((SelectionListener)this);
        return comp;
    }

    public void restoreDefaultVariables() {
        this.fEnvironmentVariablesContentProvider.setVariables(new EnvironmentVariable[0]);
        this.update();
    }

    protected Button createPushButton(Composite parent, String label) {
        Button button = new Button(parent, 8);
        button.setFont(parent.getFont());
        button.setText(label);
        this.setButtonLayoutData(button);
        return button;
    }

    protected void createVerticalSpacer(Composite comp, int colSpan) {
        Label label = new Label(comp, 0);
        GridData gd = new GridData();
        gd.horizontalSpan = colSpan;
        label.setLayoutData((Object)gd);
    }

    public void update() {
        this.updateButtons();
        IStatus status = Status.OK_STATUS;
        EnvironmentVariable[] standins = this.fEnvironmentVariablesContentProvider.getStandins();
        int i = 0;
        while (i < standins.length) {
            IStatus st = standins[i].validate();
            if (!st.isOK()) {
                status = st;
                break;
            }
            ++i;
        }
        this.updateDialogStatus(status);
    }

    public void performApply(IInterpreterInstall install) {
        EnvironmentVariable[] libs = this.fEnvironmentVariablesContentProvider.getVariables();
        install.setEnvironmentVariables(libs);
    }

    protected boolean isDefaultLocations() {
        EnvironmentVariable[] def;
        EnvironmentVariable[] EnvironmentVariables = this.fEnvironmentVariablesContentProvider.getVariables();
        IInterpreterInstall install = this.getInterpreterInstall();
        if (install == null || EnvironmentVariables == null) {
            return true;
        }
        IFileHandle installLocation = install.getInstallLocation();
        if (installLocation != null && (def = new EnvironmentVariable[0]).length == EnvironmentVariables.length) {
            int i = 0;
            while (i < def.length) {
                if (!def[i].equals((Object)EnvironmentVariables[i])) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    protected IInterpreterInstall getInterpreterInstall() {
        return this.fInterpreterInstall;
    }

    protected IInterpreterInstallType getInterpreterInstallType() {
        return this.fInterpreterInstallType;
    }

    public void widgetSelected(SelectionEvent e) {
        Object source = e.getSource();
        if (source == this.fRemoveButton) {
            EnvironmentVariable[] old = this.fEnvironmentVariablesContentProvider.getVariables();
            this.fEnvironmentVariablesContentProvider.remove((IStructuredSelection)this.fVariablesViewer.getSelection());
            this.fDialog.updateLibraries(this.fEnvironmentVariablesContentProvider.getVariables(), old);
        } else if (source == this.fAddExistedButton) {
            this.addExisted((IStructuredSelection)this.fVariablesViewer.getSelection());
        } else if (source == this.fAddButton) {
            this.add((IStructuredSelection)this.fVariablesViewer.getSelection());
        } else if (source == this.fEditButton) {
            EnvironmentVariable[] old = this.fEnvironmentVariablesContentProvider.getVariables();
            this.edit((IStructuredSelection)this.fVariablesViewer.getSelection());
            this.fDialog.updateLibraries(this.fEnvironmentVariablesContentProvider.getVariables(), old);
        } else if (source == this.fImportButton) {
            this.performImport();
        } else if (source == this.fExportButton) {
            this.performExport();
        }
        this.update();
    }

    private void performExport() {
        FileDialog dialog = new FileDialog(this.fDialog.getShell(), 8192);
        try {
            Method setOverwriteMethod = dialog.getClass().getMethod("setOverwrite", Boolean.TYPE);
            setOverwriteMethod.invoke((Object)dialog, Boolean.TRUE);
        }
        catch (Exception exception) {}
        dialog.setText(InterpretersMessages.AbstractInterpreterEnvironmentVariablesBlock_exportEnvironmentVariablesToFile);
        String file = dialog.open();
        if (file != null) {
            EnvironmentVariable[] variables = this.fEnvironmentVariablesContentProvider.getVariables();
            try {
                EnvironmentVariablesFileUtils.save(variables, file);
            }
            catch (Exception e) {
                this.showErrorMessage(InterpretersMessages.AbstractInterpreterEnvironmentVariablesBlock_environmentExport, e.getMessage());
            }
        }
    }

    private void showErrorMessage(String title, String text) {
        MessageBox box = new MessageBox(this.fDialog.getShell(), 1);
        box.setText(title);
        box.setMessage(text);
        box.open();
    }

    private void performImport() {
        FileDialog dialog = new FileDialog(this.fDialog.getShell(), 4096);
        dialog.setText(InterpretersMessages.AbstractInterpreterEnvironmentVariablesBlock_importEnvironmentVariablesFromFile);
        String file = dialog.open();
        if (file != null) {
            File handle = new File(file);
            if (!handle.exists()) {
                String text = InterpretersMessages.AbstractInterpreterEnvironmentVariablesBlock_selectedFileDoesntExist;
                this.showErrorMessage(InterpretersMessages.AbstractInterpreterEnvironmentVariablesBlock_environmentImport, text);
                return;
            }
            EnvironmentVariable[] vars = null;
            try {
                vars = EnvironmentVariablesFileUtils.load(file);
            }
            catch (Exception e) {
                this.showErrorMessage(InterpretersMessages.AbstractInterpreterEnvironmentVariablesBlock_environmentImport, e.getMessage());
            }
            if (vars != null) {
                EnvironmentVariable[] variables = this.fEnvironmentVariablesContentProvider.getVariables();
                HashSet<EnvironmentVariable> nvars = new HashSet<EnvironmentVariable>();
                nvars.addAll(Arrays.asList(vars));
                nvars.addAll(Arrays.asList(variables));
                this.fEnvironmentVariablesContentProvider.setVariables(nvars.toArray(new EnvironmentVariable[nvars.size()]));
            }
        }
    }

    private void edit(IStructuredSelection selection) {
        EnvironmentVariable var = (EnvironmentVariable)selection.getFirstElement();
        if (var == null) {
            return;
        }
        String originalName = var.getName();
        String value = var.getValue();
        MultipleInputDialog dialog = new MultipleInputDialog(this.fDialog.getShell(), InterpretersMessages.AbstractInterpreterEnvironmentVariablesBlock_editVariable);
        dialog.addTextField(NAME_LABEL, originalName, false);
        dialog.addVariablesField(VALUE_LABEL, value, true);
        if (dialog.open() != 0) {
            return;
        }
        String name = dialog.getStringValue(NAME_LABEL);
        value = dialog.getStringValue(VALUE_LABEL);
        if (!originalName.equals(name)) {
            this.fEnvironmentVariablesContentProvider.add(new EnvironmentVariable[]{new EnvironmentVariable(name, value)}, selection);
        } else {
            var.setValue(value);
            this.fVariablesViewer.refresh(true);
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    private void add(IStructuredSelection selection) {
        EnvironmentVariable[] libs = this.add();
        if (libs == null) {
            return;
        }
        EnvironmentVariable[] old = this.fEnvironmentVariablesContentProvider.getVariables();
        this.fEnvironmentVariablesContentProvider.add(libs, selection);
        this.fDialog.updateLibraries(this.fEnvironmentVariablesContentProvider.getVariables(), old);
        this.update();
    }

    private EnvironmentVariable[] add() {
        MultipleInputDialog dialog = new MultipleInputDialog(this.fDialog.getShell(), InterpretersMessages.AbstractInterpreterEnvironmentVariablesBlock_addVariable);
        dialog.addTextField(NAME_LABEL, null, false);
        dialog.addVariablesField(VALUE_LABEL, null, true);
        if (dialog.open() != 0) {
            return null;
        }
        String name = dialog.getStringValue(NAME_LABEL);
        String value = dialog.getStringValue(VALUE_LABEL);
        if (name != null && value != null && name.length() > 0 && value.length() > 0) {
            return new EnvironmentVariable[]{new EnvironmentVariable(name.trim(), value.trim())};
        }
        return null;
    }

    private void addExisted(IStructuredSelection selection) {
        EnvironmentVariable[] libs = this.addExisted();
        if (libs == null) {
            return;
        }
        EnvironmentVariable[] old = this.fEnvironmentVariablesContentProvider.getVariables();
        this.fEnvironmentVariablesContentProvider.add(libs, selection);
        this.fDialog.updateLibraries(this.fEnvironmentVariablesContentProvider.getVariables(), old);
        this.update();
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.updateButtons();
    }

    private void updateButtons() {
        IStructuredSelection selection = (IStructuredSelection)this.fVariablesViewer.getSelection();
        this.fRemoveButton.setEnabled(!selection.isEmpty());
        Object[] libraries = this.fEnvironmentVariablesContentProvider.getElements(null);
        if (!selection.isEmpty() && libraries.length != 0) {
            Object first = libraries[0];
            Object last = libraries[libraries.length - 1];
            Iterator iter = selection.iterator();
            while (iter.hasNext()) {
                Object element = iter.next();
                Object lib = element;
                if (lib == first) {
                    // empty if block
                }
                if (lib != last) continue;
            }
        }
    }

    public void initializeFrom(IInterpreterInstall Interpreter, IInterpreterInstallType type) {
        this.fInterpreterInstall = Interpreter;
        this.fInterpreterInstallType = type;
        if (Interpreter != null) {
            this.fEnvironmentVariablesContentProvider.setVariables(this.getInterpreterInstall().getEnvironmentVariables());
        }
        this.update();
    }

    protected abstract IBaseLabelProvider getLabelProvider();

    protected void updateDialogStatus(IStatus status) {
        this.fDialog.setSystemLibraryStatus(status);
        this.fDialog.updateStatusLine();
    }

    protected void setButtonLayoutData(Button button) {
        this.fDialog.setButtonLayoutData(button);
    }

    protected abstract IDialogSettings getDialogSettions();

    protected EnvironmentVariable[] addExisted() {
        Map envVariables = this.getNativeEnvironment();
        if (envVariables.size() == 0) {
            MessageBox box = new MessageBox(this.fDialog.getShell(), 1);
            box.setMessage(NLS.bind((String)InterpretersMessages.AbstractInterpreterEnvironmentVariablesBlock_couldNotRetrieveEnvironmentVariablesFrom, (Object)this.fDialog.getEnvironment().getName()));
            box.setText(InterpretersMessages.AbstractInterpreterEnvironmentVariablesBlock_failedToRetrieveEnvironment);
            box.open();
            return null;
        }
        EnvironmentVariable[] items = this.fEnvironmentVariablesContentProvider.getVariables();
        int i = 0;
        while (i < items.length) {
            EnvironmentVariable var = items[i];
            envVariables.remove(var.getName());
            ++i;
        }
        ListSelectionDialog dialog = new ListSelectionDialog(this.fDialog.getShell(), (Object)envVariables, this.createSelectionDialogContentProvider(), this.createSelectionDialogLabelProvider(), LaunchConfigurationsMessages.EnvironmentTab_19);
        dialog.setTitle(LaunchConfigurationsMessages.EnvironmentTab_20);
        int button = dialog.open();
        if (button == 0) {
            Object[] selected = dialog.getResult();
            EnvironmentVariable[] vars = new EnvironmentVariable[selected.length];
            int i2 = 0;
            while (i2 < vars.length) {
                vars[i2] = (EnvironmentVariable)selected[i2];
                ++i2;
            }
            return vars;
        }
        return null;
    }

    private ILabelProvider createSelectionDialogLabelProvider() {
        return new ILabelProvider(){

            public Image getImage(Object element) {
                return DebugPluginImages.getImage((String)"IMG_OBJS_ENVIRONMENT");
            }

            public String getText(Object element) {
                EnvironmentVariable var = (EnvironmentVariable)element;
                return NLS.bind((String)LaunchConfigurationsMessages.EnvironmentTab_7, (Object)var.getName(), (Object)var.getValue());
            }

            public void addListener(ILabelProviderListener listener) {
            }

            public void dispose() {
            }

            public boolean isLabelProperty(Object element, String property) {
                return false;
            }

            public void removeListener(ILabelProviderListener listener) {
            }
        };
    }

    private IStructuredContentProvider createSelectionDialogContentProvider() {
        return new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                Object[] elements = null;
                if (inputElement instanceof HashMap) {
                    Comparator comparator = new Comparator(this){
                        final /* synthetic */ 2 this$1;
                        {
                            this.this$1 = var1_1;
                        }

                        public int compare(Object o1, Object o2) {
                            String s1 = (String)o1;
                            String s2 = (String)o2;
                            return s1.compareTo(s2);
                        }
                    };
                    TreeMap envVars = new TreeMap(comparator);
                    envVars.putAll((Map)inputElement);
                    elements = new EnvironmentVariable[envVars.size()];
                    int index = 0;
                    Iterator iterator = envVars.keySet().iterator();
                    while (iterator.hasNext()) {
                        Object key = iterator.next();
                        elements[index] = (EnvironmentVariable)envVars.get(key);
                        ++index;
                    }
                }
                return elements;
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        };
    }

    private Map getNativeEnvironment() {
        IEnvironment environment = this.fDialog.getEnvironment();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.dltk.core.environment.IExecutionEnvironment");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        IExecutionEnvironment execEnvironment = (IExecutionEnvironment)environment.getAdapter((Class)clazz);
        Map stringVars = execEnvironment.getEnvironmentVariables(true);
        HashMap<String, EnvironmentVariable> vars = new HashMap<String, EnvironmentVariable>();
        Iterator i = stringVars.keySet().iterator();
        while (i.hasNext()) {
            String key = (String)i.next();
            String value = (String)stringVars.get(key);
            vars.put(key, new EnvironmentVariable(key, value));
        }
        return vars;
    }
}

