/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.dbgp.internal.managers;

import org.eclipse.core.runtime.ListenerList;
import org.eclipse.dltk.dbgp.IDbgpContinuationHandler;
import org.eclipse.dltk.dbgp.internal.DbgpWorkingThread;
import org.eclipse.dltk.dbgp.internal.IDbgpDebugingEngine;
import org.eclipse.dltk.dbgp.internal.managers.IDbgpStreamManager;
import org.eclipse.dltk.dbgp.internal.packets.DbgpStreamPacket;

public class DbgpStreamManager
extends DbgpWorkingThread
implements IDbgpStreamManager {
    private final ListenerList listeners = new ListenerList();
    private final IDbgpDebugingEngine engine;

    protected void fireStderrReceived(String data) {
        Object[] list = this.listeners.getListeners();
        int i = 0;
        while (i < list.length) {
            ((IDbgpContinuationHandler)list[i]).stderrReceived(data);
            ++i;
        }
    }

    protected void fireStdoutReceived(String data) {
        Object[] list = this.listeners.getListeners();
        int i = 0;
        while (i < list.length) {
            ((IDbgpContinuationHandler)list[i]).stdoutReceived(data);
            ++i;
        }
    }

    protected void workingCycle() throws Exception {
        try {
            while (!Thread.interrupted()) {
                DbgpStreamPacket packet = this.engine.getStreamPacket();
                if (packet.isStderr()) {
                    this.fireStderrReceived(packet.getTextContent());
                    continue;
                }
                if (!packet.isStdout()) continue;
                this.fireStdoutReceived(packet.getTextContent());
            }
        }
        catch (InterruptedException interruptedException) {}
    }

    public DbgpStreamManager(IDbgpDebugingEngine engine, String name) {
        super(name);
        if (engine == null) {
            throw new IllegalArgumentException();
        }
        this.engine = engine;
    }

    public void addListener(IDbgpContinuationHandler listener) {
        this.listeners.add((Object)listener);
    }

    public void removeListener(IDbgpContinuationHandler listener) {
        this.listeners.remove((Object)listener);
    }
}

