/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ruby.ast;

import org.eclipse.dltk.ast.DLTKToken;
import org.eclipse.dltk.ast.references.Reference;
import org.eclipse.dltk.utils.CorePrinter;

public class RubySymbolReference
extends Reference {
    private String name;

    public RubySymbolReference(int start, int end, String name) {
        super(start, end);
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public RubySymbolReference(DLTKToken token) {
        this.setStart(token.getColumn());
        this.setEnd(this.sourceStart() + 4);
    }

    public void printNode(CorePrinter output) {
        output.formatPrintLn("RubySymbolReference" + this.getSourceRange().toString());
    }

    public boolean equals(Object obj) {
        if (obj instanceof RubySymbolReference) {
            RubySymbolReference sr = (RubySymbolReference)((Object)obj);
            return this.name.equals(sr.name) && super.equals(obj);
        }
        return false;
    }

    public int hashCode() {
        return super.hashCode() ^ this.name.hashCode();
    }

    public String getStringRepresentation() {
        return this.toString();
    }

    public String toString() {
        return this.name;
    }
}

