/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ruby.internal.debug.ui.preferences;

import org.eclipse.core.runtime.Preferences;
import org.eclipse.dltk.launching.debug.DebuggingEngineManager;
import org.eclipse.dltk.launching.debug.IDebuggingEngine;
import org.eclipse.dltk.ruby.launching.RubyLaunchingPlugin;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class RubyDebugPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private ComboViewer allEngines;
    private Label description;

    protected IDebuggingEngine getSelectedDebuggineEngine() {
        IStructuredSelection selection = (IStructuredSelection)this.allEngines.getSelection();
        if (selection != null) {
            return (IDebuggingEngine)selection.getFirstElement();
        }
        return null;
    }

    protected void setSelectedDebuggingEngine(IDebuggingEngine engine) {
        if (engine != null) {
            this.allEngines.setSelection((ISelection)new StructuredSelection((Object)engine));
        }
    }

    protected void updateDescription(String text) {
        this.description.setText(text);
    }

    protected void createEngineSelector(Composite parent, Object data) {
        Group group = new Group(parent, 0);
        group.setFont(parent.getFont());
        group.setText("Debugging Engine");
        group.setLayoutData(data);
        GridLayout layout = new GridLayout(2, false);
        group.setLayout((Layout)layout);
        Label nameLabel = new Label((Composite)group, 0);
        nameLabel.setText("Select:");
        this.allEngines = new ComboViewer((Composite)group);
        this.allEngines.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return ((IDebuggingEngine)element).getName();
            }
        });
        this.allEngines.add((Object[])DebuggingEngineManager.getInstance().getDebuggingEngines("org.eclipse.dltk.ruby.core.nature"));
        this.allEngines.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                RubyDebugPreferencePage.this.updateDescription(RubyDebugPreferencePage.this.getSelectedDebuggineEngine().getDescription());
            }
        });
        Label descriptionLabel = new Label((Composite)group, 0);
        descriptionLabel.setText("Description:");
        this.description = new Label((Composite)group, 0);
        this.description.setText("");
        this.description.setLayoutData((Object)new GridData(4, 4, true, true));
    }

    protected GridData makeGridData() {
        GridData data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
        return data;
    }

    protected Control createContents(Composite parent) {
        Composite top = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, false);
        top.setLayout((Layout)layout);
        this.createEngineSelector(top, this.makeGridData());
        this.initializeValues();
        return top;
    }

    protected void initializeValues() {
        Preferences prefs = RubyLaunchingPlugin.getDefault().getPluginPreferences();
        String engineId = prefs.getString("debugging_engine_id");
        if (engineId != null) {
            IDebuggingEngine engine = DebuggingEngineManager.getInstance().getDebuggingEngine("org.eclipse.dltk.ruby.core.nature", engineId);
            this.setSelectedDebuggingEngine(engine);
        }
    }

    public void init(IWorkbench workbench) {
    }

    public boolean performOk() {
        Preferences prefs = RubyLaunchingPlugin.getDefault().getPluginPreferences();
        IDebuggingEngine engine = this.getSelectedDebuggineEngine();
        if (engine != null) {
            prefs.setValue("debugging_engine_id", engine.getId());
        }
        RubyLaunchingPlugin.getDefault().savePluginPreferences();
        return true;
    }
}

