/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ruby.internal.parsers.jruby;

import java.util.Stack;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.ast.declarations.ISourceParser;
import org.eclipse.dltk.ast.declarations.MethodDeclaration;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.ast.declarations.TypeDeclaration;
import org.eclipse.dltk.ast.expressions.CallExpression;
import org.eclipse.dltk.ast.statements.Block;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.DLTKLanguageManager;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.ruby.ast.RubyBlock;
import org.eclipse.dltk.ruby.ast.RubyForStatement2;
import org.eclipse.dltk.ruby.ast.RubyIfStatement;
import org.eclipse.dltk.ruby.ast.RubyUnlessStatement;
import org.eclipse.dltk.ruby.ast.RubyUntilStatement;
import org.eclipse.dltk.ruby.ast.RubyWhileStatement;
import org.eclipse.dltk.ruby.internal.parsers.jruby.ASTUtils;

public class ASTUtils {
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    private ASTUtils() {
        throw new AssertionError((Object)"Cannot instantiate utility class");
    }

    public static void setVisibility(MethodDeclaration methodDeclaration, int newVisibility) {
        int modifiers = methodDeclaration.getModifiers();
        methodDeclaration.setModifiers((modifiers &= 0xFFFFFF8F) | newVisibility);
    }

    public static ASTNode[] restoreWayToNode(ModuleDeclaration module, final ASTNode nde) {
        final Stack stack = new Stack();
        ASTVisitor visitor = new ASTVisitor(){
            boolean found = false;

            public boolean visitGeneral(ASTNode node) throws Exception {
                if (this.found) {
                    return super.visitGeneral(node);
                }
                stack.push(node);
                if (node.equals(nde)) {
                    this.found = true;
                }
                return super.visitGeneral(node);
            }

            public void endvisitGeneral(ASTNode node) throws Exception {
                super.endvisitGeneral(node);
                if (this.found) {
                    return;
                }
                stack.pop();
            }
        };
        try {
            module.traverse(visitor);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return stack.toArray(new ASTNode[stack.size()]);
    }

    private static ASTNode getEnclosingElement(Class element, ASTNode[] wayToNode, ASTNode node, boolean considerGiven) {
        int pos = -1;
        int i = wayToNode.length - 1;
        while (i >= 0) {
            if (wayToNode[i] == node) {
                pos = i;
                break;
            }
            --i;
        }
        Assert.isLegal((pos != -1 ? 1 : 0) != 0);
        if (!considerGiven) {
            --pos;
        }
        i = pos;
        while (i >= 0) {
            if (element.isInstance(wayToNode[i])) {
                return wayToNode[i];
            }
            --i;
        }
        return null;
    }

    public static TypeDeclaration getEnclosingType(ASTNode[] wayToNode, ASTNode node, boolean considerGiven) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.dltk.ast.declarations.TypeDeclaration");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (TypeDeclaration)ASTUtils.getEnclosingElement(clazz, wayToNode, node, considerGiven);
    }

    public static CallExpression getEnclosingCallNode(ASTNode[] wayToNode, ASTNode node, boolean considerGiven) {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.dltk.ast.expressions.CallExpression");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (CallExpression)ASTUtils.getEnclosingElement(clazz, wayToNode, node, considerGiven);
    }

    public static MethodDeclaration getEnclosingMethod(ASTNode[] wayToNode, ASTNode node, boolean considerGiven) {
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("org.eclipse.dltk.ast.declarations.MethodDeclaration");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (MethodDeclaration)ASTUtils.getEnclosingElement(clazz, wayToNode, node, considerGiven);
    }

    public static ASTNode findMinimalNode(ModuleDeclaration unit, int start, int end) {
        class Visitor
        extends ASTVisitor {
            ASTNode result;
            int start;
            int end;

            public Visitor(int start, int end) {
                this.result = null;
                this.start = start;
                this.end = end;
            }

            public ASTNode getResult() {
                return this.result;
            }

            private int calcLen(ASTNode s) {
                int realStart = s.sourceStart();
                int realEnd = s.sourceEnd();
                if (s instanceof TypeDeclaration) {
                    TypeDeclaration declaration = (TypeDeclaration)s;
                    realStart = declaration.getNameStart();
                    realEnd = declaration.getNameEnd();
                } else if (s instanceof MethodDeclaration) {
                    MethodDeclaration declaration = (MethodDeclaration)s;
                    realStart = declaration.getNameStart();
                    realEnd = declaration.getNameEnd();
                }
                return realEnd - realStart;
            }

            public boolean visitGeneral(ASTNode s) throws Exception {
                TypeDeclaration declaration;
                int realStart = s.sourceStart();
                int realEnd = s.sourceEnd();
                if (s instanceof Block) {
                    realEnd = -42;
                    realStart = -42;
                } else if (s instanceof TypeDeclaration) {
                    declaration = (TypeDeclaration)s;
                    realStart = declaration.getNameStart();
                    realEnd = declaration.getNameEnd();
                } else if (s instanceof MethodDeclaration) {
                    declaration = (MethodDeclaration)s;
                    realStart = declaration.getNameStart();
                    realEnd = declaration.getNameEnd();
                }
                if (realStart <= this.start && realEnd >= this.end) {
                    if (this.result != null) {
                        int newlen = realEnd - realStart;
                        int oldlen = this.calcLen(this.result);
                        if (newlen <= oldlen) {
                            this.result = s;
                        }
                    } else {
                        this.result = s;
                    }
                    if (DLTKCore.DEBUG_SELECTION) {
                        System.out.println("Found " + s.getClass().getName());
                    }
                }
                return true;
            }
        }
        Visitor visitor = new Visitor(start, end);
        try {
            unit.traverse((ASTVisitor)visitor);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return visitor.getResult();
    }

    public static ASTNode findMaximalNodeEndingAt(ModuleDeclaration unit, int boundaryOffset) {
        class Visitor
        extends ASTVisitor {
            ASTNode result;
            private final /* synthetic */ int val$boundaryOffset;

            Visitor(int n) {
                this.val$boundaryOffset = n;
                this.result = null;
            }

            public ASTNode getResult() {
                return this.result;
            }

            public boolean visitGeneral(ASTNode s) throws Exception {
                if (s.sourceStart() < 0 || s.sourceEnd() < 0) {
                    return true;
                }
                int sourceEnd = s.sourceEnd();
                if (Math.abs(sourceEnd - this.val$boundaryOffset) <= 0) {
                    this.result = s;
                    System.out.println("Found " + s.getClass().getName());
                }
                return true;
            }
        }
        Visitor visitor = new Visitor(boundaryOffset);
        try {
            unit.traverse((ASTVisitor)visitor);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return visitor.getResult();
    }

    public static ModuleDeclaration getAST(ISourceModule module) {
        try {
            char[] cs = module.getSourceAsCharArray();
            ISourceParser sourceParser = DLTKLanguageManager.getSourceParser((String)"org.eclipse.dltk.ruby.core.nature");
            ModuleDeclaration declaration = sourceParser.parse(module.getPath().toString().toCharArray(), cs, null);
            return declaration;
        }
        catch (ModelException e) {
            e.printStackTrace();
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static ModuleDeclaration getAST(char[] cs) {
        try {
            ISourceParser sourceParser = DLTKLanguageManager.getSourceParser((String)"org.eclipse.dltk.ruby.core.nature");
            ModuleDeclaration declaration = sourceParser.parse("RawSource".toCharArray(), cs, null);
            return declaration;
        }
        catch (ModelException e) {
            e.printStackTrace();
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static boolean isNodeScoping(ASTNode node) {
        return node instanceof RubyIfStatement || node instanceof RubyForStatement2 || node instanceof RubyWhileStatement || node instanceof RubyBlock || node instanceof RubyUntilStatement || node instanceof RubyUnlessStatement || node instanceof TypeDeclaration || node instanceof MethodDeclaration;
    }
}

