/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ui.tests.navigator.scriptexplorer;

import java.io.File;
import java.util.ArrayList;
import junit.framework.TestCase;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.dltk.core.ElementChangedEvent;
import org.eclipse.dltk.core.IBuildpathEntry;
import org.eclipse.dltk.core.IElementChangedListener;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IModelElementDelta;
import org.eclipse.dltk.core.IProjectFragment;
import org.eclipse.dltk.core.IScriptFolder;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.internal.ui.wizards.buildpath.BPListElement;
import org.eclipse.dltk.ui.tests.DLTKUITestsPlugin;
import org.eclipse.dltk.ui.tests.ScriptProjectHelper;
import org.eclipse.dltk.ui.tests.navigator.scriptexplorer.MockPluginView;
import org.eclipse.dltk.ui.tests.navigator.scriptexplorer.TestDelta;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;

public class ContentProviderTests1
extends TestCase {
    private IScriptProject fJProject1;
    private IScriptProject fJProject2;
    private IProjectFragment fRoot1;
    private IScriptFolder fPack1;
    private IScriptFolder fPack2;
    private IScriptFolder fPack4;
    private IScriptFolder fPack3;
    private IWorkspace fWorkspace;
    private IWorkbench fWorkbench;
    private MockPluginView fMyPart;
    private ITreeContentProvider fProvider;
    private IProjectFragment fArchiveFragmentRoot;
    private IScriptFolder fPackJunit;
    private IScriptFolder fPackJunitSamples;
    private IScriptFolder fPackJunitSamplesMoney;
    private IScriptFolder fPack5;
    private IScriptFolder fPack6;
    private IFile fFile1;
    private IFile fFile2;
    private IResource fCUIMoney;
    private IResource fCUMoney;
    private IResource fCUMoneyBag;
    private IResource fCUMoneyTest;
    private ISourceModule fCU1;
    private ISourceModule fCU2;
    private IWorkbenchPage page;
    private ISourceModule fCUAllTests;
    private ISourceModule fCUVectorTest;
    private ISourceModule fCUSimpleTest;
    private boolean fEnableAutoBuildAfterTesting;
    private ISourceModule fCU3;

    public ContentProviderTests1(String name) {
        super(name);
    }

    public void testGetChildrenProjectWithSourceFolders() throws Exception {
        Object[] expectedChildren = new Object[]{this.fRoot1, this.fFile1, this.fFile2};
        Object[] children = this.fProvider.getChildren((Object)this.fJProject2);
        ContentProviderTests1.assertTrue((String)"Wrong children found for project", (boolean)this.compareArrays(children, expectedChildren));
    }

    public void testGetChildrenMidLevelFragment() throws Exception {
        Object[] expectedChildren = new Object[]{this.fPack4, this.fPack5};
        Object[] children = this.fProvider.getChildren((Object)this.fPack3);
        ContentProviderTests1.assertTrue((String)"Wrong children found for ScriptFolder", (boolean)this.compareArrays(children, expectedChildren));
    }

    public void testGetChildrenBottomLevelFragment() throws Exception {
        Object[] expectedChildren = new Object[]{this.fCU1};
        Object[] children = this.fProvider.getChildren((Object)this.fPack2);
        ContentProviderTests1.assertTrue((String)"Wrong children found for ScriptFolder", (boolean)this.compareArrays(children, expectedChildren));
    }

    public void testGetChildrenMidLevelFragmentInArchive() throws Exception {
        Object[] expectedChildren = new Object[]{this.fPackJunitSamplesMoney, this.fCUAllTests, this.fCUSimpleTest, this.fCUVectorTest};
        Object[] children = this.fProvider.getChildren((Object)this.fPackJunitSamples);
        ContentProviderTests1.assertTrue((String)"wrong chidren found for mid level ScriptFolder in Archive", (boolean)this.compareArrays(children, expectedChildren));
    }

    public void testGetChildrenBottomLevelFragmentInArchive() throws Exception {
        Object[] expectedChildren = new Object[]{this.fCUIMoney, this.fCUMoney, this.fCUMoneyBag, this.fCUMoneyTest};
        Object[] children = this.fProvider.getChildren((Object)this.fPackJunitSamplesMoney);
        ContentProviderTests1.assertTrue((String)"wrong children found for a bottom ScriptFolder in ProjectFragment Archive", (boolean)this.compareArrays(children, expectedChildren));
    }

    public void testGetChildrenSourceFolder() throws Exception {
        Object[] expectedChildren = new Object[]{this.fPack1, this.fPack2, this.fPack3};
        Object[] children = this.fProvider.getChildren((Object)this.fRoot1);
        ContentProviderTests1.assertTrue((String)"Wrong children found for ProjectFragment", (boolean)this.compareArrays(children, expectedChildren));
    }

    public void testGetChildrenArchive() {
        Object[] expectedChildren = new Object[]{this.fPackJunit};
        Object[] children = this.fProvider.getChildren((Object)this.fArchiveFragmentRoot);
        ContentProviderTests1.assertTrue((String)"Wrong child found for ProjectFragment Archive", (boolean)this.compareArrays(children, expectedChildren));
    }

    public void testGetParentArchive() throws Exception {
        Object parent = this.fProvider.getParent((Object)this.fArchiveFragmentRoot);
        ContentProviderTests1.assertTrue((String)"Wrong parent found for ProjectFragment Archive", (parent == this.fJProject1 ? 1 : 0) != 0);
    }

    public void testGetParentMidLevelFragmentInArchive() throws Exception {
        IScriptFolder expectedParent = this.fPackJunitSamples;
        Object parent = this.fProvider.getParent((Object)this.fPackJunitSamplesMoney);
        ContentProviderTests1.assertTrue((String)"Wrong parent found for a NON top level ScriptFolder in an Archive", (boolean)expectedParent.equals(parent));
    }

    public void testGetParentTopLevelFragmentInArchive() throws Exception {
        IScriptFolder expectedParent = this.fPackJunit;
        Object parent = this.fProvider.getParent((Object)this.fPackJunitSamples);
        ContentProviderTests1.assertTrue((String)"Wrong parent found for a top level ScriptFolder in an Archive", (boolean)expectedParent.equals(parent));
    }

    public void testGetParentTopLevelFragment() throws Exception {
        IProjectFragment expectedParent = this.fRoot1;
        Object parent = this.fProvider.getParent((Object)this.fPack3);
        ContentProviderTests1.assertTrue((String)"Wrong parent found for a top level ScriptFolder", (boolean)expectedParent.equals(parent));
    }

    public void testGetParentMidLevelFragment() throws Exception {
        IScriptFolder expectedParent = this.fPack3;
        Object parent = this.fProvider.getParent((Object)this.fPack4);
        ContentProviderTests1.assertTrue((String)"Wrong parent found for a NON top level ScriptFolder", (boolean)expectedParent.equals(parent));
    }

    public void testDeleteBottomLevelFragment() throws Exception {
        IElementChangedListener listener = (IElementChangedListener)this.fProvider;
        IModelElementDelta delta = TestDelta.createDelta(this.fPack4, 2);
        listener.elementChanged(new ElementChangedEvent(delta, 1));
        while (this.fMyPart.getTreeViewer().getControl().getDisplay().readAndDispatch()) {
        }
        ContentProviderTests1.assertTrue((String)"Remove happened", (boolean)this.fMyPart.hasRemoveHappened());
        ContentProviderTests1.assertTrue((String)"Correct Remove", (boolean)this.fMyPart.getRemovedObject().contains(this.fPack4));
        ContentProviderTests1.assertEquals((String)"No refreshes", (int)0, (int)this.fMyPart.getRefreshedObject().size());
    }

    public void testAddBottomLevelFragment() throws Exception {
        IScriptFolder test = this.fRoot1.createScriptFolder("test", true, null);
        IElementChangedListener listener = (IElementChangedListener)this.fProvider;
        IModelElementDelta delta = TestDelta.createDelta(test, 1);
        listener.elementChanged(new ElementChangedEvent(delta, 1));
        while (this.fMyPart.getTreeViewer().getControl().getDisplay().readAndDispatch()) {
        }
        ContentProviderTests1.assertTrue((String)"Add happened", (boolean)this.fMyPart.hasAddHappened());
        ContentProviderTests1.assertTrue((String)"Correct Add", (boolean)test.equals(this.fMyPart.getAddedObject()));
        ContentProviderTests1.assertEquals((String)"No refreshes", (int)0, (int)this.fMyPart.getRefreshedObject().size());
    }

    public void testChangedTopLevelScriptFolder() throws Exception {
        IElementChangedListener listener = (IElementChangedListener)this.fProvider;
        IModelElementDelta delta = TestDelta.createDelta(this.fPack3, 4);
        listener.elementChanged(new ElementChangedEvent(delta, 1));
        while (this.fMyPart.getTreeViewer().getControl().getDisplay().readAndDispatch()) {
        }
        ContentProviderTests1.assertEquals((String)"No refresh happened", (int)0, (int)this.fMyPart.getRefreshedObject().size());
    }

    public void testChangeBottomLevelScriptFolder() throws Exception {
        this.fMyPart.fRefreshedObjects = new ArrayList();
        IElementChangedListener listener = (IElementChangedListener)this.fProvider;
        IModelElementDelta delta = TestDelta.createDelta(this.fPack6, 4);
        listener.elementChanged(new ElementChangedEvent(delta, 1));
        while (this.fMyPart.getTreeViewer().getControl().getDisplay().readAndDispatch()) {
        }
        ContentProviderTests1.assertEquals((String)"No refresh happened", (int)0, (int)this.fMyPart.getRefreshedObject().size());
    }

    public void testRemoveCUsFromScriptFolder() throws Exception {
        IElementChangedListener listener = (IElementChangedListener)this.fProvider;
        IModelElementDelta delta = TestDelta.createCUDelta(new ISourceModule[]{this.fCU2, this.fCU3}, this.fPack6, 2);
        listener.elementChanged(new ElementChangedEvent(delta, 1));
        while (this.fMyPart.getTreeViewer().getControl().getDisplay().readAndDispatch()) {
        }
        ContentProviderTests1.assertEquals((String)"One refresh", (int)1, (int)this.fMyPart.getRefreshedObject().size());
    }

    public void testRemoveCUFromScriptFolder() throws Exception {
        IElementChangedListener listener = (IElementChangedListener)this.fProvider;
        IModelElementDelta delta = TestDelta.createCUDelta(new ISourceModule[]{this.fCU2}, this.fPack6, 2);
        listener.elementChanged(new ElementChangedEvent(delta, 1));
        while (this.fMyPart.getTreeViewer().getControl().getDisplay().readAndDispatch()) {
        }
        ContentProviderTests1.assertTrue((String)"Remove happened", (boolean)this.fMyPart.hasRemoveHappened());
        ContentProviderTests1.assertTrue((String)"Correct refresh", (boolean)this.fMyPart.getRemovedObject().contains(this.fCU2));
        ContentProviderTests1.assertEquals((String)"No refreshes", (int)0, (int)this.fMyPart.getRefreshedObject().size());
    }

    public void testBug65240() throws Exception {
        IBuildpathEntry[] rawBuildpath = this.fJProject2.getRawBuildpath();
        IBuildpathEntry src1 = rawBuildpath[0];
        BPListElement element = BPListElement.createFromExisting((IBuildpathEntry)src1, (IScriptProject)this.fJProject2);
        element.setAttribute("inclusion", (Object)new IPath[]{new Path("pack3/pack5/")});
        this.fJProject2.setRawBuildpath(new IBuildpathEntry[]{element.getBuildpathEntry()}, null);
        Object[] expectedChildren = new Object[]{this.fPack4, this.fPack5};
        Object[] children = this.fProvider.getChildren((Object)this.fPack3.getResource());
        ContentProviderTests1.assertTrue((String)"Wrong children found for project", (boolean)this.compareArrays(children, expectedChildren));
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.fWorkspace = ResourcesPlugin.getWorkspace();
        ContentProviderTests1.assertNotNull((Object)this.fWorkspace);
        IWorkspaceDescription workspaceDesc = this.fWorkspace.getDescription();
        this.fEnableAutoBuildAfterTesting = workspaceDesc.isAutoBuilding();
        if (this.fEnableAutoBuildAfterTesting) {
            ScriptProjectHelper.setAutoBuilding(false);
        }
        ContentProviderTests1.assertNotNull((Object)this.fWorkspace);
        this.fJProject1 = ScriptProjectHelper.createScriptProject("TestProject1");
        this.fJProject2 = ScriptProjectHelper.createScriptProject("TestProject2");
        ContentProviderTests1.assertNotNull((String)"project1 null", (Object)this.fJProject1);
        ContentProviderTests1.assertNotNull((String)"project2 null", (Object)this.fJProject2);
        this.fJProject1.setRawBuildpath(new IBuildpathEntry[0], null);
        Object[] resource = this.fJProject2.getForeignResources();
        int i = 0;
        while (i < resource.length) {
            Object object = resource[i];
            if (object instanceof IFile) {
                IFile file = (IFile)object;
                if (".buildpath".equals(file.getName())) {
                    this.fFile1 = file;
                } else if (".project".equals(file.getName())) {
                    this.fFile2 = file;
                }
            }
            ++i;
        }
        ContentProviderTests1.assertNotNull((Object)this.fFile1);
        ContentProviderTests1.assertNotNull((Object)this.fFile2);
        File junitSrcArchive = DLTKUITestsPlugin.getDefault().getFileInPlugin(ScriptProjectHelper.JUNIT_SRC_381);
        ContentProviderTests1.assertTrue((String)"junit src not found", (junitSrcArchive != null && junitSrcArchive.exists() ? 1 : 0) != 0);
        this.fArchiveFragmentRoot = ScriptProjectHelper.addSourceContainerWithImport(this.fJProject1, "src", junitSrcArchive, "ISO-8859-1");
        ContentProviderTests1.assertTrue((String)"Unable to create zipfile archive", (boolean)this.fArchiveFragmentRoot.exists());
        this.fPackJunit = this.fArchiveFragmentRoot.getScriptFolder("junit");
        this.fPackJunitSamples = this.fArchiveFragmentRoot.getScriptFolder("junit/samples");
        this.fPackJunitSamplesMoney = this.fArchiveFragmentRoot.getScriptFolder("junit/samples/money");
        ContentProviderTests1.assertNotNull((String)"creating fPackJunit", (Object)this.fPackJunit);
        ContentProviderTests1.assertNotNull((String)"creating fPackJunitSamples", (Object)this.fPackJunitSamples);
        ContentProviderTests1.assertNotNull((String)"creating fPackJunitSamplesMoney", (Object)this.fPackJunitSamplesMoney);
        this.fCUIMoney = this.fPackJunitSamplesMoney.getSourceModule("IMoney.java").getResource();
        this.fCUMoney = this.fPackJunitSamplesMoney.getSourceModule("Money.java").getResource();
        this.fCUMoneyBag = this.fPackJunitSamplesMoney.getSourceModule("MoneyBag.java").getResource();
        this.fCUMoneyTest = this.fPackJunitSamplesMoney.getSourceModule("MoneyTest.java").getResource();
        this.fCUAllTests = this.fPackJunitSamples.getSourceModule("AllTests.txt");
        this.fCUVectorTest = this.fPackJunitSamples.getSourceModule("VectorTest.txt");
        this.fCUSimpleTest = this.fPackJunitSamples.getSourceModule("SimpleTest.txt");
        this.fRoot1 = ScriptProjectHelper.addSourceContainer(this.fJProject2, "src1");
        this.fPack1 = this.fRoot1.createScriptFolder("pack1", true, null);
        this.fPack2 = this.fRoot1.createScriptFolder("pack2", true, null);
        this.fPack3 = this.fRoot1.createScriptFolder("pack3", true, null);
        this.fPack4 = this.fRoot1.createScriptFolder("pack3/pack4", true, null);
        this.fPack5 = this.fRoot1.createScriptFolder("pack3/pack5", true, null);
        this.fPack6 = this.fRoot1.createScriptFolder("pack3/pack5/pack6", true, null);
        this.fCU1 = this.fPack2.createSourceModule("Object.txt", "", true, null);
        this.fCU2 = this.fPack6.createSourceModule("Object.txt", "", true, null);
        this.fCU3 = this.fPack6.createSourceModule("Jen.txt", "", true, null);
        this.setUpMockView();
    }

    public void setUpMockView() throws Exception {
        this.fWorkbench = PlatformUI.getWorkbench();
        ContentProviderTests1.assertNotNull((Object)this.fWorkbench);
        this.page = this.fWorkbench.getActiveWorkbenchWindow().getActivePage();
        ContentProviderTests1.assertNotNull((Object)this.page);
        MockPluginView myPart = new MockPluginView();
        ContentProviderTests1.assertNotNull((Object)((Object)myPart));
        myPart = this.page.showView("org.eclipse.dltk.ui.tests.packageview.MockPluginView");
        if (myPart instanceof MockPluginView) {
            this.fMyPart = myPart;
            this.fMyPart.setFolding(false);
            this.fMyPart.fRefreshedObjects.clear();
            this.fProvider = (ITreeContentProvider)this.fMyPart.getTreeViewer().getContentProvider();
        } else {
            ContentProviderTests1.assertTrue((String)"Unable to get view", (boolean)false);
        }
        ContentProviderTests1.assertNotNull((Object)this.fProvider);
    }

    protected void tearDown() throws Exception {
        this.fArchiveFragmentRoot.close();
        ScriptProjectHelper.delete((IModelElement)this.fJProject1);
        ScriptProjectHelper.delete((IModelElement)this.fJProject2);
        this.page.hideView((IViewPart)this.fMyPart);
        if (this.fEnableAutoBuildAfterTesting) {
            ScriptProjectHelper.setAutoBuilding(true);
        }
        super.tearDown();
    }

    private boolean compareArrays(Object[] children, Object[] expectedChildren) {
        if (children.length != expectedChildren.length) {
            return false;
        }
        int i = 0;
        while (i < children.length) {
            IResource res;
            IModelElement el;
            Object child = children[i];
            if (child instanceof IModelElement ? !this.contains(el = (IModelElement)child, expectedChildren) : child instanceof IResource && !this.contains(res = (IResource)child, expectedChildren)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean contains(IResource res, Object[] expectedChildren) {
        int i = 0;
        while (i < expectedChildren.length) {
            IResource expres;
            Object object = expectedChildren[i];
            if (object instanceof IResource && (expres = (IResource)object).equals((Object)res)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean contains(IModelElement fragment, Object[] expectedChildren) {
        int i = 0;
        while (i < expectedChildren.length) {
            IModelElement expfrag;
            Object object = expectedChildren[i];
            if (object instanceof IModelElement && (expfrag = (IModelElement)object).equals(fragment)) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

