/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ui.tests.core;

import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IProjectFragment;
import org.eclipse.dltk.core.IScriptFolder;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.tests.model.AbstractModelTests;
import org.eclipse.dltk.ui.ScriptElementLabels;
import org.eclipse.dltk.ui.tests.ScriptProjectHelper;
import org.eclipse.dltk.ui.tests.StringAsserts;

public class ScriptElementLabelsTest
extends AbstractModelTests {
    public static final String PROJECT_NAME = "TestSetupProject";
    private IScriptProject fJProject1;

    public ScriptElementLabelsTest(String name) {
        super(PROJECT_NAME, name);
    }

    protected void setUp() throws Exception {
        this.fJProject1 = ScriptProjectHelper.createScriptProject(PROJECT_NAME);
    }

    protected void tearDown() throws Exception {
    }

    public static void assertEqualString(String actual, String expected) {
        StringAsserts.assertEqualString(actual, expected);
    }

    public void testTypeLabelOuter() throws Exception {
        IProjectFragment sourceFolder = ScriptProjectHelper.addSourceContainer(this.fJProject1, "src");
        IScriptFolder pack1 = sourceFolder.getScriptFolder("");
        StringBuffer buf = new StringBuffer();
        buf.append("# parseme!\n");
        buf.append("enterType Outer\n");
        buf.append("exitType");
        String content = buf.toString();
        ISourceModule cu = pack1.createSourceModule("Outer.txt", content, false, null);
        IModelElement elem = cu.getElementAt(content.indexOf("Outer"));
        String lab = ScriptElementLabels.getDefault().getTextLabel((Object)elem, 262144L);
        ScriptElementLabelsTest.assertEqualString(lab, "Outer");
        lab = ScriptElementLabels.getDefault().getTextLabel((Object)elem, 524288L);
        ScriptElementLabelsTest.assertEqualString(lab, "Outer");
        lab = ScriptElementLabels.getDefault().getTextLabel((Object)elem, 0x100000L);
        ScriptElementLabelsTest.assertEqualString(lab, "Outer");
        lab = ScriptElementLabels.getDefault().getTextLabel((Object)elem, 0x80000040000L);
        ScriptElementLabelsTest.assertEqualString(lab, "Outer - TestSetupProject/src/Outer.txt");
        lab = ScriptElementLabels.getDefault().getTextLabel((Object)elem, 0x100000040000L);
        ScriptElementLabelsTest.assertEqualString(lab, "TestSetupProject/src/Outer.txt - Outer");
    }

    public void testTypeLabelInner() throws Exception {
        IProjectFragment sourceFolder = ScriptProjectHelper.addSourceContainer(this.fJProject1, "src");
        IScriptFolder pack1 = sourceFolder.getScriptFolder("");
        StringBuffer buf = new StringBuffer();
        buf.append("# parseme!\n");
        buf.append("enterType Outer\n");
        buf.append("enterMethod foo\n");
        buf.append("exitMethod\n");
        buf.append("enterType Inner\n");
        buf.append("enterMethod inner\n");
        buf.append("exitMethod\n");
        buf.append("exitType\n");
        buf.append("exitType");
        String content = buf.toString();
        ISourceModule cu = pack1.createSourceModule("Outer2.txt", content, false, null);
        IModelElement elem = cu.getElementAt(content.indexOf("Inner"));
        String lab = ScriptElementLabels.getDefault().getTextLabel((Object)elem, 262144L);
        ScriptElementLabelsTest.assertEqualString(lab, "Outer.Inner");
        lab = ScriptElementLabels.getDefault().getTextLabel((Object)elem, 524288L);
        ScriptElementLabelsTest.assertEqualString(lab, "Outer.Inner");
        lab = ScriptElementLabels.getDefault().getTextLabel((Object)elem, 0x100000L);
        ScriptElementLabelsTest.assertEqualString(lab, "Inner - Outer");
        lab = ScriptElementLabels.getDefault().getTextLabel((Object)elem, 0x80000040000L);
        ScriptElementLabelsTest.assertEqualString(lab, "Outer.Inner - TestSetupProject/src/Outer2.txt");
        lab = ScriptElementLabels.getDefault().getTextLabel((Object)elem, 0x100000040000L);
        ScriptElementLabelsTest.assertEqualString(lab, "TestSetupProject/src/Outer2.txt - Outer.Inner");
    }

    public void testTypeLabelLocal() throws Exception {
        IProjectFragment sourceFolder = ScriptProjectHelper.addSourceContainer(this.fJProject1, "src");
        IScriptFolder pack1 = sourceFolder.createScriptFolder("", false, null);
        StringBuffer buf = new StringBuffer();
        buf.append("# parseme!\n");
        buf.append("enterType Outer\n");
        buf.append("enterMethod foo\n");
        buf.append("enterType Local\n");
        buf.append("exitType\n");
        buf.append("exitMethod\n");
        buf.append("exitType");
        String content = buf.toString();
        ISourceModule cu = pack1.createSourceModule("Outer3.txt", content, false, null);
        IModelElement elem = cu.getElementAt(content.indexOf("Local"));
        String lab = ScriptElementLabels.getDefault().getTextLabel((Object)elem, 262144L);
        ScriptElementLabelsTest.assertEqualString(lab, "Outer.foo(...).Local");
        lab = ScriptElementLabels.getDefault().getTextLabel((Object)elem, 524288L);
        ScriptElementLabelsTest.assertEqualString(lab, "Outer.foo(...).Local");
        lab = ScriptElementLabels.getDefault().getTextLabel((Object)elem, 0x100000L);
        ScriptElementLabelsTest.assertEqualString(lab, "Local - Outer.foo(...)");
        lab = ScriptElementLabels.getDefault().getTextLabel((Object)elem, 0x80000040000L);
        ScriptElementLabelsTest.assertEqualString(lab, "Outer.foo(...).Local - TestSetupProject/src/Outer3.txt");
        lab = ScriptElementLabels.getDefault().getTextLabel((Object)elem, 0x100000040000L);
        ScriptElementLabelsTest.assertEqualString(lab, "TestSetupProject/src/Outer3.txt - Outer.foo(...).Local");
    }
}

