/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.debug.tests.breakpoints;

import junit.framework.TestSuite;
import org.eclipse.core.resources.IResource;
import org.eclipse.dltk.core.tests.model.SuiteOfTestCases;
import org.eclipse.dltk.debug.core.model.IScriptLineBreakpoint;
import org.eclipse.dltk.debug.tests.AbstractDebugTests;
import org.eclipse.dltk.internal.debug.core.model.ScriptLineBreakpoint;

public class BreakpointTests
extends AbstractDebugTests {
    private IScriptLineBreakpoint breakpoint;
    static /* synthetic */ Class class$0;

    public static TestSuite suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.dltk.debug.tests.breakpoints.BreakpointTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return new SuiteOfTestCases.Suite((Class)clazz);
    }

    public BreakpointTests() {
        super("org.eclipse.dltk.debug.tests", "My Breakpoint tests");
    }

    public void setUpSuite() throws Exception {
        super.setUpSuite();
        IResource resource = this.scriptProject.getProject().findMember("src/test.rb");
        this.breakpoint = new ScriptLineBreakpoint("test_debug_model", resource, 1, -1, -1, 0, true);
    }

    public void tearDownSuite() throws Exception {
        super.tearDownSuite();
    }

    protected String getProjectName() {
        return "debug";
    }

    public void testSetGet() throws Exception {
        this.breakpoint.setIdentifier("32145");
        BreakpointTests.assertEquals((String)"32145", (String)this.breakpoint.getIdentifier());
        BreakpointTests.assertEquals((int)-1, (int)this.breakpoint.getHitCount());
        this.breakpoint.setHitCount(234);
        BreakpointTests.assertEquals((int)234, (int)this.breakpoint.getHitCount());
        BreakpointTests.assertEquals((boolean)false, (boolean)this.breakpoint.getExpressionState());
        this.breakpoint.setExpressionState(true);
        BreakpointTests.assertEquals((boolean)true, (boolean)this.breakpoint.getExpressionState());
        BreakpointTests.assertNull((Object)this.breakpoint.getExpression());
        this.breakpoint.setExpression("x + y > 3245");
        BreakpointTests.assertEquals((String)"x + y > 3245", (String)this.breakpoint.getExpression());
        BreakpointTests.assertEquals((int)-1, (int)this.breakpoint.getHitCondition());
        this.breakpoint.setHitCondition(1);
        BreakpointTests.assertEquals((int)1, (int)this.breakpoint.getHitCondition());
        BreakpointTests.assertEquals((int)-1, (int)this.breakpoint.getHitValue());
        this.breakpoint.setHitValue(22);
        BreakpointTests.assertEquals((int)22, (int)this.breakpoint.getHitValue());
    }
}

