/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.internal.core.codeassist;

import java.util.List;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.declarations.MethodDeclaration;
import org.eclipse.dltk.ast.declarations.TypeDeclaration;
import org.eclipse.dltk.ast.expressions.StringLiteral;
import org.eclipse.dltk.ast.references.SimpleReference;
import org.eclipse.dltk.internal.codeassist.select.SelectionNodeFound;
import org.eclipse.dltk.tcl.ast.TclStatement;
import org.eclipse.dltk.tcl.ast.expressions.TclBlockExpression;
import org.eclipse.dltk.tcl.ast.expressions.TclExecuteExpression;
import org.eclipse.dltk.tcl.internal.core.codeassist.TclAssistParser;
import org.eclipse.dltk.tcl.internal.core.codeassist.selection.SelectionOnAST;
import org.eclipse.dltk.tcl.internal.core.codeassist.selection.SelectionOnKeywordOrFunction;
import org.eclipse.dltk.tcl.internal.core.codeassist.selection.SelectionOnVariable;
import org.eclipse.dltk.tcl.internal.parser.TclParseUtils;

public class TclSelectionParser
extends TclAssistParser {
    public void handleNotInElement(ASTNode node, int position) {
        TypeDeclaration memberType;
        if (node instanceof TypeDeclaration && (memberType = (TypeDeclaration)node).getNameStart() <= position && memberType.getNameEnd() >= position) {
            SelectionOnAST nde = new SelectionOnAST((ASTNode)memberType);
            throw new SelectionNodeFound((ASTNode)nde);
        }
    }

    public void parseBlockStatements(ASTNode node, ASTNode inNode, int position) {
        if (node instanceof TclStatement) {
            SimpleReference nde;
            TclStatement statement = (TclStatement)node;
            List expressions = statement.getExpressions();
            int len = expressions.size();
            boolean first = false;
            ASTNode completionNode = null;
            String completionToken = null;
            int i = 0;
            while (i < len) {
                ASTNode n = (ASTNode)expressions.get(i);
                if (n.sourceStart() <= position && n.sourceEnd() >= position) {
                    if (i == 0) {
                        first = true;
                    }
                    completionNode = n;
                }
                ++i;
            }
            if (completionNode instanceof SimpleReference && (completionToken = ((SimpleReference)completionNode).getName()).indexOf("[") != -1) {
                this.processInnerExecuteExpression(inNode, position, completionNode, completionToken);
            }
            if (completionToken != null && completionToken.indexOf(40) != -1) {
                completionToken = position < completionNode.sourceStart() + completionToken.indexOf(40) ? completionToken.substring(0, completionToken.indexOf(40)) : completionToken.substring(completionToken.indexOf(40) + 1, completionToken.length() - 1);
            }
            if (completionNode instanceof TclBlockExpression) {
                TclBlockExpression block = (TclBlockExpression)completionNode;
                List s = block.parseBlock();
                if (s != null) {
                    int slen = s.size();
                    int u = 0;
                    while (u < slen) {
                        ASTNode n = (ASTNode)s.get(u);
                        if (n != null && n.sourceStart() <= position && n.sourceEnd() >= position) {
                            this.parseBlockStatements(n, inNode, position);
                        }
                        ++u;
                    }
                }
                this.handleNotInElement(inNode, position);
            }
            if (completionNode instanceof StringLiteral) {
                SimpleReference tok;
                int pos = position - completionNode.sourceStart();
                String content = ((StringLiteral)completionNode).getValue();
                if (content.indexOf("[") != -1) {
                    this.processInnerExecuteExpression(inNode, position, completionNode, content);
                }
                if ((tok = TclParseUtils.findVariableFromString((StringLiteral)completionNode, pos)) != null) {
                    this.assistNodeParent = inNode;
                    SelectionOnVariable nde2 = new SelectionOnVariable(tok.getName(), (ASTNode)tok, node, inNode);
                    if (nde2 != null) {
                        throw new SelectionNodeFound((ASTNode)nde2);
                    }
                }
            }
            if (completionNode instanceof TclExecuteExpression) {
                TclExecuteExpression expr = (TclExecuteExpression)completionNode;
                List exprs = expr.parseExpression();
                int i2 = 0;
                while (i2 < exprs.size()) {
                    ASTNode n = (ASTNode)exprs.get(i2);
                    if (n.sourceStart() <= position && n.sourceEnd() >= position) {
                        this.parseBlockStatements(n, (ASTNode)expr, position);
                    }
                    ++i2;
                }
                this.handleNotInElement((ASTNode)expr, position);
            }
            String var = TclParseUtils.returnVariableCheck(statement, position);
            if (completionToken != null && completionToken.startsWith("$") || var != null) {
                this.assistNodeParent = inNode;
                if (var != null) {
                    nde = new SelectionOnAST((ASTNode)statement);
                    throw new SelectionNodeFound((ASTNode)nde);
                }
                nde = new SelectionOnVariable(completionToken, completionNode, node, inNode);
                throw new SelectionNodeFound((ASTNode)nde);
            }
            if (completionToken != null && completionNode != null && first) {
                nde = new SelectionOnKeywordOrFunction(completionToken, completionNode, node);
                this.assistNodeParent = inNode;
                throw new SelectionNodeFound((ASTNode)nde);
            }
        } else if (node instanceof MethodDeclaration) {
            MethodDeclaration method = (MethodDeclaration)node;
            List statements = method.getStatements();
            boolean inStatement = false;
            if (method.getNameStart() <= position && method.getNameEnd() >= position) {
                SelectionOnAST nde = new SelectionOnAST((ASTNode)method);
                this.assistNodeParent = inNode;
                throw new SelectionNodeFound((ASTNode)nde);
            }
            if (statements != null) {
                int length = statements.size();
                int i = 0;
                while (i < length) {
                    ASTNode nde = (ASTNode)statements.get(i);
                    if (nde.sourceStart() <= position && nde.sourceEnd() >= position) {
                        inStatement = true;
                        this.parseBlockStatements(nde, (ASTNode)method, position);
                    }
                    ++i;
                }
            }
            if (!inStatement) {
                this.handleNotInElement((ASTNode)method, position);
            }
        }
    }

    private void processInnerExecuteExpression(ASTNode inNode, int position, ASTNode completionNode, String completionToken) {
        String toks = null;
        int pos = position - completionNode.sourceStart();
        int end = 0;
        end = pos;
        while (end < completionToken.length()) {
            char c = completionToken.charAt(end);
            if (c == '[') break;
            if (c == ']') {
                ++end;
                break;
            }
            ++end;
        }
        int begin = 0;
        begin = pos - 1;
        while (begin > 0) {
            char c = completionToken.charAt(begin);
            if (c == ']' || c == '[') break;
            --begin;
        }
        if (begin <= 0 || begin >= end || end > completionToken.length()) {
            return;
        }
        toks = completionToken.substring(begin, end);
        if (toks != null) {
            TclExecuteExpression ex = new TclExecuteExpression(completionNode.sourceStart() + begin, completionNode.sourceStart() + end, toks);
            List exprs = ex.parseExpression();
            int i = 0;
            while (i < exprs.size()) {
                this.parseBlockStatements((ASTNode)exprs.get(i), inNode, position);
                ++i;
            }
            return;
        }
    }
}

