/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.core;

import java.io.File;
import java.io.FilenameFilter;
import java.text.MessageFormat;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IModelStatus;
import org.eclipse.dltk.internal.core.util.Messages;

public class TclLanguageToolkit
implements IDLTKLanguageToolkit {
    protected static String[] patterns = new String[]{"#!/usr/bin/tclsh", "#!/usr/bin/expect", "# ;;; Local Variable: \\*\\*\\*\\s*\r*\n# ;;; mode: tcl \\*\\*\\*\\s*\r*\n# ;;; End: \\*\\*\\*", "#!/bin/sh\\s*\r*\n#.*\\\\s*\r*\nexec .*tclsh .*", "#!/bin/sh\\s*\r*\n#.*\\\\s*\r*\nexec .*expect .*", "#!/bin/sh\\s*\r*\n#.*\\\\s*\r*\nexec .*wish.*"};
    protected static IDLTKLanguageToolkit sInstance = new TclLanguageToolkit();

    public String[] getLanguageFileExtensions() {
        return new String[]{"tcl", "exp", "test"};
    }

    /*
     * Exception decompiling
     */
    private IStatus isTclHeadered(File file) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 5[TRYBLOCK] [7 : 191->194)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private boolean isSureNotTCLFile(IPath path) {
        String name = path.toOSString();
        String[] exts = new String[]{"so", "a", "la", "c", "h"};
        int i = 0;
        while (i < exts.length) {
            if (name.endsWith("." + exts[i])) {
                return true;
            }
            ++i;
        }
        return Platform.getOS().equals("linux") && (name = path.lastSegment()).startsWith("lib") && Character.isDigit(name.charAt(name.length() - 1));
    }

    private boolean isTCLLikeFileName(String name) {
        String[] exts = this.getLanguageFileExtensions();
        int i = 0;
        while (i < exts.length) {
            if (name.endsWith("." + exts[i])) {
                return true;
            }
            ++i;
        }
        return name.toLowerCase().equals("tclindex");
    }

    public boolean languageSupportZIPBuildpath() {
        return false;
    }

    public IStatus validateSourceModule(IModelElement parent, String name) {
        return this.validateSourceModuleName(name);
    }

    public IStatus validateSourceModuleName(String name) {
        if (name == null) {
            return new Status(4, "org.eclipse.dltk.tcl.core", -1, Messages.convention_unit_nullName, null);
        }
        if (!this.isTCLLikeFileName(name)) {
            return new Status(4, "org.eclipse.dltk.tcl.core", -1, MessageFormat.format(Messages.convention_unit_notScriptName, this.getLanguageFileExtensions().toString(), "Tcl"), null);
        }
        return IModelStatus.VERIFIED_OK;
    }

    public IStatus validateSourceModule(IPath path) {
        IStatus status = this.validateSourceModuleName(path.lastSegment());
        if (status == IModelStatus.VERIFIED_OK) {
            return status;
        }
        if (this.isSureNotTCLFile(path)) {
            return new Status(4, "org.eclipse.dltk.tcl.core", -1, MessageFormat.format(Messages.convention_unit_notScriptName, this.getLanguageFileExtensions().toString(), "Tcl"), null);
        }
        if (this.isTclHeadered(path.toFile()) == IModelStatus.VERIFIED_OK) {
            return IModelStatus.VERIFIED_OK;
        }
        return status;
    }

    public IStatus validateSourceModule(IResource resource) {
        IStatus status = this.validateSourceModuleName(resource.getName());
        if (status == IModelStatus.VERIFIED_OK) {
            return status;
        }
        if (resource != null) {
            IPath path = resource.getRawLocation();
            if (path == null) {
                return status;
            }
            if (this.isTclHeadered(path.toFile()) == IModelStatus.VERIFIED_OK) {
                return IModelStatus.VERIFIED_OK;
            }
        }
        return status;
    }

    public boolean validateSourcePackage(IPath path) {
        String[] members;
        File file = new File(path.toOSString());
        return file != null && file.isDirectory() && (members = file.list(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.toLowerCase().equals("pkgindex.tcl") || name.toLowerCase().equals("tclindex");
            }
        })) != null && members.length > 0;
    }

    public String getNatureId() {
        return "org.eclipse.dltk.tcl.core.nature";
    }

    public static IDLTKLanguageToolkit getDefault() {
        return sInstance;
    }

    public String getDelimeterReplacerString() {
        return "::";
    }

    public String getLanguageName() {
        return "Tcl";
    }
}

