/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.console.ui.internal;

import org.eclipse.dltk.console.ui.IConsoleStyleProvider;
import org.eclipse.dltk.console.ui.ScriptConsole;
import org.eclipse.dltk.console.ui.internal.IScriptConsoleContentHandler;
import org.eclipse.dltk.console.ui.internal.ScriptConsoleMessages;
import org.eclipse.dltk.console.ui.internal.ScriptConsoleViewer;
import org.eclipse.dltk.console.ui.internal.actions.CloseScriptConsoleAction;
import org.eclipse.dltk.console.ui.internal.actions.SaveConsoleSessionAction;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.console.IConsoleView;
import org.eclipse.ui.console.TextConsole;
import org.eclipse.ui.console.TextConsolePage;
import org.eclipse.ui.console.TextConsoleViewer;
import org.eclipse.ui.console.actions.TextViewerAction;

public class ScriptConsolePage
extends TextConsolePage
implements IScriptConsoleContentHandler {
    private SourceViewerConfiguration cfg;
    private ScriptConsoleViewer viewer;
    private TextViewerAction proposalsAction;
    private IConsoleStyleProvider styleProvider;

    protected void createActions() {
        super.createActions();
        this.proposalsAction = new ContentAssistProposalsAction((ITextViewer)this.getViewer());
        this.proposalsAction = new ContentAssistProposalsAction((ITextViewer)this.getViewer());
        SaveConsoleSessionAction saveSessionAction = new SaveConsoleSessionAction((ScriptConsole)this.getConsole(), ScriptConsoleMessages.SaveSessionAction, ScriptConsoleMessages.SaveSessionTooltip);
        CloseScriptConsoleAction closeConsoleAction = new CloseScriptConsoleAction((ScriptConsole)this.getConsole(), ScriptConsoleMessages.TerminateConsoleAction, ScriptConsoleMessages.TerminateConsoleTooltip);
        IActionBars bars = this.getSite().getActionBars();
        IToolBarManager toolbarManager = bars.getToolBarManager();
        toolbarManager.prependToGroup("launchGroup", (IContributionItem)new GroupMarker("scriptGroup"));
        toolbarManager.appendToGroup("scriptGroup", (IContributionItem)new Separator());
        toolbarManager.appendToGroup("scriptGroup", (IAction)closeConsoleAction);
        toolbarManager.appendToGroup("scriptGroup", (IAction)saveSessionAction);
        bars.updateActionBars();
    }

    protected TextConsoleViewer createViewer(Composite parent) {
        this.viewer = new ScriptConsoleViewer(parent, (ScriptConsole)this.getConsole(), this, this.styleProvider);
        this.viewer.configure(this.cfg);
        return this.viewer;
    }

    public ScriptConsolePage(ScriptConsole console, IConsoleView view, SourceViewerConfiguration cfg) {
        super((TextConsole)console, view);
        this.cfg = cfg;
    }

    public void clearConsolePage() {
        this.viewer.clear();
    }

    public void contentAssistRequired() {
        this.proposalsAction.run();
    }

    public void insertText(String text) {
        this.viewer.insertText(text);
    }

    public void setStyleProviser(IConsoleStyleProvider provider) {
        this.styleProvider = provider;
    }

    protected class ContentAssistContextInfoAction
    extends TextViewerAction {
        public ContentAssistContextInfoAction(ITextViewer viewer) {
            super(viewer, 14);
        }
    }

    protected class ContentAssistProposalsAction
    extends TextViewerAction {
        public ContentAssistProposalsAction(ITextViewer viewer) {
            super(viewer, 13);
        }
    }
}

