/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.debug.core.model;

import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IDebugElement;

public final class DebugEventHelper {
    private DebugEventHelper() {
    }

    private static void fireEvent(DebugEvent event) {
        DebugPlugin.getDefault().fireDebugEventSet(new DebugEvent[]{event});
    }

    public static void fireCreateEvent(IDebugElement element) {
        DebugEventHelper.fireEvent(new DebugEvent((Object)element, 4));
    }

    public static void fireResumeEvent(IDebugElement element, int detail) {
        DebugEventHelper.fireEvent(new DebugEvent((Object)element, 1, detail));
    }

    public static void fireSuspendEvent(IDebugElement element, int detail) {
        DebugEventHelper.fireEvent(new DebugEvent((Object)element, 2, detail));
    }

    public static void fireTerminateEvent(IDebugElement element) {
        DebugEventHelper.fireEvent(new DebugEvent((Object)element, 8));
    }

    public static void fireChangeEvent(IDebugElement element) {
        DebugEventHelper.fireEvent(new DebugEvent((Object)element, 16));
    }
}

