/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.ai.tts.sapi.engine;

import org.eclipse.actf.ai.tts.sapi.engine.ISpVoice;
import org.eclipse.actf.ai.tts.sapi.engine.SpEvent;
import org.eclipse.actf.ai.voice.IVoiceEventListener;
import org.eclipse.actf.util.win32.COMUtil;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.ole.win32.GUID;
import org.eclipse.swt.internal.ole.win32.IDispatch;

public class ISpNotifySource
extends IDispatch {
    public static final GUID IID = COMUtil.IIDFromString((String)"{5EFF4AEF-8487-11D2-961C-00C04F8EE628}");
    public static final int SPEI_START_INPUT_STREAM = 1;
    public static final int SPEI_END_INPUT_STREAM = 2;
    public static final int SPEI_VOICE_CHANGE = 3;
    public static final int SPEI_TTS_BOOKMARK = 4;
    public static final int SPEI_WORD_BOUNDARY = 5;
    public static final int SPEI_PHONEME = 6;
    public static final int SPEI_SENTENCE_BOUNDARY = 7;
    public static final int SPEI_VISEME = 8;
    public static final int SPEI_TTS_AUDIO_LEVEL = 9;
    private int address;
    private Callback callback = null;
    private IVoiceEventListener eventListener = null;

    public ISpNotifySource(int n) {
        super(n);
        this.address = n;
        this.callback = new Callback((Object)this, "SAPINotifyCallback", 2);
        this.SetNotifyCallbackFunction(this.callback.getAddress(), 0, 0);
        this.SetInterest(16, 16);
    }

    public static ISpNotifySource getNotifySource(ISpVoice iSpVoice) {
        int[] nArray = new int[1];
        if (iSpVoice.QueryInterface(IID, nArray) == 0) {
            return new ISpNotifySource(nArray[0]);
        }
        return null;
    }

    public void setEventListener(IVoiceEventListener iVoiceEventListener) {
        this.eventListener = iVoiceEventListener;
    }

    int SAPINotifyCallback(int n, int n2) {
        SpEvent spEvent = new SpEvent();
        try {
            while (this.GetEvent(spEvent.getAddress()) == 0) {
                String string;
                if (this.eventListener != null) {
                    if (4 != spEvent.getEventId()) continue;
                    this.eventListener.indexReceived(spEvent.getWParam());
                    continue;
                }
                switch (spEvent.getEventId()) {
                    case 1: {
                        string = "SPEI_START_INPUT_STREAM";
                        break;
                    }
                    case 2: {
                        string = "SPEI_END_INPUT_STREAM";
                        break;
                    }
                    case 3: {
                        string = "SPEI_VOICE_CHANGE";
                        break;
                    }
                    case 4: {
                        string = "SPEI_TTS_BOOKMARK";
                        break;
                    }
                    case 5: {
                        string = "SPEI_WORD_BOUNDARY";
                        break;
                    }
                    case 6: {
                        string = "SPEI_PHONEME";
                        break;
                    }
                    case 7: {
                        string = "SPEI_SENTENCE_BOUNDARY";
                        break;
                    }
                    case 8: {
                        string = "SPEI_VISEME";
                        break;
                    }
                    case 9: {
                        string = "SPEI_TTS_AUDIO_LEVEL";
                        break;
                    }
                    default: {
                        string = "Unknown+(" + spEvent.getEventId() + ")";
                    }
                }
                System.out.println(String.valueOf(string) + ": " + spEvent.getLParamType() + "/" + spEvent.getStreamNum() + "/" + spEvent.getAudioStreamOffset() + "/" + spEvent.getLParam() + "/" + spEvent.getWParam());
            }
        }
        finally {
            spEvent.dispose();
        }
        return 0;
    }

    public int SetNotifyCallbackFunction(int n, int n2, int n3) {
        return COMUtil.VtblCall((int)5, (int)this.address, (int)n, (int)n2, (int)n3);
    }

    public int SetInterest(int n, int n2) {
        return COMUtil.VtblCall((int)10, (int)this.address, (int)(0x40000000 | n), (int)2, (int)(0x40000000 | n2), (int)2);
    }

    public int GetEvent(int n) {
        return COMUtil.VtblCall((int)11, (int)this.address, (int)1, (int)n, (int)0);
    }
}

