/**
 * <copyright>
 * 
 * Copyright (c) 2014 itemis and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     itemis - Initial API and implementation
 * 
 * </copyright>
 */
package org.eclipse.sphinx.emf.serialization.generators.persistencemapping;

import com.google.common.base.Objects;
import java.util.function.Consumer;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.ExtendedMetaData;
import org.eclipse.sphinx.emf.serialization.XMLPersistenceMappingExtendedMetaData;
import org.eclipse.sphinx.emf.serialization.generators.util.Ecore2XSDUtil;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;
import org.eclipse.xtext.xbase.lib.Procedures.Procedure1;

@SuppressWarnings("all")
public class CreateDefaultXSDExtendedMetaData {
  protected EPackage rootModel;
  
  protected String globalEClassName;
  
  public CreateDefaultXSDExtendedMetaData(final EPackage rootModel, final String globalEClassName) {
    this.rootModel = rootModel;
    this.globalEClassName = globalEClassName;
  }
  
  public EPackage execute(final IProgressMonitor monitor) {
    monitor.subTask("Create Default XSD Extended MetaData");
    this.configure(this.rootModel);
    final Function1<EObject, Boolean> _function = new Function1<EObject, Boolean>() {
      @Override
      public Boolean apply(final EObject eObject) {
        return Boolean.valueOf(((eObject instanceof EStructuralFeature) && (ExtendedMetaData.ELEMENT_FEATURE == ExtendedMetaData.INSTANCE.getFeatureKind(((EStructuralFeature) eObject)))));
      }
    };
    final Procedure1<EObject> _function_1 = new Procedure1<EObject>() {
      @Override
      public void apply(final EObject feature) {
        CreateDefaultXSDExtendedMetaData.this.configureNamespace(((EStructuralFeature) feature));
      }
    };
    IteratorExtensions.<EObject>forEach(IteratorExtensions.<EObject>filter(this.rootModel.eAllContents(), _function), _function_1);
    return this.rootModel;
  }
  
  protected EObject doSwitch(final EObject object) {
    EObject _switchResult = null;
    boolean _matched = false;
    if ((object instanceof EPackage)) {
      _matched=true;
      _switchResult = this.configure(((EPackage) object));
    }
    if (!_matched) {
      if ((object instanceof EClass)) {
        _matched=true;
        _switchResult = this.configure(((EClass) object));
      }
    }
    if (!_matched) {
      if ((object instanceof EAttribute)) {
        _matched=true;
        _switchResult = this.configure(((EAttribute) object));
      }
    }
    if (!_matched) {
      if ((object instanceof EEnum)) {
        _matched=true;
        _switchResult = this.configure(((EEnum) object));
      }
    }
    if (!_matched) {
      if ((object instanceof EEnumLiteral)) {
        _matched=true;
        _switchResult = this.configure(((EEnumLiteral) object));
      }
    }
    if (!_matched) {
      if ((object instanceof EDataType)) {
        _matched=true;
        _switchResult = this.configure(((EDataType) object));
      }
    }
    if (!_matched) {
      if ((object instanceof EReference)) {
        _matched=true;
        _switchResult = this.configure(((EReference) object));
      }
    }
    if (!_matched) {
      if ((object instanceof EStructuralFeature)) {
        _matched=true;
        _switchResult = this.configure(((EStructuralFeature) object));
      }
    }
    return _switchResult;
  }
  
  /**
   * Configures tagged values of a package.
   * 
   * @param ePackage
   * @return ePackage
   */
  protected EObject configure(final EPackage ePackage) {
    XMLPersistenceMappingExtendedMetaData.INSTANCE.setQualified(ePackage, true);
    final Consumer<EClassifier> _function = new Consumer<EClassifier>() {
      @Override
      public void accept(final EClassifier it) {
        CreateDefaultXSDExtendedMetaData.this.doSwitch(it);
      }
    };
    ePackage.getEClassifiers().forEach(_function);
    final Consumer<EPackage> _function_1 = new Consumer<EPackage>() {
      @Override
      public void accept(final EPackage it) {
        CreateDefaultXSDExtendedMetaData.this.doSwitch(it);
      }
    };
    ePackage.getESubpackages().forEach(_function_1);
    return ePackage;
  }
  
  /**
   * Configures tagged values of a EClass
   * To be override
   * 
   * @param eClass
   * @return eClass
   */
  protected EObject configure(final EClass eClass) {
    this.configureClassifierNames(eClass);
    this.configureNamespace(eClass);
    boolean _equals = eClass.getName().equals(this.globalEClassName);
    if (_equals) {
      XMLPersistenceMappingExtendedMetaData.INSTANCE.setXMLGlobalElement(eClass, true);
    }
    int _contentKind = XMLPersistenceMappingExtendedMetaData.INSTANCE.getContentKind(eClass);
    boolean _notEquals = (_contentKind != ExtendedMetaData.UNSPECIFIED_CONTENT);
    if (_notEquals) {
    } else {
      int kind = ExtendedMetaData.ELEMENT_ONLY_CONTENT;
      XMLPersistenceMappingExtendedMetaData.INSTANCE.setContentKind(eClass, kind);
    }
    final Consumer<EStructuralFeature> _function = new Consumer<EStructuralFeature>() {
      @Override
      public void accept(final EStructuralFeature it) {
        CreateDefaultXSDExtendedMetaData.this.doSwitch(it);
      }
    };
    eClass.getEStructuralFeatures().forEach(_function);
    return eClass;
  }
  
  /**
   * Creates ExtendedMetaData for an EAttribute
   * 
   * @param eAttribute
   * @return eAttribute
   */
  protected EObject configure(final EAttribute eAttribute) {
    this.configure(((EStructuralFeature) eAttribute));
    XMLPersistenceMappingExtendedMetaData.INSTANCE.setXMLName(eAttribute, XMLPersistenceMappingExtendedMetaData.INSTANCE.getXMLName(eAttribute));
    final boolean isAttribute = XMLPersistenceMappingExtendedMetaData.INSTANCE.isXMLAttribute(eAttribute);
    int kind = ExtendedMetaData.ELEMENT_FEATURE;
    if (isAttribute) {
      kind = ExtendedMetaData.ATTRIBUTE_FEATURE;
    }
    ExtendedMetaData.INSTANCE.setFeatureKind(eAttribute, kind);
    if ((!isAttribute)) {
    }
    return eAttribute;
  }
  
  /**
   * Configures tagged values of a EStructuralFeature
   * 
   * @param feature
   * @return feature
   */
  protected EObject configure(final EStructuralFeature feature) {
    this.configureFeatureNames(feature);
    this.configureNamespace(feature);
    this.configureXMLAttribute(feature);
    int xmlPersistenceStrategy = 0;
    final boolean isContainment = ((feature instanceof EAttribute) || ((EReference) feature).isContainment());
    if ((feature instanceof EAttribute)) {
      boolean _isMany = ((EAttribute)feature).isMany();
      if (_isMany) {
        if ((isContainment && (((EAttribute)feature).getEType() instanceof EClass))) {
          xmlPersistenceStrategy = XMLPersistenceMappingExtendedMetaData.XML_PERSISTENCE_MAPPING_STRATEGY__1001__FEATURE_WRAPPER_ELEMENT__CLASSIFIER_ELEMENT;
        } else {
          xmlPersistenceStrategy = XMLPersistenceMappingExtendedMetaData.XML_PERSISTENCE_MAPPING_STRATEGY__1000__FEATURE_WRAPPER_ELEMENT;
        }
      } else {
        if ((isContainment && (((EAttribute)feature).getEType() instanceof EClass))) {
          EClassifier _eType = ((EAttribute)feature).getEType();
          boolean _hasConcreteSubclasses = Ecore2XSDUtil.hasConcreteSubclasses(((EClass) _eType), this.rootModel);
          if (_hasConcreteSubclasses) {
            xmlPersistenceStrategy = XMLPersistenceMappingExtendedMetaData.XML_PERSISTENCE_MAPPING_STRATEGY__0101__FEATURE_ELEMENT__CLASSIFIER_ELEMENT;
          } else {
            xmlPersistenceStrategy = XMLPersistenceMappingExtendedMetaData.XML_PERSISTENCE_MAPPING_STRATEGY__0100__FEATURE_ELEMENT;
          }
        } else {
          xmlPersistenceStrategy = XMLPersistenceMappingExtendedMetaData.XML_PERSISTENCE_MAPPING_STRATEGY__0100__FEATURE_ELEMENT;
        }
      }
    } else {
      boolean _isContainment = ((EReference) feature).isContainment();
      if (_isContainment) {
        boolean _isMany_1 = feature.isMany();
        if (_isMany_1) {
          xmlPersistenceStrategy = XMLPersistenceMappingExtendedMetaData.XML_PERSISTENCE_MAPPING_STRATEGY__1000__FEATURE_WRAPPER_ELEMENT;
          EClassifier _eType_1 = feature.getEType();
          if ((_eType_1 instanceof EClass)) {
            xmlPersistenceStrategy = XMLPersistenceMappingExtendedMetaData.XML_PERSISTENCE_MAPPING_STRATEGY__1001__FEATURE_WRAPPER_ELEMENT__CLASSIFIER_ELEMENT;
          }
        } else {
          EClassifier _eType_2 = feature.getEType();
          if ((_eType_2 instanceof EClass)) {
            EClassifier _eType_3 = feature.getEType();
            boolean _hasConcreteSubclasses_1 = Ecore2XSDUtil.hasConcreteSubclasses(((EClass) _eType_3), this.rootModel);
            if (_hasConcreteSubclasses_1) {
              xmlPersistenceStrategy = XMLPersistenceMappingExtendedMetaData.XML_PERSISTENCE_MAPPING_STRATEGY__0101__FEATURE_ELEMENT__CLASSIFIER_ELEMENT;
            } else {
              xmlPersistenceStrategy = XMLPersistenceMappingExtendedMetaData.XML_PERSISTENCE_MAPPING_STRATEGY__0100__FEATURE_ELEMENT;
            }
          } else {
            xmlPersistenceStrategy = XMLPersistenceMappingExtendedMetaData.XML_PERSISTENCE_MAPPING_STRATEGY__0100__FEATURE_ELEMENT;
          }
        }
      } else {
        boolean _isMany_2 = feature.isMany();
        if (_isMany_2) {
          xmlPersistenceStrategy = XMLPersistenceMappingExtendedMetaData.XML_PERSISTENCE_MAPPING_STRATEGY__1100__FEATURE_WRAPPER_ELEMENT__FEATURE_ELEMENT;
        } else {
          xmlPersistenceStrategy = XMLPersistenceMappingExtendedMetaData.XML_PERSISTENCE_MAPPING_STRATEGY__0100__FEATURE_ELEMENT;
        }
      }
    }
    XMLPersistenceMappingExtendedMetaData.INSTANCE.setXMLPersistenceMappingStrategy(feature, xmlPersistenceStrategy);
    return feature;
  }
  
  /**
   * to be override
   */
  protected void configureFeatureNames(final EStructuralFeature feature) {
    XMLPersistenceMappingExtendedMetaData.INSTANCE.setXMLName(feature, Ecore2XSDUtil.getSingularName(feature));
    XMLPersistenceMappingExtendedMetaData.INSTANCE.setXMLWrapperName(feature, Ecore2XSDUtil.getPluralName(feature));
  }
  
  /**
   * to be override
   */
  protected void configureClassifierNames(final EClassifier classifier) {
    XMLPersistenceMappingExtendedMetaData.INSTANCE.setXMLName(classifier, Ecore2XSDUtil.getSingularName(classifier));
    XMLPersistenceMappingExtendedMetaData.INSTANCE.setXMLWrapperName(classifier, Ecore2XSDUtil.getPluralName(classifier));
  }
  
  /**
   * Configures tagged values of a primitive Datatype
   * To be override
   * 
   * @param dataType
   * @return
   */
  protected EObject configure(final EDataType dataType) {
    this.configureClassifierNames(dataType);
    return dataType;
  }
  
  /**
   * Configures tagged values of a EEnumLiteral
   * 
   * @param literal
   * @return literal
   */
  protected EObject configure(final EEnumLiteral literal) {
    return literal;
  }
  
  /**
   * Configures default tagged values of a EEnum
   * 
   * @param eEnum
   * @return eEnum
   */
  protected EObject configure(final EEnum eEnum) {
    this.configureClassifierNames(eEnum);
    final Consumer<EEnumLiteral> _function = new Consumer<EEnumLiteral>() {
      @Override
      public void accept(final EEnumLiteral it) {
        CreateDefaultXSDExtendedMetaData.this.doSwitch(it);
      }
    };
    eEnum.getELiterals().forEach(_function);
    return eEnum;
  }
  
  /**
   * Creates ExtendedMetaData for an EReference
   * 
   * @param eReference
   * @return eReference
   */
  protected EObject configure(final EReference eReference) {
    this.configure(((EStructuralFeature) eReference));
    ExtendedMetaData.INSTANCE.setFeatureKind(eReference, ExtendedMetaData.ELEMENT_FEATURE);
    return eReference;
  }
  
  protected void configureNamespace(final EStructuralFeature feature) {
    final String namespace = XMLPersistenceMappingExtendedMetaData.INSTANCE.getNamespace(feature);
    boolean _equals = Objects.equal(null, namespace);
    if (_equals) {
      EcoreUtil.setAnnotation(feature, ExtendedMetaData.ANNOTATION_URI, "namespace", feature.getEContainingClass().getEPackage().getNsURI());
    }
  }
  
  /**
   * Sets the following tagged values of an ENamedElement
   * 
   * <ul>
   * <li>xml.name</li>
   * <li>xml.namePlural</li>
   * <li>xml.nsPrefix</li>
   * <li>xml.nsUri</li>
   * 
   * @param element
   */
  protected void configureNamespace(final ENamedElement element) {
  }
  
  protected void configureXMLAttribute(final EStructuralFeature eStructuralFeature) {
    boolean isXMLAttribute = false;
    if ((Integer.valueOf(1).equals(Integer.valueOf(eStructuralFeature.getUpperBound())) && Integer.valueOf(0).equals(Integer.valueOf(eStructuralFeature.getLowerBound())))) {
      final EClassifier type = eStructuralFeature.getEType();
      if (((type instanceof EEnum) || (type instanceof EDataType))) {
        isXMLAttribute = true;
      }
    }
    XMLPersistenceMappingExtendedMetaData.INSTANCE.setXMLAttribute(eStructuralFeature, isXMLAttribute);
  }
}
