/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.emf.editors.forms.sections;

import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.ui.viewer.IViewerProvider;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.ui.action.EditingDomainActionBarContributor;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.ui.provider.TransactionalAdapterFactoryContentProvider;
import org.eclipse.emf.transaction.ui.provider.TransactionalAdapterFactoryLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.sphinx.emf.editors.forms.BasicTransactionalEditorActionBarContributor;
import org.eclipse.sphinx.emf.editors.forms.pages.AbstractFormPage;
import org.eclipse.sphinx.emf.editors.forms.sections.AbstractFormSection;
import org.eclipse.sphinx.platform.util.ReflectUtil;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.SectionPart;

public abstract class AbstractViewerFormSection
extends AbstractFormSection
implements IViewerProvider {
    protected StructuredViewer viewer;
    private IContentProvider contentProvider;
    private IBaseLabelProvider labelProvider;

    public AbstractViewerFormSection(AbstractFormPage formPage, Object sectionInput) {
        super(formPage, sectionInput);
    }

    public AbstractViewerFormSection(AbstractFormPage formPage, Object sectionInput, int style) {
        super(formPage, sectionInput, style);
    }

    @Override
    public void setSectionInput(Object sectionInput) {
        super.setSectionInput(sectionInput);
        if (this.viewer != null) {
            this.viewer.setInput(this.getViewerInput());
        }
    }

    public StructuredViewer getViewer() {
        return this.viewer;
    }

    public Object getViewerInput() {
        return this.sectionInput;
    }

    @Override
    protected Composite doCreateSectionClient(final IManagedForm managedForm, final SectionPart sectionPart) {
        Composite composite = super.doCreateSectionClient(managedForm, sectionPart);
        if (this.viewer != null) {
            this.formPage.getTransactionalFormEditor().setSelectionProvider((ISelectionProvider)this.viewer);
            this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    managedForm.fireSelectionChanged((IFormPart)sectionPart, event.getSelection());
                    AbstractViewerFormSection.this.formPage.getTransactionalFormEditor().setSelectionProvider((ISelectionProvider)AbstractViewerFormSection.this.viewer);
                }
            });
            this.createViewerContextMenu();
        }
        return composite;
    }

    @Override
    public boolean isEmpty() {
        if (this.viewer != null) {
            try {
                Object[] filteredChildren = (Object[])ReflectUtil.invokeInvisibleMethod((Object)this.viewer, (String)"getFilteredChildren", (Object[])new Object[]{this.getViewerInput()});
                return filteredChildren.length == 0;
            }
            catch (Exception exception) {}
        }
        return false;
    }

    @Override
    protected void focusGained(FocusEvent e) {
        super.focusGained(e);
        EditingDomainActionBarContributor actionBarContributor = this.formPage.getTransactionalFormEditor().getActionBarContributor();
        if (actionBarContributor instanceof BasicTransactionalEditorActionBarContributor) {
            ((BasicTransactionalEditorActionBarContributor)actionBarContributor).setGlobalActionHandlers();
        }
    }

    public IContentProvider getContentProvider() {
        if (this.contentProvider == null) {
            this.contentProvider = this.createContentProvider();
        }
        return this.contentProvider;
    }

    protected IContentProvider createContentProvider() {
        EditingDomain editingDomain;
        AdapterFactory adapterFactory = this.getCustomAdapterFactory();
        if (adapterFactory != null && (editingDomain = this.formPage.getTransactionalFormEditor().getEditingDomain()) instanceof TransactionalEditingDomain) {
            return new TransactionalAdapterFactoryContentProvider((TransactionalEditingDomain)editingDomain, adapterFactory);
        }
        return this.formPage.getContentProvider();
    }

    public IBaseLabelProvider getLabelProvider() {
        if (this.labelProvider == null) {
            this.labelProvider = this.createLabelProvider();
        }
        return this.labelProvider;
    }

    protected IBaseLabelProvider createLabelProvider() {
        EditingDomain editingDomain;
        AdapterFactory adapterFactory = this.getCustomAdapterFactory();
        if (adapterFactory != null && (editingDomain = this.formPage.getTransactionalFormEditor().getEditingDomain()) instanceof TransactionalEditingDomain) {
            return new TransactionalAdapterFactoryLabelProvider((TransactionalEditingDomain)editingDomain, adapterFactory);
        }
        return this.formPage.getLabelProvider();
    }

    protected AdapterFactory getCustomAdapterFactory() {
        return null;
    }

    protected void createViewerContextMenu() {
    }
}

