/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.xtendxpand.jobs;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.mwe.core.issues.Issues;
import org.eclipse.emf.mwe.core.issues.IssuesImpl;
import org.eclipse.emf.mwe.core.issues.MWEDiagnostic;
import org.eclipse.emf.mwe.core.monitor.ProgressMonitor;
import org.eclipse.emf.mwe.core.monitor.ProgressMonitorAdapter;
import org.eclipse.emf.mwe.core.resources.ResourceLoader;
import org.eclipse.emf.mwe.core.resources.ResourceLoaderFactory;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.sphinx.emf.model.IModelDescriptor;
import org.eclipse.sphinx.emf.model.ModelDescriptorRegistry;
import org.eclipse.sphinx.emf.mwe.resources.IWorkspaceResourceLoader;
import org.eclipse.sphinx.emf.util.EcorePlatformUtil;
import org.eclipse.sphinx.platform.IExtendedPlatformConstants;
import org.eclipse.sphinx.platform.util.StatusUtil;
import org.eclipse.sphinx.xtendxpand.CheckEvaluationRequest;
import org.eclipse.sphinx.xtendxpand.internal.Activator;
import org.eclipse.xtend.check.CheckFacade;
import org.eclipse.xtend.expression.ExecutionContext;
import org.eclipse.xtend.expression.ExecutionContextImpl;
import org.eclipse.xtend.expression.ResourceManager;
import org.eclipse.xtend.expression.ResourceManagerDefaultImpl;
import org.eclipse.xtend.expression.TypeSystem;
import org.eclipse.xtend.expression.TypeSystemImpl;
import org.eclipse.xtend.typesystem.MetaModel;

public class CheckJob
extends Job {
    protected static final Log log = LogFactory.getLog(CheckJob.class);
    protected List<MetaModel> metaModels = null;
    protected TypeSystem typeSystem = null;
    protected Collection<CheckEvaluationRequest> checkEvaluationRequests;
    private IWorkspaceResourceLoader workspaceResourceLoader;

    public CheckJob(String name, MetaModel metaModel, CheckEvaluationRequest checkEvaluationRequest) {
        this(name, Collections.singletonList(metaModel), Collections.singleton(checkEvaluationRequest));
    }

    public CheckJob(String name, MetaModel metaModel, Collection<CheckEvaluationRequest> checkEvaluationRequests) {
        this(name, Collections.singletonList(metaModel), checkEvaluationRequests);
    }

    public CheckJob(String name, List<MetaModel> metaModels, CheckEvaluationRequest checkEvaluationRequest) {
        this(name, metaModels, Collections.singleton(checkEvaluationRequest));
    }

    public CheckJob(String name, List<MetaModel> metaModels, Collection<CheckEvaluationRequest> checkEvaluationRequests) {
        super(name);
        Assert.isNotNull(metaModels);
        Assert.isNotNull(checkEvaluationRequests);
        this.metaModels = metaModels;
        this.checkEvaluationRequests = checkEvaluationRequests;
    }

    public CheckJob(String name, TypeSystem typeSystem, CheckEvaluationRequest checkEvaluationRequest) {
        this(name, typeSystem, Collections.singleton(checkEvaluationRequest));
    }

    public CheckJob(String name, TypeSystem typeSystem, Collection<CheckEvaluationRequest> checkEvaluationRequests) {
        super(name);
        Assert.isNotNull((Object)typeSystem);
        Assert.isNotNull(checkEvaluationRequests);
        this.typeSystem = typeSystem;
        this.checkEvaluationRequests = checkEvaluationRequests;
    }

    protected Map<TransactionalEditingDomain, Collection<CheckEvaluationRequest>> getCheckEvaluationRequests() {
        HashMap<TransactionalEditingDomain, Collection<CheckEvaluationRequest>> requests = new HashMap<TransactionalEditingDomain, Collection<CheckEvaluationRequest>>();
        for (CheckEvaluationRequest request : this.checkEvaluationRequests) {
            TransactionalEditingDomain editingDomain = TransactionUtil.getEditingDomain((Object)request.getModelRootObject());
            HashSet<CheckEvaluationRequest> requestsInEditingDomain = (HashSet<CheckEvaluationRequest>)requests.get(editingDomain);
            if (requestsInEditingDomain == null) {
                requestsInEditingDomain = new HashSet<CheckEvaluationRequest>();
                requests.put(editingDomain, requestsInEditingDomain);
            }
            requestsInEditingDomain.add(request);
        }
        return requests;
    }

    public void setWorkspaceResourceLoader(IWorkspaceResourceLoader resourceLoader) {
        this.workspaceResourceLoader = resourceLoader;
    }

    public IStatus run(IProgressMonitor monitor) {
        try {
            log.info((Object)"Check model started...");
            this.installResourceLoader();
            ResourceManagerDefaultImpl resourceManager = new ResourceManagerDefaultImpl();
            HashMap variables = new HashMap();
            HashMap globalVarsMap = new HashMap();
            ExecutionContextImpl execCtx = new ExecutionContextImpl((ResourceManager)resourceManager, null, this.typeSystem instanceof TypeSystemImpl ? (TypeSystemImpl)this.typeSystem : new TypeSystemImpl(), variables, globalVarsMap, (ProgressMonitor)new ProgressMonitorAdapter(monitor), null, null, null, null, null, null, null);
            if (this.metaModels != null) {
                for (MetaModel metaModel : this.metaModels) {
                    execCtx.registerMetaModel(metaModel);
                }
            }
            long startTime = System.currentTimeMillis();
            IssuesImpl diagIssues = new IssuesImpl();
            final Map<TransactionalEditingDomain, Collection<CheckEvaluationRequest>> requests = this.getCheckEvaluationRequests();
            for (final TransactionalEditingDomain editingDomain : requests.keySet()) {
                Runnable runnable = new Runnable((ResourceManager)resourceManager, execCtx, (Issues)diagIssues){
                    private final /* synthetic */ ResourceManager val$resourceManager;
                    private final /* synthetic */ ExecutionContextImpl val$execCtx;
                    private final /* synthetic */ Issues val$diagIssues;
                    {
                        this.val$resourceManager = resourceManager;
                        this.val$execCtx = executionContextImpl;
                        this.val$diagIssues = issues;
                    }

                    @Override
                    public void run() {
                        for (CheckEvaluationRequest request : (Collection)requests.get(editingDomain)) {
                            CheckJob.this.updateResourceLoaderContext(request.getModelRootObject());
                            for (IFile file : request.getCheckFiles()) {
                                CheckJob.this.preCheck(request, file);
                                try {
                                    this.val$resourceManager.setFileEncoding(file.getCharset());
                                }
                                catch (CoreException coreException) {}
                                String path = file.getProjectRelativePath().removeFileExtension().toString();
                                CheckFacade.checkAll((String)path, request.getModelObjects(), (ExecutionContext)this.val$execCtx, (Issues)this.val$diagIssues, (boolean)false);
                                CheckJob.this.postCheck(request, file, this.val$diagIssues);
                            }
                        }
                    }
                };
                if (editingDomain != null) {
                    editingDomain.runExclusive(runnable);
                    continue;
                }
                runnable.run();
            }
            long duration = System.currentTimeMillis() - startTime;
            IStatus iStatus = this.endCheck((Issues)diagIssues, duration);
            return iStatus;
        }
        catch (OperationCanceledException operationCanceledException) {
            IStatus iStatus = Status.CANCEL_STATUS;
            return iStatus;
        }
        catch (Exception ex) {
            IStatus iStatus = StatusUtil.createErrorStatus((Plugin)Activator.getPlugin(), (Object)ex);
            return iStatus;
        }
        finally {
            this.uninstallResourceLoader();
        }
    }

    protected void preCheck(CheckEvaluationRequest request, IFile checkFile) {
        log.info((Object)("Check model with '" + checkFile.getFullPath().makeRelative() + "'"));
    }

    protected void postCheck(CheckEvaluationRequest request, IFile checkFile, Issues diagIssues) {
        ArrayList<MWEDiagnostic> diagnostics = new ArrayList<MWEDiagnostic>();
        diagnostics.addAll(Arrays.asList(diagIssues.getErrors()));
        diagnostics.addAll(Arrays.asList(diagIssues.getWarnings()));
        Iterator iterator = diagnostics.iterator();
        while (iterator.hasNext()) {
            MWEDiagnostic diagnostic = (MWEDiagnostic)iterator.next();
            String message = String.valueOf(diagnostic.getMessage()) + (iterator.hasNext() ? "" : "\n");
            switch (diagnostic.getSeverity()) {
                case 4: {
                    log.error((Object)message);
                    break;
                }
                case 2: {
                    log.warn((Object)message);
                    break;
                }
            }
            diagIssues.add(diagnostic);
        }
    }

    protected IStatus endCheck(Issues diagIssues, long duration) {
        if (diagIssues.hasErrors()) {
            log.error((Object)("Check model failed in " + duration + "ms!\n"));
            return StatusUtil.createErrorStatus((Plugin)Activator.getPlugin(), (Object)"Check model failed with errors");
        }
        if (diagIssues.hasWarnings()) {
            return StatusUtil.createWarningStatus((Plugin)Activator.getPlugin(), (Object)"Check model failed with warnings");
        }
        log.info((Object)("Check model completed in " + duration + "ms!\n"));
        return Status.OK_STATUS;
    }

    protected void installResourceLoader() {
        if (this.workspaceResourceLoader == null) {
            if (ResourceLoaderFactory.getCurrentThreadResourceLoader() instanceof IWorkspaceResourceLoader) {
                this.workspaceResourceLoader = (IWorkspaceResourceLoader)ResourceLoaderFactory.getCurrentThreadResourceLoader();
            }
        } else {
            ResourceLoaderFactory.setCurrentThreadResourceLoader((ResourceLoader)this.workspaceResourceLoader);
        }
    }

    protected void updateResourceLoaderContext(Object contextObject) {
        IFile contextFile;
        IModelDescriptor contextModel;
        if (this.workspaceResourceLoader != null && (contextModel = ModelDescriptorRegistry.INSTANCE.getModel(contextFile = EcorePlatformUtil.getFile((Object)contextObject))) != null) {
            this.workspaceResourceLoader.setContextModel(contextModel);
        }
    }

    protected void uninstallResourceLoader() {
        ResourceLoaderFactory.setCurrentThreadResourceLoader(null);
    }

    public boolean belongsTo(Object family) {
        return IExtendedPlatformConstants.FAMILY_LONG_RUNNING.equals(family);
    }
}

