/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.core.fileservice;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.set.basis.extensions.PathExtensions;
import org.eclipse.set.basis.files.ToolboxFile;
import org.eclipse.set.basis.files.ToolboxFileRole;
import org.eclipse.set.basis.guid.Guid;
import org.eclipse.set.core.fileservice.AbstractToolboxFile;
import org.eclipse.set.core.fileservice.ManifestTransformation;
import org.eclipse.set.model.zipmanifest.Manifest;

public class ZippedPlanProToolboxFile
extends AbstractToolboxFile {
    private static final int BUFFER_SIZE = 1024;
    private static final String MANIFEST_FILE = "manifest.xml";
    private static final String MEDIA_DIR = "media";
    private static final String TECHNICAL_RESOURCE_TYPE_NAME = "content";
    private static final String TRASH_CAN = "trash";
    private static final String ZIP_SEPARATOR = "/";
    private static final String LAYOUT_RESOURCE_TYPE_NAME = "layout";
    private static final String INTERNAL_FORMAT = "planpro";
    private final EditingDomain editingDomain;
    private final ToolboxFile.Format format;
    private boolean loadable;
    private Path path;
    private ToolboxFileRole role;
    private Path temporaryDirectory;

    private static void deleteDir(Path directory) throws IOException {
        if (Files.exists(directory, new LinkOption[0])) {
            Throwable throwable = null;
            Object var2_3 = null;
            try (Stream<Path> files = Files.walk(directory, new FileVisitOption[0]);){
                files.sorted(Comparator.reverseOrder()).map(Path::toFile).forEach(File::delete);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
    }

    private static boolean isDirectory(ZipEntry zipEntry) {
        return zipEntry.getName().endsWith(ZIP_SEPARATOR);
    }

    private static File newFile(Path dir, ZipEntry entry) throws IOException {
        String dirPath;
        File file = new File(dir.toString(), entry.getName());
        String filePath = file.getCanonicalPath();
        if (filePath.startsWith(dirPath = dir.toFile().getCanonicalPath() + File.separator)) {
            return file;
        }
        throw new IOException(String.format("%s is outside of %s", filePath, dirPath));
    }

    ZippedPlanProToolboxFile(ToolboxFile.Format format, EditingDomain editingDomain, ToolboxFileRole role) {
        this.path = null;
        this.format = format;
        this.editingDomain = editingDomain;
        this.loadable = false;
        this.temporaryDirectory = null;
        this.role = role;
        this.setResource(TECHNICAL_RESOURCE_TYPE_NAME, this.createPlanProResource());
    }

    ZippedPlanProToolboxFile(Path path, ToolboxFile.Format format, EditingDomain editingDomain, boolean loadable, ToolboxFileRole role) {
        this.path = path;
        this.format = format;
        this.editingDomain = editingDomain;
        this.loadable = loadable;
        this.temporaryDirectory = null;
        this.role = role;
        this.setResource(TECHNICAL_RESOURCE_TYPE_NAME, this.createPlanProResource());
    }

    ZippedPlanProToolboxFile(ZippedPlanProToolboxFile toolboxFile) {
        this.path = toolboxFile.path;
        this.format = toolboxFile.format;
        this.editingDomain = toolboxFile.editingDomain;
        this.loadable = false;
        this.temporaryDirectory = toolboxFile.temporaryDirectory;
        this.role = toolboxFile.role;
        this.addResource(PathExtensions.getBaseFileName((Path)toolboxFile.getModelPath()), toolboxFile.getPlanProResource());
        this.addResource(PathExtensions.getBaseFileName((Path)toolboxFile.getLayoutPath()), toolboxFile.getLayoutResource());
    }

    private XMLResource createPlanProResource() {
        String contentType = INTERNAL_FORMAT;
        XMLResource newResource = (XMLResource)this.editingDomain.getResourceSet().createResource(URI.createURI((String)"http://www.plan-pro.org/modell/PlanPro/toolbox"), INTERNAL_FORMAT);
        newResource.setEncoding(ENCODING);
        return newResource;
    }

    @Override
    public void close() throws IOException {
        super.close();
        ZippedPlanProToolboxFile.deleteDir(this.getUnzipDirectory());
    }

    public void copyAllMedia(ToolboxFile toolboxfile) throws IOException {
        List allMedia = toolboxfile.getAllMedia();
        allMedia.forEach(id -> {
            try {
                this.copyMedia(toolboxfile, (String)id);
            }
            catch (IOException e) {
                throw new RuntimeException(String.format("Can't copy %s from %s to %s ", id, toolboxfile.getPath().getFileName().toString(), this.getPath().getFileName().toString()));
            }
        });
    }

    public void copyMedia(ToolboxFile toolboxfile, String id) throws IOException {
        if (!toolboxfile.hasMedia(id) || this.hasMedia(id)) {
            return;
        }
        byte[] mediaDaten = toolboxfile.getMedia(Guid.create((String)id));
        if (mediaDaten == null) {
            return;
        }
        this.createMedia(Guid.create((String)id), mediaDaten);
    }

    public void createMedia(Guid guid, byte[] data) throws IOException {
        Path mediaDirectory = this.getMediaDirectory();
        if (!Files.exists(mediaDirectory, new LinkOption[0])) {
            Files.createDirectories(mediaDirectory, new FileAttribute[0]);
        }
        Files.write(this.getMediaPath(guid), data, new OpenOption[0]);
    }

    public void delete(boolean close) throws IOException {
        if (close) {
            this.close();
        }
        Files.delete(this.getPath());
    }

    public void deleteMedia(Guid guid) throws IOException {
        Path source = this.getMediaPath(guid);
        Files.move(source, this.getDeletePath().resolve(source.getFileName()), StandardCopyOption.REPLACE_EXISTING);
    }

    public List<String> getAllMedia() throws IOException {
        LinkedList<String> listMedia = new LinkedList<String>();
        if (!Files.isDirectory(this.getMediaDirectory(), new LinkOption[0])) {
            return List.of();
        }
        Throwable throwable = null;
        Object var3_4 = null;
        try (Stream<Path> listFiles = Files.list(this.getMediaDirectory());){
            listFiles.forEach(media -> listMedia.add(media.getFileName().toString()));
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return listMedia;
    }

    public EditingDomain getEditingDomain() {
        return this.editingDomain;
    }

    public ToolboxFile.Format getFormat() {
        return this.format;
    }

    public byte[] getMedia(Guid guid) throws IOException {
        return Files.readAllBytes(this.getMediaPath(guid));
    }

    public Path getModelPath() {
        if (this.temporaryDirectory != null) {
            return Paths.get(this.temporaryDirectory.toString(), this.role.toDirectoryName(), "content.xml").toAbsolutePath();
        }
        throw new IllegalStateException("No temporary directory set.");
    }

    public Path getLayoutPath() {
        if (this.temporaryDirectory != null) {
            return Paths.get(this.temporaryDirectory.toString(), this.role.toDirectoryName(), "layout.xml").toAbsolutePath();
        }
        throw new IllegalStateException("No temporary directory set.");
    }

    public Path getPath() {
        return this.path;
    }

    public ToolboxFileRole getRole() {
        return this.role;
    }

    public boolean hasDetachedAttachments() {
        return true;
    }

    public boolean hasMedia(String id) {
        if (id == null) {
            return false;
        }
        Path mediaPath = Paths.get(this.getMediaDirectory().toString(), id);
        return Files.exists(mediaPath, new LinkOption[0]);
    }

    public boolean isLoadable() {
        return this.loadable;
    }

    public void openModel() throws IOException {
        if (!this.isLoadable()) {
            throw new IllegalStateException("Toolbox file not loadable.");
        }
        this.generateMD5CheckSum();
        this.unzip();
        this.loadResource(this.getModelPath(), this.editingDomain);
    }

    public void openLayout() throws IOException {
        if (Files.exists(this.getLayoutPath(), new LinkOption[0])) {
            this.loadResource(this.getLayoutPath(), this.editingDomain);
        }
    }

    @Override
    public void save() throws IOException {
        this.resources.forEach((contentName, resource) -> {
            try {
                this.saveResource((XMLResource)resource);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
        this.zip();
    }

    @Override
    public void saveResource(XMLResource resource) throws IOException {
        if (!resource.getURI().isFile()) {
            throw new IllegalStateException(Optional.ofNullable(resource.getURI()).map(u -> "Illegal uri " + u.toString()).orElse("no uri"));
        }
        resource.save(null);
        this.writeManifest();
        this.editingDomain.getCommandStack().flush();
        this.loadable = true;
    }

    public void setPath(Path path) {
        this.path = path;
        this.setResourcePath((Resource)this.getPlanProResource(), this.getModelPath());
        if (this.getLayoutResource() != null) {
            this.setResourcePath((Resource)this.getLayoutResource(), this.getLayoutPath());
        }
    }

    public void setRole(ToolboxFileRole role) {
        this.role = role;
    }

    public void setTemporaryDirectory(Path path) {
        this.temporaryDirectory = path;
    }

    private Path getDeletePath() throws IOException {
        Path deletePath = Paths.get(this.temporaryDirectory.toString(), TRASH_CAN);
        if (!Files.exists(deletePath, new LinkOption[0])) {
            Files.createDirectories(deletePath, new FileAttribute[0]);
        }
        return deletePath;
    }

    private Path getMediaDirectory() {
        return Paths.get(this.getUnzipDirectory().toString(), MEDIA_DIR);
    }

    private Path getMediaPath(Guid guid) {
        return Paths.get(this.getMediaDirectory().toString(), guid.toString());
    }

    private Path getUnzipDirectory() {
        return this.getModelPath().getParent();
    }

    private void unzip() throws IOException {
        Path unzipDir = this.getUnzipDirectory();
        ZippedPlanProToolboxFile.deleteDir(unzipDir);
        Files.createDirectories(unzipDir, new FileAttribute[0]);
        byte[] buffer = new byte[1024];
        Throwable throwable = null;
        Object var4_5 = null;
        try (ZipInputStream zipIn = new ZipInputStream(new FileInputStream(this.getPath().toString()));){
            ZipEntry zipEntry = zipIn.getNextEntry();
            while (zipEntry != null) {
                File newFile = ZippedPlanProToolboxFile.newFile(unzipDir, zipEntry);
                if (ZippedPlanProToolboxFile.isDirectory(zipEntry)) {
                    newFile.mkdirs();
                } else {
                    newFile.getParentFile().mkdirs();
                    Throwable throwable2 = null;
                    Object var9_12 = null;
                    try (FileOutputStream fos = new FileOutputStream(newFile);){
                        int len;
                        while ((len = zipIn.read(buffer)) > 0) {
                            fos.write(buffer, 0, len);
                        }
                    }
                    catch (Throwable throwable3) {
                        if (throwable2 == null) {
                            throwable2 = throwable3;
                        } else if (throwable2 != throwable3) {
                            throwable2.addSuppressed(throwable3);
                        }
                        throw throwable2;
                    }
                }
                zipEntry = zipIn.getNextEntry();
            }
            zipIn.closeEntry();
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }

    private void writeManifest() throws IOException {
        ManifestTransformation transformation = new ManifestTransformation();
        Manifest manifest = transformation.transform(this);
        manifest.eResource().save(null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void zip() throws IOException {
        Path zipDir = this.getModelPath().getParent();
        Throwable throwable = null;
        Object var3_4 = null;
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(this.getPath().toString());
            try {
                try (ZipOutputStream zipOut = new ZipOutputStream(fileOutputStream);){
                    this.zip(zipDir.toFile(), Paths.get("", new String[0]), zipOut);
                }
                if (fileOutputStream == null) return;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                if (fileOutputStream == null) throw throwable;
                fileOutputStream.close();
                throw throwable;
            }
            fileOutputStream.close();
            return;
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            } else {
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    private void zip(File file, Path zipPath, ZipOutputStream zipOut) throws IOException {
        if (file.isDirectory()) {
            File[] dirContents;
            if (!zipPath.toString().isEmpty()) {
                String entryName = zipPath.toString() + ZIP_SEPARATOR;
                zipOut.putNextEntry(new ZipEntry(entryName));
                zipOut.closeEntry();
            }
            File[] fileArray = dirContents = file.listFiles();
            int n = dirContents.length;
            int n2 = 0;
            while (n2 < n) {
                File child = fileArray[n2];
                this.zip(child, Paths.get(zipPath.toString(), child.getName()), zipOut);
                ++n2;
            }
        } else {
            Throwable throwable = null;
            Object var5_14 = null;
            try (FileInputStream fileIn = new FileInputStream(file);){
                int len;
                ZipEntry zipEntry = new ZipEntry(zipPath.toString());
                zipOut.putNextEntry(zipEntry);
                byte[] buffer = new byte[1024];
                while ((len = fileIn.read(buffer)) >= 0) {
                    zipOut.write(buffer, 0, len);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
    }

    URI getManifestUri() {
        if (this.temporaryDirectory != null) {
            return URI.createFileURI((String)Paths.get(this.temporaryDirectory.toString(), this.role.toDirectoryName(), MANIFEST_FILE).toString());
        }
        throw new IllegalStateException("No temporary directory set.");
    }

    @Override
    protected String getContentType(Path modelPath) {
        return modelPath == null ? TECHNICAL_RESOURCE_TYPE_NAME : PathExtensions.getBaseFileName((Path)modelPath);
    }

    public XMLResource getPlanProResource() {
        return this.getResource(TECHNICAL_RESOURCE_TYPE_NAME);
    }

    public XMLResource getLayoutResource() {
        return this.getResource(LAYOUT_RESOURCE_TYPE_NAME);
    }
}

