/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.model.tablemodel.extensions;

import com.google.common.base.Objects;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import com.google.common.html.HtmlEscapers;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.function.Consumer;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.set.model.tablemodel.CellContent;
import org.eclipse.set.model.tablemodel.CompareCellContent;
import org.eclipse.set.model.tablemodel.MultiColorCellContent;
import org.eclipse.set.model.tablemodel.MultiColorContent;
import org.eclipse.set.model.tablemodel.StringCellContent;
import org.eclipse.set.model.tablemodel.TableCell;
import org.eclipse.set.model.tablemodel.extensions.TableCellExtensions;
import org.eclipse.set.utils.StringExtensions;
import org.eclipse.set.utils.ToolboxConfiguration;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class CellContentExtensions {
    public static final String WARNING_MARK_YELLOW = "<!-- warning-mark-yellow -->";
    public static final String WARNING_MARK_RED = "<!-- warning-mark-red -->";
    public static final String WARNING_MARK_BLACK = "<!-- warning-mark-black -->";
    private static final String ERROR_PREFIX = "Error:";

    protected static String _getRichTextValue(CellContent content) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("Content ");
        String _simpleName = content.getClass().getSimpleName();
        _builder.append(_simpleName);
        _builder.append(" not supported.");
        return _builder.toString();
    }

    protected static String _getRichTextValue(Void content) {
        return "";
    }

    protected static String _getRichTextValue(StringCellContent content) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("<p style=\"text-align:");
        String _textAlign = CellContentExtensions.getTextAlign((CellContent)content);
        _builder.append(_textAlign);
        _builder.append("\">");
        String _valueFormat = CellContentExtensions.getValueFormat((CellContent)content);
        _builder.append(_valueFormat);
        _builder.append("</p>");
        return _builder.toString();
    }

    protected static String _getRichTextValue(final CompareCellContent content) {
        boolean _equals = content.getOldValue().equals((Object)content.getNewValue());
        if (_equals) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("<p style=\"text-align:");
            String _textAlign = CellContentExtensions.getTextAlign((CellContent)content);
            _builder.append(_textAlign);
            _builder.append("\">");
            String _htmlString = CellContentExtensions.getHtmlString(CellContentExtensions.iterableToString((Iterable<String>)content.getNewValue(), content.getSeparator()));
            _builder.append(_htmlString);
            _builder.append("</p>");
            return _builder.toString();
        }
        final LinkedList result = CollectionLiterals.newLinkedList();
        EList _oldValue = content.getOldValue();
        EList _newValue = content.getNewValue();
        Consumer<String> _function = new Consumer<String>(){

            @Override
            public void accept(String it) {
                Functions.Function2<String, String, String> _function = new Functions.Function2<String, String, String>(){

                    public String apply(String $0, String $1) {
                        return CellContentExtensions.getCompareValueFormat($0, $1);
                    }
                };
                result.add(CellContentExtensions.getCompareContentValueFormat(content, _function, it));
            }
        };
        IterableExtensions.sort((Iterable)IterableExtensions.toSet((Iterable)IterableExtensions.filterNull((Iterable)Iterables.concat(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new EList[]{_oldValue, _newValue})))))).forEach(_function);
        StringConcatenation _builder_1 = new StringConcatenation();
        _builder_1.append("<p style=\"text-align:");
        String _textAlign_1 = CellContentExtensions.getTextAlign((CellContent)content);
        _builder_1.append(_textAlign_1);
        _builder_1.append("\">");
        String _xifexpression = null;
        _xifexpression = content.getSeparator() == null || content.getSeparator().equals("\r\n") ? "<br></br>" : content.getSeparator();
        String _iterableToString = CellContentExtensions.iterableToString(result, _xifexpression);
        _builder_1.append(_iterableToString);
        _builder_1.append("</p>");
        return _builder_1.toString();
    }

    protected static String _getRichTextValue(MultiColorCellContent content) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("<p style=\"text-align:");
        String _textAlign = CellContentExtensions.getTextAlign((CellContent)content);
        _builder.append(_textAlign);
        _builder.append("\">");
        String _multiColorFormat = CellContentExtensions.getMultiColorFormat(content);
        _builder.append(_multiColorFormat);
        _builder.append("</p>");
        return _builder.toString();
    }

    protected static String _getPlainStringValue(CellContent content) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("Content ");
        String _simpleName = content.getClass().getSimpleName();
        _builder.append(_simpleName);
        _builder.append(" not supported.");
        return _builder.toString();
    }

    protected static String _getPlainStringValue(Void content) {
        return "";
    }

    protected static String _getPlainStringValue(StringCellContent content) {
        return CellContentExtensions.iterableToString((Iterable<String>)content.getValue(), content.getSeparator());
    }

    protected static String _getPlainStringValue(CompareCellContent content) {
        StringConcatenation _builder = new StringConcatenation();
        EList _oldValue = content.getOldValue();
        _builder.append((Object)_oldValue);
        _builder.append("/");
        EList _newValue = content.getNewValue();
        _builder.append((Object)_newValue);
        return _builder.toString();
    }

    protected static String _getPlainStringValue(MultiColorCellContent content) {
        StringConcatenation _builder = new StringConcatenation();
        EList _value = content.getValue();
        boolean _hasElements = false;
        for (MultiColorContent value : _value) {
            if (!_hasElements) {
                _hasElements = true;
            } else {
                String _separator = content.getSeparator();
                _builder.appendImmediate((Object)_separator, "");
            }
            String _format = String.format(value.getStringFormat(), value.getMultiColorValue());
            _builder.append(_format);
        }
        return _builder.toString();
    }

    protected static Iterable<String> _getStringValueIterable(Void content) {
        return Collections.unmodifiableList(CollectionLiterals.newArrayList());
    }

    protected static Iterable<String> _getStringValueIterable(CellContent content) {
        String _plainStringValue = CellContentExtensions.getPlainStringValue(content);
        return Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new String[]{_plainStringValue}));
    }

    protected static Iterable<String> _getStringValueIterable(StringCellContent content) {
        return content.getValue();
    }

    public static boolean isErrorText(String text) {
        return text != null && text.startsWith(ERROR_PREFIX);
    }

    public static TableCell getTableCell(CellContent content) {
        EObject _eContainer = content.eContainer();
        return (TableCell)_eContainer;
    }

    private static String getTextAlign(CellContent content) {
        return TableCellExtensions.getFormat(CellContentExtensions.getTableCell(content)).getTextAlignment().getLiteral();
    }

    private static String _getValueFormat(StringCellContent content) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("<span>");
        String _valueHtmlString = CellContentExtensions.getValueHtmlString(content);
        _builder.append(_valueHtmlString);
        _builder.append("</span>");
        return _builder.toString();
    }

    private static String _getValueFormat(MultiColorCellContent content) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("<span>");
        String _htmlString = CellContentExtensions.getHtmlString(CellContentExtensions.getMultiColorFormat(content));
        _builder.append(_htmlString);
        _builder.append("</span>");
        return _builder.toString();
    }

    public static <T> T getCompareContentValueFormat(CompareCellContent content, Functions.Function2<? super String, ? super String, ? extends T> getFormatFunction, String value) {
        if (content.getOldValue().contains((Object)value) && content.getNewValue().contains((Object)value)) {
            return (T)getFormatFunction.apply((Object)WARNING_MARK_BLACK, (Object)value);
        }
        boolean _contains = content.getOldValue().contains((Object)value);
        if (_contains) {
            return (T)getFormatFunction.apply((Object)WARNING_MARK_YELLOW, (Object)value);
        }
        return (T)getFormatFunction.apply((Object)WARNING_MARK_RED, (Object)value);
    }

    private static String getCompareValueFormat(String warning_mark, String value) {
        boolean _isNullOrEmpty = Strings.isNullOrEmpty((String)value);
        if (_isNullOrEmpty) {
            return "";
        }
        boolean _isErrorText = CellContentExtensions.isErrorText(value);
        if (_isErrorText) {
            return warning_mark;
        }
        boolean _matched = false;
        if (Objects.equal((Object)warning_mark, (Object)WARNING_MARK_BLACK)) {
            _matched = true;
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("<span>");
            String _htmlString = CellContentExtensions.getHtmlString(value);
            _builder.append(_htmlString);
            _builder.append("</span>");
            return _builder.toString();
        }
        if (!_matched && Objects.equal((Object)warning_mark, (Object)WARNING_MARK_YELLOW)) {
            _matched = true;
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append("<span style=\"background-color:rgb(255,255, 0)\"><s>");
            String _htmlString_1 = CellContentExtensions.getHtmlString(value);
            _builder_1.append(_htmlString_1);
            _builder_1.append("</s></span>");
            return _builder_1.toString();
        }
        if (!_matched && Objects.equal((Object)warning_mark, (Object)WARNING_MARK_RED)) {
            _matched = true;
            StringConcatenation _builder_2 = new StringConcatenation();
            _builder_2.append("<span style=\"color:rgb(255, 0, 0)\">");
            String _htmlString_2 = CellContentExtensions.getHtmlString(value);
            _builder_2.append(_htmlString_2);
            _builder_2.append("</span>");
            return _builder_2.toString();
        }
        return null;
    }

    private static String getMultiColorFormat(MultiColorCellContent content) {
        boolean _isEmpty = content.getValue().isEmpty();
        if (_isEmpty) {
            return "";
        }
        StringConcatenation _builder = new StringConcatenation();
        EList _value = content.getValue();
        boolean _hasElements = false;
        for (MultiColorContent element : _value) {
            if (!_hasElements) {
                _hasElements = true;
            } else {
                String _separator = content.getSeparator();
                _builder.appendImmediate((Object)_separator, "");
            }
            String _multiColorFormat = CellContentExtensions.getMultiColorFormat(element);
            _builder.append(_multiColorFormat);
        }
        return _builder.toString();
    }

    private static String getMultiColorFormat(MultiColorContent content) {
        boolean _isNullOrEmpty = Strings.isNullOrEmpty((String)content.getMultiColorValue());
        if (_isNullOrEmpty) {
            String _xifexpression = null;
            boolean _isNullOrEmpty_1 = Strings.isNullOrEmpty((String)content.getStringFormat());
            _xifexpression = _isNullOrEmpty_1 ? "" : CellContentExtensions.getHtmlString(content.getStringFormat());
            return _xifexpression;
        }
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("<span style=\"background-color:rgb(255,255, 0)\">");
        String _multiColorValueHtmlString = CellContentExtensions.getMultiColorValueHtmlString(content, WARNING_MARK_YELLOW);
        _builder.append(_multiColorValueHtmlString);
        _builder.append("</span><span style=\"color:rgb(255, 0, 0)\">");
        String _multiColorValueHtmlString_1 = CellContentExtensions.getMultiColorValueHtmlString(content, WARNING_MARK_RED);
        _builder.append(_multiColorValueHtmlString_1);
        _builder.append("</span>");
        String value = _builder.toString();
        StringConcatenation _builder_1 = new StringConcatenation();
        _builder_1.append("<span>");
        String _format = String.format(content.getStringFormat(), value);
        _builder_1.append(_format);
        _builder_1.append("</span>");
        return _builder_1.toString();
    }

    private static String getValueHtmlString(StringCellContent content) {
        String contentValue = CellContentExtensions.iterableToString((Iterable<String>)content.getValue(), content.getSeparator());
        if (CellContentExtensions.isErrorText(contentValue) && !ToolboxConfiguration.isDevelopmentMode()) {
            return WARNING_MARK_BLACK;
        }
        return CellContentExtensions.getHtmlString(contentValue);
    }

    private static String getMultiColorValueHtmlString(MultiColorContent content, String warningColor) {
        if (CellContentExtensions.isErrorText(content.getMultiColorValue()) && !ToolboxConfiguration.isDevelopmentMode()) {
            return warningColor;
        }
        return CellContentExtensions.getHtmlString(content.getMultiColorValue());
    }

    private static String getHtmlString(String value) {
        return HtmlEscapers.htmlEscaper().escape(StringExtensions.intersperseWithZeroSpacesSC((String)value)).replaceAll("\n", "<br></br>");
    }

    public static String iterableToString(Iterable<String> sequence, String separator) {
        StringConcatenation _builder = new StringConcatenation();
        boolean _hasElements = false;
        for (String element : sequence) {
            if (!_hasElements) {
                _hasElements = true;
            } else {
                String _xifexpression = null;
                _xifexpression = separator == null ? "\n" : separator;
                _builder.appendImmediate((Object)_xifexpression, "");
            }
            _builder.append(element);
        }
        return _builder.toString();
    }

    public static boolean isEqual(CellContent content, CellContent other) {
        return CellContentExtensions.getPlainStringValue(content).equals(CellContentExtensions.getPlainStringValue(other));
    }

    public static String getRichTextValue(CellContent content) {
        if (content instanceof CompareCellContent) {
            return CellContentExtensions._getRichTextValue((CompareCellContent)content);
        }
        if (content instanceof MultiColorCellContent) {
            return CellContentExtensions._getRichTextValue((MultiColorCellContent)content);
        }
        if (content instanceof StringCellContent) {
            return CellContentExtensions._getRichTextValue((StringCellContent)content);
        }
        if (content != null) {
            return CellContentExtensions._getRichTextValue(content);
        }
        return CellContentExtensions._getRichTextValue(null);
    }

    public static String getPlainStringValue(CellContent content) {
        if (content instanceof CompareCellContent) {
            return CellContentExtensions._getPlainStringValue((CompareCellContent)content);
        }
        if (content instanceof MultiColorCellContent) {
            return CellContentExtensions._getPlainStringValue((MultiColorCellContent)content);
        }
        if (content instanceof StringCellContent) {
            return CellContentExtensions._getPlainStringValue((StringCellContent)content);
        }
        if (content != null) {
            return CellContentExtensions._getPlainStringValue(content);
        }
        return CellContentExtensions._getPlainStringValue(null);
    }

    public static Iterable<String> getStringValueIterable(CellContent content) {
        if (content instanceof StringCellContent) {
            return CellContentExtensions._getStringValueIterable((StringCellContent)content);
        }
        if (content != null) {
            return CellContentExtensions._getStringValueIterable(content);
        }
        return CellContentExtensions._getStringValueIterable(null);
    }

    private static String getValueFormat(CellContent content) {
        if (content instanceof MultiColorCellContent) {
            return CellContentExtensions._getValueFormat((MultiColorCellContent)content);
        }
        if (content instanceof StringCellContent) {
            return CellContentExtensions._getValueFormat((StringCellContent)content);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(content).toString());
    }
}

