/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.emfforms.view;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;
import org.eclipse.core.databinding.Binding;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecp.ui.view.ECPRendererException;
import org.eclipse.emf.ecp.ui.view.swt.ECPSWTViewRenderer;
import org.eclipse.emf.ecp.view.spi.context.ViewModelContext;
import org.eclipse.emf.ecp.view.spi.context.ViewModelContextFactory;
import org.eclipse.emf.ecp.view.spi.core.swt.SimpleControlSWTControlSWTRenderer;
import org.eclipse.emf.ecp.view.spi.model.VContainedElement;
import org.eclipse.emf.ecp.view.spi.model.VControl;
import org.eclipse.emf.ecp.view.spi.model.VDomainModelReference;
import org.eclipse.emf.ecp.view.spi.model.VElement;
import org.eclipse.emf.ecp.view.spi.model.VFeaturePathDomainModelReference;
import org.eclipse.emf.ecp.view.spi.model.VView;
import org.eclipse.emf.ecp.view.spi.provider.ViewProviderHelper;
import org.eclipse.emf.ecp.view.template.model.VTViewTemplateProvider;
import org.eclipse.emfforms.spi.common.report.ReportService;
import org.eclipse.emfforms.spi.core.services.databinding.DatabindingFailedException;
import org.eclipse.emfforms.spi.core.services.databinding.EMFFormsDatabinding;
import org.eclipse.emfforms.spi.core.services.label.EMFFormsLabelProvider;
import org.eclipse.set.utils.emfforms.Annotations;
import org.eclipse.set.utils.emfforms.Renderers;
import org.eclipse.set.utils.emfforms.TypedSetting;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ViewRenderer
extends SimpleControlSWTControlSWTRenderer {
    public static final String BORDER_DISABLED_KEY = "viewBorderDisabled";
    private static final String READONLY_ACTION = "readonlyControlAction";
    static final Logger LOGGER = LoggerFactory.getLogger(ViewRenderer.class);

    private static void setReadonlyControlinView(VView view, List<String> controls) {
        for (VContainedElement vContainedElement : view.getChildren()) {
            if (!(vContainedElement instanceof VControl)) continue;
            VDomainModelReference domainModelReference = ((VControl)VControl.class.cast(vContainedElement)).getDomainModelReference();
            if (!(domainModelReference instanceof VFeaturePathDomainModelReference)) {
                return;
            }
            VFeaturePathDomainModelReference featurepathdomainModelReference = (VFeaturePathDomainModelReference)domainModelReference;
            boolean contains = controls.contains(featurepathdomainModelReference.getDomainModelEFeature().getName().toString());
            if (!contains) continue;
            vContainedElement.setReadonly(true);
        }
    }

    @Inject
    public ViewRenderer(VControl vElement, ViewModelContext viewContext, ReportService reportService, EMFFormsDatabinding emfFormsDatabinding, EMFFormsLabelProvider emfFormsLabelProvider, VTViewTemplateProvider vtViewTemplateProvider) {
        super(vElement, viewContext, reportService, emfFormsDatabinding, emfFormsLabelProvider, vtViewTemplateProvider);
        LOGGER.debug("Render {}", (Object)vElement);
    }

    private TypedSetting<EObject> getTypedSetting() {
        return Renderers.getTypedSetting(EObject.class, (VElement)this.getVElement(), (ViewModelContext)this.getViewModelContext());
    }

    protected Binding[] createBindings(Control control) throws DatabindingFailedException {
        return null;
    }

    protected Control createSWTControl(Composite parent) {
        EObject domainElement;
        if (!((VControl)this.getVElement()).isVisible()) {
            return null;
        }
        boolean borderDisabled = Boolean.parseBoolean(Annotations.getViewModelValue((VElement)this.getVElement(), (String)BORDER_DISABLED_KEY));
        Object subElementComposite = borderDisabled ? new Composite(parent, 0) : new Group(parent, 16);
        subElementComposite.setLayout((Layout)new GridLayout(1, false));
        String readonlycontrols = Annotations.getViewModelValue((VElement)this.getVElement(), (String)READONLY_ACTION);
        TypedSetting<EObject> typedSetting = this.getTypedSetting();
        EStructuralFeature feature = typedSetting.getEStructuralFeature();
        Optional value = typedSetting.getValue();
        if (value.isPresent()) {
            domainElement = (EObject)value.get();
        } else {
            LOGGER.debug("Value of feature {} not present, creating...", (Object)feature.getName());
            EClass eClass = (EClass)feature.getEType();
            domainElement = eClass.getEPackage().getEFactoryInstance().create(eClass);
            EObject eParent = typedSetting.getEObject();
            eParent.eSet(feature, (Object)domainElement);
        }
        VView view = ViewProviderHelper.getView((EObject)domainElement, null);
        ViewModelContext viewModelContext = ViewModelContextFactory.INSTANCE.createViewModelContext((VElement)view, domainElement);
        if (readonlycontrols != null && view instanceof VView) {
            String[] listdisablecontrols = readonlycontrols.split(",");
            ViewRenderer.setReadonlyControlinView(view, Arrays.asList(listdisablecontrols));
        }
        try {
            ECPSWTViewRenderer.INSTANCE.render(subElementComposite, viewModelContext);
        }
        catch (ECPRendererException e) {
            throw new RuntimeException(e);
        }
        return subElementComposite;
    }

    protected String getUnsetText() {
        return null;
    }
}

