/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.emfforms.group;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.Optional;
import javax.inject.Inject;
import org.eclipse.core.databinding.Binding;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.command.CommandStackListener;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecp.ui.view.ECPRendererException;
import org.eclipse.emf.ecp.ui.view.swt.ECPSWTView;
import org.eclipse.emf.ecp.ui.view.swt.ECPSWTViewRenderer;
import org.eclipse.emf.ecp.view.spi.context.ViewModelContext;
import org.eclipse.emf.ecp.view.spi.context.ViewModelContextFactory;
import org.eclipse.emf.ecp.view.spi.core.swt.SimpleControlSWTControlSWTRenderer;
import org.eclipse.emf.ecp.view.spi.model.VControl;
import org.eclipse.emf.ecp.view.spi.model.VElement;
import org.eclipse.emf.ecp.view.spi.model.VView;
import org.eclipse.emf.ecp.view.spi.provider.ViewProviderHelper;
import org.eclipse.emf.ecp.view.template.model.VTViewTemplateProvider;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emfforms.spi.common.report.ReportService;
import org.eclipse.emfforms.spi.core.services.databinding.DatabindingFailedException;
import org.eclipse.emfforms.spi.core.services.databinding.EMFFormsDatabinding;
import org.eclipse.emfforms.spi.core.services.label.EMFFormsLabelProvider;
import org.eclipse.set.emfforms.basisattribute.BasisAttributeSetting;
import org.eclipse.set.utils.emfforms.Renderers;
import org.eclipse.set.utils.emfforms.TypedSetting;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GroupRenderer
extends SimpleControlSWTControlSWTRenderer {
    private static final String SHADOW_URI = "tag:scheidt-bachmann-st.de,2017-10-25:toolbox/shadow";
    static final Logger LOGGER = LoggerFactory.getLogger(GroupRenderer.class);
    private CommandStackListener commandStackListener;
    private final EditingDomain editingDomain;
    private boolean linking = false;
    private boolean recentlyUndone = false;
    private ECPSWTView renderedView;
    private EObject shadow;

    public static boolean isApplicable(EClassifier type) {
        return !BasisAttributeSetting.isWertFeatureTypeAssignableTo(type, Object.class);
    }

    private static void refreshElement(TypedSetting<Object> typedSetting) {
        EObject object = typedSetting.getEObject();
        EStructuralFeature feature = typedSetting.getEStructuralFeature();
        Object value = typedSetting.getValue().orElse(null);
        EClass eClass = (EClass)feature.getEType();
        EObject newValue = eClass.getEPackage().getEFactoryInstance().create(eClass);
        object.eSet(feature, (Object)newValue);
        object.eSet(feature, value);
    }

    private static void refreshList(TypedSetting<Object> typedSetting) {
        Object value = typedSetting.getValue().orElse(null);
        Collection collection = value;
        ArrayList saved = Lists.newArrayList((Iterable)collection);
        collection.clear();
        collection.addAll(saved);
    }

    @Inject
    public GroupRenderer(VControl vElement, ViewModelContext viewContext, ReportService reportService, EMFFormsDatabinding emfFormsDatabinding, EMFFormsLabelProvider emfFormsLabelProvider, VTViewTemplateProvider vtViewTemplateProvider) {
        super(vElement, viewContext, reportService, emfFormsDatabinding, emfFormsLabelProvider, vtViewTemplateProvider);
        LOGGER.debug("Render {}", (Object)vElement);
        this.editingDomain = AdapterFactoryEditingDomain.getEditingDomainFor((EObject)this.getTypedSetting().getEObject());
    }

    private void createShadowModel() {
        TypedSetting<EObject> typedSetting = this.getTypedSetting();
        EStructuralFeature feature = typedSetting.getEStructuralFeature();
        Optional value = typedSetting.getValue();
        if (value.isPresent()) {
            this.shadow = (EObject)value.get();
        } else {
            EClass eClass = (EClass)feature.getEType();
            this.shadow = eClass.getEPackage().getEFactoryInstance().create(eClass);
            Resource shadowResource = this.editingDomain.getResourceSet().createResource(URI.createURI((String)SHADOW_URI));
            shadowResource.eAdapters().add((Object)new AdapterFactoryEditingDomain.EditingDomainProvider(this.editingDomain));
            shadowResource.getContents().add((Object)this.shadow);
        }
    }

    private EObject getShadow() {
        return this.shadow;
    }

    private TypedSetting<EObject> getTypedSetting() {
        return Renderers.getTypedSetting(EObject.class, (VElement)this.getVElement(), (ViewModelContext)this.getViewModelContext());
    }

    private boolean isEmpty(VControl control) {
        TypedSetting typedSetting = Renderers.getTypedSetting(Object.class, (VElement)control, (ViewModelContext)this.renderedView.getViewModelContext());
        if (!typedSetting.getValue().isPresent()) {
            return true;
        }
        Object object = typedSetting.getValue().get();
        if (object instanceof Collection) {
            Collection collection = (Collection)object;
            return collection.isEmpty();
        }
        return false;
    }

    private boolean isEmptyView() {
        if (this.renderedView == null) {
            LOGGER.warn("renderView == null, but renderedView should never be null");
            return true;
        }
        TreeIterator allContents = this.renderedView.getViewModelContext().getViewModel().eAllContents();
        while (allContents.hasNext()) {
            EObject object = (EObject)allContents.next();
            if (!(object instanceof VControl) || this.isEmpty((VControl)object)) continue;
            return false;
        }
        return true;
    }

    private void refresh(VControl control) {
        TypedSetting typedSetting = Renderers.getTypedSetting(Object.class, (VElement)control, (ViewModelContext)this.renderedView.getViewModelContext());
        if (typedSetting == null) {
            return;
        }
        if (typedSetting.getEStructuralFeature().getUpperBound() != 1) {
            GroupRenderer.refreshList((TypedSetting<Object>)typedSetting);
        } else {
            GroupRenderer.refreshElement((TypedSetting<Object>)typedSetting);
        }
    }

    private void refreshShadowView() {
        TreeIterator allContents = this.renderedView.getViewModelContext().getViewModel().eAllContents();
        while (allContents.hasNext()) {
            EObject object = (EObject)allContents.next();
            if (!(object instanceof VControl)) continue;
            this.refresh((VControl)object);
        }
    }

    private void registerNewCommandStackListener() {
        CommandStack commandStack = this.editingDomain.getCommandStack();
        this.commandStackListener = new CommandStackListener(){

            public void commandStackChanged(EventObject event) {
                GroupRenderer.this.checkLinkShadow();
            }
        };
        commandStack.addCommandStackListener(this.commandStackListener);
    }

    private void setCommand(EObject object, EStructuralFeature feature, EObject value) {
        Command command = SetCommand.create((EditingDomain)this.editingDomain, (Object)object, (Object)feature, (Object)value);
        this.editingDomain.getCommandStack().execute(command);
    }

    private boolean shadowShouldBeLinked(EStructuralFeature feature) {
        if (feature.getLowerBound() == 1) {
            return true;
        }
        return !this.isEmptyView();
    }

    private boolean undoing() {
        boolean undoing;
        boolean bl = undoing = this.editingDomain.getCommandStack().canUndo() && this.editingDomain.getCommandStack().canRedo();
        if (undoing) {
            this.recentlyUndone = true;
        }
        return undoing;
    }

    private void unregisterCommandStackListener() {
        this.editingDomain.getCommandStack().removeCommandStackListener(this.commandStackListener);
    }

    protected Binding[] createBindings(Control control) throws DatabindingFailedException {
        return null;
    }

    protected Composite createSubElementContainer(Composite parent) {
        Group subElementComposite = new Group(parent, 16);
        subElementComposite.setLayout((Layout)new GridLayout());
        return subElementComposite;
    }

    protected Control createSWTControl(Composite parent) throws DatabindingFailedException {
        this.createShadowModel();
        this.registerNewCommandStackListener();
        Composite subElementComposite = this.createSubElementContainer(parent);
        EObject domainElement = this.getShadow();
        VView view = ViewProviderHelper.getView((EObject)domainElement, null);
        ViewModelContext viewModelContext = ViewModelContextFactory.INSTANCE.createViewModelContext((VElement)view, domainElement);
        try {
            this.renderedView = ECPSWTViewRenderer.INSTANCE.render(subElementComposite, viewModelContext);
            Assert.isNotNull((Object)this.renderedView);
        }
        catch (ECPRendererException e) {
            throw new RuntimeException(e);
        }
        this.checkLinkShadow();
        return subElementComposite;
    }

    protected void dispose() {
        this.unregisterCommandStackListener();
        super.dispose();
    }

    protected String getUnsetText() {
        return null;
    }

    void checkLinkShadow() {
        if (!this.linking && !this.undoing()) {
            this.linking = true;
            try {
                TypedSetting<EObject> typedSetting = this.getTypedSetting();
                EObject object = typedSetting.getEObject();
                EStructuralFeature feature = typedSetting.getEStructuralFeature();
                if (this.shadowShouldBeLinked(feature)) {
                    if (object.eGet(feature) != this.shadow) {
                        this.setCommand(object, feature, this.shadow);
                        LOGGER.debug("Shadow linked.");
                        this.refreshShadowView();
                    }
                } else if (object.eGet(feature) != null) {
                    this.setCommand(object, feature, null);
                    LOGGER.debug("Shadow unlinked.");
                    this.refreshShadowView();
                }
            }
            finally {
                this.linking = false;
            }
            if (this.recentlyUndone) {
                try {
                    this.refreshShadowView();
                }
                finally {
                    this.recentlyUndone = false;
                }
            }
        }
    }
}

