/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.feature.siteplan.parts;

import java.io.IOException;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.core.services.nls.Translation;
import org.eclipse.e4.ui.model.application.MApplicationElement;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.set.basis.IModelSession;
import org.eclipse.set.basis.constants.ToolboxViewState;
import org.eclipse.set.basis.extensions.MApplicationElementExtensions;
import org.eclipse.set.core.services.cache.CacheService;
import org.eclipse.set.core.services.dialog.DialogService;
import org.eclipse.set.core.services.part.ToolboxPartService;
import org.eclipse.set.feature.plazmodel.check.CRSValid;
import org.eclipse.set.feature.siteplan.Messages;
import org.eclipse.set.feature.siteplan.SiteplanBrowser;
import org.eclipse.set.feature.siteplan.browserfunctions.GetSessionStateBrowserFunction;
import org.eclipse.set.feature.siteplan.browserfunctions.JumpToSourceLineBrowserFunction;
import org.eclipse.set.feature.siteplan.browserfunctions.LayoutChangeCRSBrowserFunction;
import org.eclipse.set.feature.siteplan.browserfunctions.SelectFolderDialogBrowserFunction;
import org.eclipse.set.feature.siteplan.browserfunctions.SignalSelectBrowserFunction;
import org.eclipse.set.feature.siteplan.browserfunctions.TableSelectRowBrowserFunction;
import org.eclipse.set.utils.BasePart;
import org.eclipse.set.utils.WebBrowser;
import org.eclipse.set.utils.events.FunctionalToolboxEventHandler;
import org.eclipse.set.utils.events.NewTableTypeEvent;
import org.eclipse.set.utils.events.SelectedRowEvent;
import org.eclipse.set.utils.events.ToolboxEventHandler;
import org.eclipse.set.utils.events.ToolboxEvents;
import org.eclipse.swt.widgets.Composite;

public class WebSiteplanPart
extends BasePart {
    private SignalSelectBrowserFunction signalSelectBrowserFunction;
    @Inject
    @Translation
    protected Messages messages;
    @Inject
    IEclipseContext applicationContext;
    @Inject
    ToolboxPartService partService;
    @Inject
    private DialogService dialogService;
    @Inject
    CacheService cacheService;
    ToolboxEventHandler<SelectedRowEvent> selectRowEvent;
    private SiteplanBrowser webBrowser;

    @PostConstruct
    private void postConstruct() {
        this.selectRowEvent = new FunctionalToolboxEventHandler(this::handleEvent);
        String topic = SelectedRowEvent.getTopic((String)"org.eclipse.set.feature.table.ssks");
        ToolboxEvents.subscribe((IEventBroker)this.getBroker(), SelectedRowEvent.class, this.selectRowEvent, (String)topic);
    }

    private void handleEvent(SelectedRowEvent selectedRowEvent) {
        this.signalSelectBrowserFunction.execute(selectedRowEvent);
    }

    protected void handleNewTableType(NewTableTypeEvent e) {
        this.webBrowser.executeJavascript(String.format("%s()", "window.planproNewTableType"));
    }

    @PreDestroy
    private void preDestroyWebSiteplanPart() {
        ToolboxEvents.unsubscribe((IEventBroker)this.getBroker(), this.selectRowEvent);
        this.webBrowser.stop();
    }

    protected void createView(Composite parent) {
        if (!this.isCRSValid()) {
            MApplicationElementExtensions.setViewState((MApplicationElement)this.getToolboxPart(), (ToolboxViewState)ToolboxViewState.ERROR);
            return;
        }
        try {
            this.webBrowser = new SiteplanBrowser(parent, this.applicationContext, this.getToolboxShell());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.registerJavascriptFunctions();
        GridDataFactory.swtDefaults().align(4, 4).grab(true, true).span(2, 1).applyTo(this.webBrowser.getControl());
        this.webBrowser.setUrl("https://toolbox/?");
    }

    private boolean isCRSValid() {
        CRSValid test = new CRSValid();
        IModelSession modelSession = (IModelSession)this.applicationContext.get(IModelSession.class);
        List listValid = test.run(modelSession);
        if (!listValid.isEmpty()) {
            String fileName = modelSession.getToolboxFile().getPath().toString();
            if (!this.dialogService.sitePlanError(this.getToolboxShell(), fileName)) {
                return false;
            }
        }
        return true;
    }

    private void registerJavascriptFunctions() {
        this.webBrowser.registerJSFunction(new TableSelectRowBrowserFunction((WebBrowser)this.webBrowser, "planproSelectTableRow", this.getBroker()));
        this.webBrowser.registerJSFunction(new SelectFolderDialogBrowserFunction(this.webBrowser, "planproSelectFolderDialog", this.getToolboxShell(), this.getDialogService()));
        this.webBrowser.registerJSFunction(new GetSessionStateBrowserFunction((WebBrowser)this.webBrowser, "planproGetSessionState", this.getModelSession()));
        this.webBrowser.registerJSFunction(new JumpToSourceLineBrowserFunction((WebBrowser)this.webBrowser, "planproJumpToTextView", this.getBroker(), this.partService));
        this.webBrowser.registerJSFunction(new LayoutChangeCRSBrowserFunction((WebBrowser)this.webBrowser, "planproChangeLayoutCRS", this.cacheService));
        this.signalSelectBrowserFunction = new SignalSelectBrowserFunction((WebBrowser)this.webBrowser);
    }
}

