/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.feature.siteplan.browserfunctions;

import org.eclipse.set.model.tablemodel.TableRow;
import org.eclipse.set.model.tablemodel.extensions.TableRowExtensions;
import org.eclipse.set.utils.WebBrowser;
import org.eclipse.set.utils.events.SelectedRowEvent;

public class SignalSelectBrowserFunction {
    private static final String DESELECTED = "DESELECTED";
    private static final String SELECT_SIGNAL_FUNCTION = "window.planproSelectSignal";
    private final WebBrowser webBrowser;

    public SignalSelectBrowserFunction(WebBrowser webbrowser) {
        this.webBrowser = webbrowser;
    }

    public final void execute(String guid) {
        this.webBrowser.executeJavascript(String.format("%s('%s')", SELECT_SIGNAL_FUNCTION, guid));
    }

    public void execute(SelectedRowEvent selectedRowEvent) {
        if (SignalSelectBrowserFunction.isRowSelected(selectedRowEvent)) {
            this.execute(TableRowExtensions.getLeadingObjectGuid((TableRow)selectedRowEvent.getRow()));
        } else {
            this.execute(DESELECTED);
        }
    }

    private static boolean isRowSelected(SelectedRowEvent selectedRowEvent) {
        return selectedRowEvent.getRow() != null;
    }
}

