/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.model.integrationview.util;

import java.util.Map;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.util.EObjectValidator;
import org.eclipse.set.model.integrationview.Conflict;
import org.eclipse.set.model.integrationview.Details;
import org.eclipse.set.model.integrationview.IntegrationView;
import org.eclipse.set.model.integrationview.IntegrationviewPackage;
import org.eclipse.set.model.integrationview.ObjectQuantity;
import org.eclipse.set.utils.StringExtensions;
import org.eclipse.set.utils.ToolboxResourceLocator;

public class IntegrationviewValidator
extends EObjectValidator {
    public static final IntegrationviewValidator INSTANCE = new IntegrationviewValidator();
    public static final String DIAGNOSTIC_SOURCE = "org.eclipse.set.model.integrationview";
    private static final int GENERATED_DIAGNOSTIC_CODE_COUNT = 0;
    protected static final int DIAGNOSTIC_CODE_COUNT = 0;

    protected EPackage getEPackage() {
        return IntegrationviewPackage.eINSTANCE;
    }

    protected boolean validate(int classifierID, Object value, DiagnosticChain diagnostics, Map<Object, Object> context) {
        switch (classifierID) {
            case 0: {
                return this.validateIntegrationView((IntegrationView)value, diagnostics, context);
            }
            case 1: {
                return this.validateObjectQuantity((ObjectQuantity)value, diagnostics, context);
            }
            case 2: {
                return this.validateConflict((Conflict)value, diagnostics, context);
            }
            case 3: {
                return this.validateDetails((Details)value, diagnostics, context);
            }
        }
        return true;
    }

    public boolean validateIntegrationView(IntegrationView integrationView, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(integrationView, diagnostics, context);
    }

    public boolean validateObjectQuantity(ObjectQuantity objectQuantity, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(objectQuantity, diagnostics, context);
    }

    public boolean validateConflict(Conflict conflict, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(conflict, diagnostics, context);
    }

    public boolean validateDetails(Details details, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(details, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(details, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(details, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(details, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(details, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(details, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(details, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(details, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(details, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateDetails_equalPlanningValues(details, diagnostics, context);
        }
        return result;
    }

    public boolean validateDetails_equalPlanningValues(Details details, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!StringExtensions.nullSafeEquals((String)details.getValuePrimaryPlanning(), (String)details.getValueSecondaryPlanning())) {
            if (diagnostics != null) {
                diagnostics.add((Diagnostic)this.createDiagnostic(4, DIAGNOSTIC_SOURCE, 1, "message_validateDetails_equalPlanningValues", new Object[]{"equalPlanningValues", IntegrationviewValidator.getObjectLabel((EObject)details, context)}, new Object[]{details, IntegrationviewPackage.eINSTANCE.getDetails_ValuePrimaryPlanning()}, context));
            }
            return false;
        }
        return true;
    }

    public ResourceLocator getResourceLocator() {
        return new ToolboxResourceLocator(super.getResourceLocator());
    }
}

