/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.feature.plazmodel.check;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.apache.commons.text.StringSubstitutor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.set.feature.plazmodel.check.AbstractPlazContainerCheck;
import org.eclipse.set.feature.plazmodel.check.PlazCheck;
import org.eclipse.set.model.plazmodel.PlazError;
import org.eclipse.set.model.plazmodel.PlazFactory;
import org.eclipse.set.model.validationreport.ValidationSeverity;
import org.eclipse.set.ppmodel.extensions.PlanProSchnittstelleExtensions;
import org.eclipse.set.ppmodel.extensions.container.MultiContainer_AttributeGroup;
import org.eclipse.set.toolboxmodel.Ansteuerung_Element.Aussenelementansteuerung;
import org.eclipse.set.toolboxmodel.Bahnsteig.Bahnsteig_Anlage;
import org.eclipse.set.toolboxmodel.Bahnsteig.Bahnsteig_Kante;
import org.eclipse.set.toolboxmodel.Basisobjekte.Basis_Objekt;
import org.eclipse.set.toolboxmodel.Basisobjekte.Identitaet_TypeClass;
import org.eclipse.set.toolboxmodel.Basisobjekte.Ur_Objekt;
import org.eclipse.set.toolboxmodel.Geodaten.GEO_Kante;
import org.eclipse.set.toolboxmodel.Geodaten.TOP_Kante;
import org.eclipse.set.toolboxmodel.PlanPro.LST_Objekte_Planungsbereich_AttributeGroup;
import org.eclipse.set.toolboxmodel.PlanPro.PlanPro_Schnittstelle;
import org.eclipse.set.toolboxmodel.PlanPro.Planung_Einzel;
import org.eclipse.set.toolboxmodel.PlanPro.Planung_Gruppe;
import org.eclipse.set.toolboxmodel.Signale.Signal;
import org.eclipse.set.toolboxmodel.Signale.Signal_Befestigung;
import org.eclipse.set.toolboxmodel.Signale.Signal_Rahmen;
import org.eclipse.set.toolboxmodel.Weichen_und_Gleissperren.W_Kr_Anlage;
import org.eclipse.set.toolboxmodel.Weichen_und_Gleissperren.W_Kr_Gsp_Element;
import org.eclipse.set.toolboxmodel.Weichen_und_Gleissperren.W_Kr_Gsp_Komponente;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.osgi.service.component.annotations.Component;

@Component(immediate=true)
public class PlanungsBereichValid
extends AbstractPlazContainerCheck
implements PlazCheck {
    private Set<Ur_Objekt> planningsObjects = CollectionLiterals.newHashSet();
    private static final List<? extends Class<? extends Basis_Objekt>> relevantTypeObjects = Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new Class[]{Signal.class, Signal_Rahmen.class, Signal_Befestigung.class, GEO_Kante.class, TOP_Kante.class, Bahnsteig_Anlage.class, Bahnsteig_Kante.class, W_Kr_Anlage.class, W_Kr_Gsp_Element.class, W_Kr_Gsp_Komponente.class, Aussenelementansteuerung.class}));

    @Override
    public List<PlazError> run(MultiContainer_AttributeGroup container) {
        boolean _isNullOrEmpty;
        Iterable _orElse = PlanProSchnittstelleExtensions.getLSTPlanungGruppe((PlanPro_Schnittstelle)this.modelSession.getPlanProSchnittstelle()).orElse(null);
        if (_orElse != null) {
            Consumer<Planung_Gruppe> _function = new Consumer<Planung_Gruppe>(){

                @Override
                public void accept(Planung_Gruppe it) {
                    EList objects;
                    boolean _isNullOrEmpty;
                    Planung_Einzel _lSTPlanungEinzel = it.getLSTPlanungEinzel();
                    LST_Objekte_Planungsbereich_AttributeGroup _lSTObjektePlanungsbereich = null;
                    if (_lSTPlanungEinzel != null) {
                        _lSTObjektePlanungsbereich = _lSTPlanungEinzel.getLSTObjektePlanungsbereich();
                    }
                    EList _iDLSTObjektPlanungsbereich = null;
                    if (_lSTObjektePlanungsbereich != null) {
                        _iDLSTObjektPlanungsbereich = _lSTObjektePlanungsbereich.getIDLSTObjektPlanungsbereich();
                    }
                    if (_isNullOrEmpty = IterableExtensions.isNullOrEmpty((Iterable)(objects = _iDLSTObjektPlanungsbereich))) {
                        return;
                    }
                    PlanungsBereichValid.this.planningsObjects.addAll((Collection<Ur_Objekt>)objects);
                }
            };
            _orElse.forEach(_function);
        }
        if (_isNullOrEmpty = IterableExtensions.isNullOrEmpty(this.planningsObjects)) {
            return Collections.unmodifiableList(CollectionLiterals.newArrayList());
        }
        Functions.Function1<Ur_Objekt, Boolean> _function_1 = new Functions.Function1<Ur_Objekt, Boolean>(){

            public Boolean apply(final Ur_Objekt obj) {
                Functions.Function1<Class<? extends Basis_Objekt>, Boolean> _function = new Functions.Function1<Class<? extends Basis_Objekt>, Boolean>(){

                    public Boolean apply(Class<? extends Basis_Objekt> it) {
                        return it.isInstance(obj);
                    }
                };
                return IterableExtensions.exists(relevantTypeObjects, (Functions.Function1)_function);
            }
        };
        Functions.Function1<Ur_Objekt, Iterable<PlazError>> _function_2 = new Functions.Function1<Ur_Objekt, Iterable<PlazError>>(){

            public Iterable<PlazError> apply(Ur_Objekt it) {
                return PlanungsBereichValid.this.checkObject(it);
            }
        };
        return IterableExtensions.toList((Iterable)IterableExtensions.flatMap((Iterable)IterableExtensions.filter((Iterable)container.getUrObjekt(), (Functions.Function1)_function_1), (Functions.Function1)_function_2));
    }

    private Iterable<PlazError> checkObject(final Ur_Objekt object) {
        String guid;
        Identitaet_TypeClass _identitaet = object.getIdentitaet();
        String _wert = null;
        if (_identitaet != null) {
            _wert = _identitaet.getWert();
        }
        if ((guid = _wert) == null) {
            return Collections.unmodifiableList(CollectionLiterals.newArrayList());
        }
        final boolean isPlanning = this.isPlanningObject(object);
        Functions.Function1<Ur_Objekt, Boolean> _function = new Functions.Function1<Ur_Objekt, Boolean>(){

            public Boolean apply(Ur_Objekt it) {
                boolean _isPlanningObject = PlanungsBereichValid.this.isPlanningObject(it);
                return Boolean.valueOf(_isPlanningObject) != Boolean.valueOf(isPlanning);
            }
        };
        Iterable mismatchedObjects = IterableExtensions.filterNull((Iterable)IterableExtensions.filter(this.getReferencedObjects(object), (Functions.Function1)_function));
        Functions.Function1<Ur_Objekt, PlazError> _function_1 = new Functions.Function1<Ur_Objekt, PlazError>(){

            public PlazError apply(Ur_Objekt it) {
                PlazError err = PlazFactory.eINSTANCE.createPlazError();
                String _name = it.eClass().getName();
                Identitaet_TypeClass _identitaet = it.getIdentitaet();
                String _wert = null;
                if (_identitaet != null) {
                    _wert = _identitaet.getWert();
                }
                err.setMessage(PlanungsBereichValid.this.transformErrorMsg(Map.of("GUID", guid, "TYP", _name, "REF_GUID", _wert)));
                err.setType("Planungs-/Betrachtungsbereich");
                err.setObject((EObject)object);
                err.setSeverity(ValidationSeverity.WARNING);
                return err;
            }
        };
        return IterableExtensions.map((Iterable)mismatchedObjects, (Functions.Function1)_function_1);
    }

    private Set<Ur_Objekt> getReferencedObjects(final Ur_Objekt source) {
        Functions.Function1<Ur_Objekt, Boolean> _function = new Functions.Function1<Ur_Objekt, Boolean>(){

            public Boolean apply(final Ur_Objekt obj) {
                Functions.Function1<Class<? extends Basis_Objekt>, Boolean> _function = new Functions.Function1<Class<? extends Basis_Objekt>, Boolean>(){

                    public Boolean apply(Class<? extends Basis_Objekt> it) {
                        return it.isInstance(obj) && !Objects.equal((Object)obj, (Object)source);
                    }
                };
                return IterableExtensions.exists(relevantTypeObjects, (Functions.Function1)_function);
            }
        };
        return IterableExtensions.toSet((Iterable)IterableExtensions.filterNull((Iterable)IterableExtensions.filter((Iterable)Iterables.filter((Iterable)source.eCrossReferences(), Ur_Objekt.class), (Functions.Function1)_function)));
    }

    private boolean isPlanningObject(Ur_Objekt parent) {
        return this.planningsObjects.contains(parent);
    }

    @Override
    public String checkType() {
        return "Planungs-/Betrachtungsbereich";
    }

    @Override
    public String getDescription() {
        return "Objekte sind eindeutig im Planungs- oder Betrachtungsbereich verortet.";
    }

    @Override
    public String getGeneralErrMsg() {
        return "Das Objekt {GUID} verweist auf das zugeh\u00f6rige Objekt {TYP} {REF_GUID}, die Objekte liegen aber uneinheitlich in Planungs- und Betrachtungsbereich.";
    }

    private String transformErrorMsg(Map<String, String> params) {
        return StringSubstitutor.replace((Object)this.getGeneralErrMsg(), params, (String)"{", (String)"}");
    }
}

