/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.feature.plazmodel.check;

import com.google.common.base.Objects;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.apache.commons.text.StringSubstitutor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.set.feature.plazmodel.check.AbstractPlazContainerCheck;
import org.eclipse.set.feature.plazmodel.check.PlazCheck;
import org.eclipse.set.model.plazmodel.PlazError;
import org.eclipse.set.model.plazmodel.PlazFactory;
import org.eclipse.set.ppmodel.extensions.GeoKnotenExtensions;
import org.eclipse.set.ppmodel.extensions.container.MultiContainer_AttributeGroup;
import org.eclipse.set.toolboxmodel.Basisobjekte.Identitaet_TypeClass;
import org.eclipse.set.toolboxmodel.Geodaten.ENUMGEOKoordinatensystem;
import org.eclipse.set.toolboxmodel.Geodaten.GEO_Kante;
import org.eclipse.set.toolboxmodel.Geodaten.GEO_Kante_Allg_AttributeGroup;
import org.eclipse.set.toolboxmodel.Geodaten.GEO_Knoten;
import org.eclipse.set.toolboxmodel.Geodaten.GEO_Koordinatensystem_TypeClass;
import org.eclipse.set.toolboxmodel.Geodaten.GEO_Laenge_TypeClass;
import org.eclipse.set.toolboxmodel.Geodaten.GEO_Punkt;
import org.eclipse.set.toolboxmodel.Geodaten.GEO_Punkt_Allg_AttributeGroup;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.osgi.service.component.annotations.Component;

@Component
public class MeridianBetweenGEOKante
extends AbstractPlazContainerCheck
implements PlazCheck {
    @Override
    public String checkType() {
        return "Koordinatensystem";
    }

    @Override
    public String getDescription() {
        return "Instanzen von GEO_Kante haben ein konsistentes Koordinatensystem.";
    }

    @Override
    protected List<PlazError> run(MultiContainer_AttributeGroup container) {
        boolean _tripleEquals;
        Functions.Function1<GEO_Kante, Boolean> _function = new Functions.Function1<GEO_Kante, Boolean>(){

            public Boolean apply(GEO_Kante it) {
                Functions.Function1<GEO_Punkt, ENUMGEOKoordinatensystem> _function = new Functions.Function1<GEO_Punkt, ENUMGEOKoordinatensystem>(){

                    public ENUMGEOKoordinatensystem apply(GEO_Punkt it_1) {
                        GEO_Punkt_Allg_AttributeGroup _gEOPunktAllg = it_1.getGEOPunktAllg();
                        GEO_Koordinatensystem_TypeClass _gEOKoordinatensystem = null;
                        if (_gEOPunktAllg != null) {
                            _gEOKoordinatensystem = _gEOPunktAllg.getGEOKoordinatensystem();
                        }
                        ENUMGEOKoordinatensystem _wert = null;
                        if (_gEOKoordinatensystem != null) {
                            _wert = _gEOKoordinatensystem.getWert();
                        }
                        return _wert;
                    }
                };
                Set crsA = IterableExtensions.toSet((Iterable)ListExtensions.map((List)GeoKnotenExtensions.getGeoPunkte((GEO_Knoten)it.getIDGEOKnotenA()), (Functions.Function1)_function));
                Functions.Function1<GEO_Punkt, ENUMGEOKoordinatensystem> _function_1 = new Functions.Function1<GEO_Punkt, ENUMGEOKoordinatensystem>(){

                    public ENUMGEOKoordinatensystem apply(GEO_Punkt it_1) {
                        GEO_Punkt_Allg_AttributeGroup _gEOPunktAllg = it_1.getGEOPunktAllg();
                        GEO_Koordinatensystem_TypeClass _gEOKoordinatensystem = null;
                        if (_gEOPunktAllg != null) {
                            _gEOKoordinatensystem = _gEOPunktAllg.getGEOKoordinatensystem();
                        }
                        ENUMGEOKoordinatensystem _wert = null;
                        if (_gEOKoordinatensystem != null) {
                            _wert = _gEOKoordinatensystem.getWert();
                        }
                        return _wert;
                    }
                };
                final Set crsB = IterableExtensions.toSet((Iterable)ListExtensions.map((List)GeoKnotenExtensions.getGeoPunkte((GEO_Knoten)it.getIDGEOKnotenB()), (Functions.Function1)_function_1));
                Functions.Function1<ENUMGEOKoordinatensystem, Boolean> _function_2 = new Functions.Function1<ENUMGEOKoordinatensystem, Boolean>(){

                    public Boolean apply(final ENUMGEOKoordinatensystem a) {
                        Functions.Function1<ENUMGEOKoordinatensystem, Boolean> _function = new Functions.Function1<ENUMGEOKoordinatensystem, Boolean>(){

                            public Boolean apply(ENUMGEOKoordinatensystem b) {
                                return !Objects.equal((Object)a, (Object)b);
                            }
                        };
                        return IterableExtensions.exists((Iterable)crsB, (Functions.Function1)_function);
                    }
                };
                return IterableExtensions.exists((Iterable)crsA, (Functions.Function1)_function_2);
            }
        };
        Iterable geoKantenWithMeridianSprung = IterableExtensions.filter((Iterable)container.getGEOKante(), (Functions.Function1)_function);
        int _size = IterableExtensions.size((Iterable)geoKantenWithMeridianSprung);
        boolean bl = _tripleEquals = _size == 0;
        if (_tripleEquals) {
            return Collections.unmodifiableList(CollectionLiterals.newArrayList());
        }
        final ArrayList errList = CollectionLiterals.newArrayList();
        Consumer<GEO_Kante> _function_1 = new Consumer<GEO_Kante>(){

            @Override
            public void accept(GEO_Kante it) {
                double _doubleValue;
                boolean _tripleNotEquals;
                PlazError err = PlazFactory.eINSTANCE.createPlazError();
                GEO_Kante_Allg_AttributeGroup _gEOKanteAllg = it.getGEOKanteAllg();
                GEO_Laenge_TypeClass _gEOLaenge = null;
                if (_gEOKanteAllg != null) {
                    _gEOLaenge = _gEOKanteAllg.getGEOLaenge();
                }
                BigDecimal _wert = null;
                if (_gEOLaenge != null) {
                    _wert = _gEOLaenge.getWert();
                }
                boolean bl = _tripleNotEquals = (_doubleValue = _wert.doubleValue()) != 0.0;
                if (_tripleNotEquals) {
                    Identitaet_TypeClass _identitaet = it.getIdentitaet();
                    String _wert_1 = null;
                    if (_identitaet != null) {
                        _wert_1 = _identitaet.getWert();
                    }
                    err.setMessage(MeridianBetweenGEOKante.this.transformErrorMsg(Map.of("GUID", _wert_1)));
                    err.setType(MeridianBetweenGEOKante.this.checkType());
                    err.setObject((EObject)it);
                    errList.add(err);
                }
            }
        };
        geoKantenWithMeridianSprung.forEach(_function_1);
        return errList;
    }

    @Override
    public String getGeneralErrMsg() {
        return "Die GEO_Kante {GUID} mit der L\u00e4nge > 0 hat unterschiedliche Koordinatensysteme. Der sicherungstechnische Lageplan kann unvollst\u00e4ndig sein.";
    }

    private String transformErrorMsg(Map<String, String> params) {
        return StringSubstitutor.replace((Object)this.getGeneralErrMsg(), params, (String)"{", (String)"}");
    }
}

