/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.feature.plazmodel.check;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.text.StringSubstitutor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.set.feature.plazmodel.check.AbstractPlazContainerCheck;
import org.eclipse.set.feature.plazmodel.check.PlazCheck;
import org.eclipse.set.model.plazmodel.PlazError;
import org.eclipse.set.model.plazmodel.PlazFactory;
import org.eclipse.set.ppmodel.extensions.container.MultiContainer_AttributeGroup;
import org.eclipse.set.toolboxmodel.Basisobjekte.Identitaet_TypeClass;
import org.eclipse.set.toolboxmodel.Basisobjekte.Ur_Objekt;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.osgi.service.component.annotations.Component;

@Component
public class GuidUnique
extends AbstractPlazContainerCheck
implements PlazCheck {
    @Override
    public List<PlazError> run(MultiContainer_AttributeGroup container) {
        final HashSet knownGUIDs = CollectionLiterals.newHashSet();
        Functions.Function1<Ur_Objekt, PlazError> _function = new Functions.Function1<Ur_Objekt, PlazError>(){

            public PlazError apply(Ur_Objekt it) {
                String guid;
                boolean _contains;
                Identitaet_TypeClass _identitaet = it.getIdentitaet();
                String _wert = null;
                if (_identitaet != null) {
                    _wert = _identitaet.getWert();
                }
                if (_contains = knownGUIDs.contains(guid = _wert)) {
                    PlazError err = PlazFactory.eINSTANCE.createPlazError();
                    err.setMessage(GuidUnique.this.transformErrorMsg(Map.of("GUID", guid)));
                    err.setType(GuidUnique.this.checkType());
                    err.setObject((EObject)it);
                    return err;
                }
                knownGUIDs.add(guid);
                return null;
            }
        };
        return IterableExtensions.toList((Iterable)IterableExtensions.filterNull((Iterable)IterableExtensions.map((Iterable)container.getUrObjekt(), (Functions.Function1)_function)));
    }

    @Override
    public String checkType() {
        return "GUID-Eindeutigkeit";
    }

    @Override
    public String getDescription() {
        return "Die GUIDs aller Objekte sind eindeutig.";
    }

    @Override
    public String getGeneralErrMsg() {
        return "Die GUID {GUID} ist nicht eindeutig!";
    }

    private String transformErrorMsg(Map<String, String> params) {
        return StringSubstitutor.replace((Object)this.getGeneralErrMsg(), params, (String)"{", (String)"}");
    }
}

