/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.utils;

import com.google.common.base.CharMatcher;
import org.eclipse.set.utils.TextfieldStyle;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

public class Textfields {
    public static Text createDialogEntry(Composite container, String labelText, TextfieldStyle style) {
        Label label = new Label(container, 0);
        label.setText(labelText);
        Text textfield = style == TextfieldStyle.ALL_DIGITS ? Textfields.createDigitOnlyTextField(container) : (style == TextfieldStyle.INTEGER ? Textfields.createIntegerOnlyTextField(container) : new Text(container, 2048));
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        gridData.horizontalSpan = 1;
        textfield.setLayoutData((Object)gridData);
        return textfield;
    }

    public static Text createDigitOnlyTextField(Composite container) {
        Text field = new Text(container, 2048);
        field.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                Text text = (Text)e.getSource();
                String oldS = text.getText();
                String newS = oldS.substring(0, e.start) + e.text + oldS.substring(e.end);
                boolean isDigit = CharMatcher.inRange((char)'0', (char)'9').matchesAllOf((CharSequence)newS);
                if (!isDigit) {
                    e.doit = false;
                }
            }
        });
        return field;
    }

    public static Text createIntegerOnlyTextField(Composite container) {
        Text field = new Text(container, 2048);
        field.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                Text text = (Text)e.getSource();
                String oldS = text.getText();
                String newS = oldS.substring(0, e.start) + e.text + oldS.substring(e.end);
                boolean isInteger = true;
                try {
                    Integer.parseInt(newS);
                }
                catch (NumberFormatException ex) {
                    isInteger = false;
                }
                if (!isInteger) {
                    e.doit = false;
                }
            }
        });
        return field;
    }

    private Textfields() {
    }
}

