/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.core.internal.contexts.osgi;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.e4.core.contexts.IContextFunction;
import org.eclipse.e4.core.internal.contexts.EclipseContext;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.SynchronousBundleListener;

public class EclipseContextOSGi
extends EclipseContext
implements ServiceListener,
SynchronousBundleListener {
    private final BundleContext bundleContext;
    private Map<String, ServiceReference<?>> refs = Collections.synchronizedMap(new HashMap());

    public EclipseContextOSGi(BundleContext bundleContext) {
        super(null);
        this.bundleContext = bundleContext;
        try {
            Object[] existing = bundleContext.getServiceReferences(IContextFunction.SERVICE_NAME, null);
            if (existing != null) {
                Arrays.sort(existing);
                int i = 0;
                while (i < existing.length) {
                    String name = (String)existing[i].getProperty("service.context.key");
                    this.refs.put(name, (ServiceReference<?>)existing[i]);
                    this.localValues.put(name, bundleContext.getService((ServiceReference)existing[i]));
                    ++i;
                }
            }
        }
        catch (InvalidSyntaxException invalidSyntaxException) {}
        this.bundleContext.addServiceListener((ServiceListener)this);
        this.bundleContext.addBundleListener((BundleListener)this);
    }

    @Override
    public boolean containsKey(String name, boolean localOnly) {
        if (super.containsKey(name, localOnly)) {
            return true;
        }
        Object result = this.lookup(name, this);
        return result != null;
    }

    @Override
    public Object lookup(String name, EclipseContext originatingContext) {
        if (name == null) {
            return null;
        }
        if (this.refs.containsKey(name)) {
            ServiceReference<?> ref = this.refs.get(name);
            if (ref == null) {
                return null;
            }
            Object service = this.bundleContext.getService(ref);
            this.bundleContext.ungetService(ref);
            this.localValues.put(name, service);
            return service;
        }
        ServiceReference ref = this.bundleContext.getServiceReference(name);
        if (ref == null) {
            this.refs.put(name, null);
            return null;
        }
        this.refs.put(name, ref);
        Object service = this.bundleContext.getService(ref);
        this.localValues.put(name, service);
        return service;
    }

    private String serviceName(ServiceReference<?> reference) {
        return ((String[])reference.getProperty("objectClass"))[0];
    }

    @Override
    public void dispose() {
        for (ServiceReference<?> ref : this.refs.values()) {
            if (ref == null) continue;
            this.bundleContext.ungetService(ref);
        }
        this.refs.clear();
        this.bundleContext.removeServiceListener((ServiceListener)this);
        this.bundleContext.removeBundleListener((BundleListener)this);
        super.dispose();
    }

    public void serviceChanged(ServiceEvent event) {
        ServiceReference ref = event.getServiceReference();
        String name = this.serviceName(ref);
        if (IContextFunction.SERVICE_NAME.equals(name)) {
            name = (String)ref.getProperty("service.context.key");
        }
        if (this.refs.containsKey(name)) {
            ServiceReference<?> oldRef = this.refs.get(name);
            if (oldRef != null) {
                this.bundleContext.ungetService(oldRef);
            }
            if (event.getType() == 4) {
                this.refs.put(name, null);
                this.remove(name);
            } else {
                Object service = this.bundleContext.getService(ref);
                this.refs.put(name, ref);
                this.set(name, service);
            }
        }
    }

    public void bundleChanged(BundleEvent event) {
        if (event.getType() != 256) {
            return;
        }
        if (event.getBundle().getBundleId() == 0L) {
            this.dispose();
        }
    }
}

