/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.analysis.os.linux.core.inputoutput;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.analysis.os.linux.core.inputoutput.Disk;
import org.eclipse.tracecompass.analysis.os.linux.core.inputoutput.InputOutputAnalysisModule;
import org.eclipse.tracecompass.analysis.os.linux.core.inputoutput.InputOutputInformationProvider;
import org.eclipse.tracecompass.analysis.os.linux.core.inputoutput.IoOperationType;
import org.eclipse.tracecompass.internal.analysis.os.linux.core.inputoutput.Messages;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.AbstractStateSystemAnalysisDataProvider;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.CommonStatusMessage;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.TmfCommonXAxisResponseFactory;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.filters.TimeQueryFilter;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.xy.ITmfCommonXAxisModel;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.xy.ITmfXYDataProvider;
import org.eclipse.tracecompass.internal.provisional.tmf.core.response.TmfModelResponse;
import org.eclipse.tracecompass.internal.tmf.core.model.YModel;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystem;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceUtils;

public class DisksIODataProvider
extends AbstractStateSystemAnalysisDataProvider
implements ITmfXYDataProvider {
    private static final int BYTES_PER_SECTOR = 512;
    private static final double SECONDS_PER_NANOSECOND = Math.pow(10.0, -9.0);
    private final InputOutputAnalysisModule fModule;

    public static @Nullable DisksIODataProvider create(ITmfTrace trace) {
        InputOutputAnalysisModule module = (InputOutputAnalysisModule)TmfTraceUtils.getAnalysisModuleOfClass((ITmfTrace)trace, InputOutputAnalysisModule.class, (String)"org.eclipse.tracecompass.analysis.os.linux.inputoutput");
        if (module != null) {
            module.schedule();
            return new DisksIODataProvider(trace, module);
        }
        return null;
    }

    private DisksIODataProvider(ITmfTrace trace, InputOutputAnalysisModule module) {
        super(trace);
        this.fModule = module;
    }

    public TmfModelResponse<ITmfCommonXAxisModel> fetchXY(TimeQueryFilter filter, @Nullable IProgressMonitor monitor) {
        TmfModelResponse res = this.verifyParameters(this.fModule, filter, monitor);
        if (res != null) {
            return res;
        }
        @NonNull ITmfStateSystem ss = Objects.requireNonNull(this.fModule.getStateSystem(), "Statesystem should have been verified by verifyParameters");
        long queryStart = filter.getStart();
        long[] xValues = filter.getTimesRequested();
        ImmutableMap.Builder ySeries = ImmutableMap.builder();
        Collection<Disk> disks = InputOutputInformationProvider.getDisks(this.fModule);
        long currentEnd = ss.getCurrentEndTime();
        for (Disk disk : Iterables.filter(disks, Disk::hasActivity)) {
            String diskName = disk.getDiskName();
            double[] yValuesWritten = new double[xValues.length];
            double[] yValuesRead = new double[xValues.length];
            String seriesNameWritten = String.valueOf(diskName) + Messages.DisksIODataProvider_write;
            String seriesNameRead = String.valueOf(diskName) + Messages.DisksIODataProvider_read;
            long prevTime = queryStart;
            long prevCountRead = disk.getSectorsAt(prevTime, IoOperationType.READ);
            long prevCountWrite = disk.getSectorsAt(prevTime, IoOperationType.WRITE);
            int i = 1;
            while (i < xValues.length) {
                if (monitor != null && monitor.isCanceled()) {
                    return TmfCommonXAxisResponseFactory.createCancelledResponse((String)CommonStatusMessage.TASK_CANCELLED);
                }
                long time = xValues[i];
                if (time >= ss.getStartTime() && time <= currentEnd) {
                    long count = disk.getSectorsAt(time, IoOperationType.WRITE);
                    yValuesWritten[i] = DisksIODataProvider.interpolate(prevTime, time, prevCountWrite, count);
                    prevCountWrite = count;
                    count = disk.getSectorsAt(time, IoOperationType.READ);
                    yValuesRead[i] = DisksIODataProvider.interpolate(prevTime, time, prevCountRead, count);
                    prevCountRead = count;
                }
                prevTime = time;
                ++i;
            }
            ySeries.put((Object)seriesNameRead, (Object)new YModel(seriesNameRead, yValuesRead));
            ySeries.put((Object)seriesNameWritten, (Object)new YModel(seriesNameWritten, yValuesWritten));
            if (monitor == null || !monitor.isCanceled()) continue;
            return TmfCommonXAxisResponseFactory.createCancelledResponse((String)CommonStatusMessage.TASK_CANCELLED);
        }
        boolean complete = ss.waitUntilBuilt(0L) || filter.getEnd() <= currentEnd;
        return TmfCommonXAxisResponseFactory.create((String)Objects.requireNonNull(Messages.DisksIODataProvider_title), (long[])xValues, (Map)ySeries.build(), (boolean)complete);
    }

    private static double interpolate(long prevTime, long time, long prevCount, long count) {
        return (double)((count - prevCount) * 512L) / ((double)(time - prevTime) * SECONDS_PER_NANOSECOND);
    }
}

