/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.core.pathmapper;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.php.internal.debug.core.Logger;
import org.eclipse.php.internal.debug.core.PHPDebugPlugin;
import org.eclipse.php.internal.debug.core.pathmapper.ILocalFileSearchFilter;

public class LocalFileSearchFilterRegistry {
    private static Map<String, ILocalFileSearchFilter> filtersMap = null;
    private static final String PROP_ID = "id";
    private static final String PROP_CLASS = "class";
    public static final String EXTENSION_POINT_ID = String.valueOf(PHPDebugPlugin.getDefault().getBundle().getSymbolicName()) + ".phpLocalFileSearchFilters";
    private static LocalFileSearchFilterRegistry instance;

    public static final synchronized ILocalFileSearchFilter getFilter(String id) {
        Map<String, ILocalFileSearchFilter> filters = LocalFileSearchFilterRegistry.getFilters();
        return filters.get(id);
    }

    private static final Map<String, ILocalFileSearchFilter> getFilters() {
        if (filtersMap == null) {
            filtersMap = LocalFileSearchFilterRegistry.getDefault().readFromExtensionPoint();
        }
        return filtersMap;
    }

    private static LocalFileSearchFilterRegistry getDefault() {
        if (instance == null) {
            instance = new LocalFileSearchFilterRegistry();
        }
        return instance;
    }

    private Map<String, ILocalFileSearchFilter> readFromExtensionPoint() {
        IConfigurationElement[] configurationElements;
        HashMap<String, ILocalFileSearchFilter> entries = new HashMap<String, ILocalFileSearchFilter>();
        IConfigurationElement[] iConfigurationElementArray = configurationElements = Platform.getExtensionRegistry().getConfigurationElementsFor(EXTENSION_POINT_ID);
        int n = configurationElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            String id = element.getAttribute(PROP_ID);
            try {
                ILocalFileSearchFilter filter = (ILocalFileSearchFilter)this.createInstance(element, PROP_CLASS, ILocalFileSearchFilter.class);
                entries.put(id, filter);
            }
            catch (CoreException e) {
                Logger.logException("Could not instantiate local file search filter from extension point data.", e);
            }
            ++n2;
        }
        return entries;
    }

    private Object createInstance(IConfigurationElement element, String propertyName, Class instanceClass) throws CoreException {
        Object object = element.createExecutableExtension(propertyName);
        if (!instanceClass.isAssignableFrom(object.getClass())) {
            String message = String.format("Invalid typecast for %s", element.getAttribute(propertyName));
            Status status = new Status(4, PHPDebugPlugin.getDefault().getBundle().getSymbolicName(), message);
            throw new CoreException((IStatus)status);
        }
        return object;
    }
}

