/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.phpunit.model.providers;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.php.phpunit.model.elements.PHPUnitElement;
import org.eclipse.php.phpunit.model.elements.PHPUnitTest;
import org.eclipse.php.phpunit.model.elements.PHPUnitTestEvent;
import org.eclipse.php.phpunit.model.elements.PHPUnitTestException;
import org.eclipse.php.phpunit.model.elements.PHPUnitTraceFrame;

public class PHPUnitTestTraceTreeContentProvider
extends ArrayContentProvider
implements ITreeContentProvider {
    private boolean filter;

    public PHPUnitTestTraceTreeContentProvider(boolean filter) {
        this.filter = filter;
    }

    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    public Object[] getChildren(Object parentElement) {
        ArrayList<PHPUnitElement> results = new ArrayList<PHPUnitElement>();
        if (parentElement instanceof PHPUnitTest) {
            this.getCaseChildren((PHPUnitTest)parentElement, results);
        }
        if (parentElement instanceof PHPUnitTestEvent) {
            this.getEventChildren((PHPUnitTestEvent)parentElement, results);
        }
        return results.toArray();
    }

    private void getCaseChildren(PHPUnitTest testCase, List<PHPUnitElement> results) {
        List<PHPUnitElement> warnings;
        PHPUnitTestException exception = testCase.getException();
        if (!(exception == null || this.filter && exception.isFiltered())) {
            results.add(testCase.getException());
        }
        if ((warnings = testCase.getWarnings()) == null || warnings.isEmpty()) {
            return;
        }
        if (!this.filter) {
            results.addAll(warnings);
        } else {
            for (PHPUnitElement warning : warnings) {
                if (warning.isFiltered()) continue;
                results.add(warning);
            }
        }
    }

    private void getEventChildren(PHPUnitTestEvent testEvent, List<PHPUnitElement> results) {
        List<PHPUnitTraceFrame> trace = testEvent.getTrace();
        if (trace == null || trace.isEmpty()) {
            return;
        }
        if (!this.filter) {
            results.addAll(trace);
        } else {
            for (PHPUnitElement pHPUnitElement : trace) {
                if (pHPUnitElement.isFiltered()) continue;
                results.add(pHPUnitElement);
            }
        }
    }

    public Object getParent(Object element) {
        if (element instanceof PHPUnitTraceFrame) {
            return ((PHPUnitTraceFrame)element).getParent();
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        if (element instanceof PHPUnitTest) {
            return this.hasChildrenCase((PHPUnitTest)element);
        }
        if (element instanceof PHPUnitTestEvent) {
            return this.hasChildrenEvent((PHPUnitTestEvent)element);
        }
        return false;
    }

    private boolean hasChildrenCase(PHPUnitTest testCase) {
        if (testCase.getException() != null) {
            return true;
        }
        List<PHPUnitElement> warnings = testCase.getWarnings();
        return warnings != null && !warnings.isEmpty();
    }

    private boolean hasChildrenEvent(PHPUnitTestEvent testEvent) {
        List<PHPUnitTraceFrame> trace = testEvent.getTrace();
        return trace != null && !trace.isEmpty();
    }
}

