/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.rpm.ui;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.linuxtools.internal.rpm.ui.Messages;
import org.eclipse.linuxtools.rpm.core.RPMProject;
import org.eclipse.linuxtools.rpm.ui.RPMExportOperation;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IOConsole;
import org.eclipse.ui.console.IOConsoleOutputStream;

public class RpmConsole
extends IOConsole {
    public static final String ID = "rpmbuild";
    private final RPMProject rpmProject;
    private final Set<RpmConsoleObserver> activeConsoleObservers = new HashSet<RpmConsoleObserver>();
    private final Set<RpmConsoleObserver> inactiveConsoleObservers = new HashSet<RpmConsoleObserver>();
    private RPMExportOperation currentJob;
    private boolean running = false;
    private JobChangeAdapter jobWatcher = new JobChangeAdapter(){

        public void aboutToRun(IJobChangeEvent event) {
            RpmConsole.this.running = true;
            RpmConsole.this.notifyConsoleObservers();
        }

        public void done(IJobChangeEvent event) {
            RpmConsole.this.running = false;
            RpmConsole.this.notifyConsoleObservers();
        }
    };

    public static RpmConsole findConsole(RPMProject rpmProject) {
        RpmConsole ret = null;
        IConsole[] iConsoleArray = ConsolePlugin.getDefault().getConsoleManager().getConsoles();
        int n = iConsoleArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConsole cons = iConsoleArray[n2];
            if (cons instanceof RpmConsole && ((RpmConsole)cons).rpmProject.getSpecFile().getProject().getName().equals(rpmProject.getSpecFile().getProject().getName())) {
                ret = (RpmConsole)cons;
            }
            ++n2;
        }
        if (ret == null) {
            ret = new RpmConsole(rpmProject);
            ConsolePlugin.getDefault().getConsoleManager().addConsoles(new IConsole[]{ret});
        }
        return ret;
    }

    public RpmConsole(RPMProject rpmProject) {
        super("rpmbuild(" + rpmProject.getSpecFile().getProject().getName() + ')', ID, null, true);
        this.rpmProject = rpmProject;
    }

    public IResource getSpecfile() {
        return this.rpmProject.getSpecFile();
    }

    public synchronized void addConsoleObserver(RpmConsoleObserver observer) {
        this.activeConsoleObservers.add(observer);
        observer.runningStateChanged(this.running);
    }

    public synchronized void removeConsoleObserver(RpmConsoleObserver observer) {
        this.inactiveConsoleObservers.add(observer);
    }

    private synchronized void notifyConsoleObservers() {
        for (RpmConsoleObserver observer : this.inactiveConsoleObservers) {
            this.activeConsoleObservers.remove(observer);
        }
        this.inactiveConsoleObservers.clear();
        for (RpmConsoleObserver observer : this.activeConsoleObservers) {
            observer.runningStateChanged(this.running);
        }
    }

    public synchronized void stop() {
        if (this.currentJob != null && this.running) {
            this.currentJob.cancel();
        }
    }

    public synchronized IOConsoleOutputStream linkJob(RPMExportOperation rpmJob) {
        if (rpmJob == null || ((Object)((Object)rpmJob)).equals((Object)this.currentJob)) {
            return null;
        }
        if (this.currentJob != null) {
            if (this.currentJob.getResult() == null) {
                this.showErrorDialog();
                return null;
            }
            this.currentJob.removeJobChangeListener((IJobChangeListener)this.jobWatcher);
            this.clearConsole();
        }
        this.activate();
        this.currentJob = rpmJob;
        this.currentJob.addJobChangeListener((IJobChangeListener)this.jobWatcher);
        this.running = this.currentJob.getState() == 4;
        this.notifyConsoleObservers();
        return this.newOutputStream();
    }

    protected synchronized void dispose() {
        this.activeConsoleObservers.clear();
        this.inactiveConsoleObservers.clear();
        super.dispose();
    }

    private void showErrorDialog() {
        PlatformUI.getWorkbench().getDisplay().asyncExec(() -> MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)Messages.getString("RPMConsole.OperationRunningTitle"), (String)Messages.getString("RPMConsole.OperationRunningMessage")));
    }

    public static interface RpmConsoleObserver {
        public void runningStateChanged(boolean var1);
    }
}

