/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.eclipse.ui.browser;

import org.eclipse.reddeer.common.condition.WaitCondition;
import org.eclipse.reddeer.common.wait.GroupWait;
import org.eclipse.reddeer.common.wait.TimePeriod;
import org.eclipse.reddeer.common.wait.WaitProvider;
import org.eclipse.reddeer.common.wait.WaitUntil;
import org.eclipse.reddeer.common.wait.WaitWrapper;
import org.eclipse.reddeer.core.reference.ReferencedComposite;
import org.eclipse.reddeer.eclipse.condition.BrowserHasURL;
import org.eclipse.reddeer.swt.api.Browser;
import org.eclipse.reddeer.swt.condition.PageIsLoaded;
import org.eclipse.reddeer.swt.impl.browser.InternalBrowser;
import org.eclipse.reddeer.workbench.impl.view.WorkbenchView;

public class WebBrowserView
extends WorkbenchView {
    protected Browser browser;
    protected static final TimePeriod TIMEOUT = TimePeriod.LONG;

    public WebBrowserView() {
        super("Internal Web Browser");
    }

    public void open() {
        if (this.browser == null) {
            super.open();
            this.browser = new InternalBrowser((ReferencedComposite)this.cTabItem);
        }
    }

    public void openPageURL(String url) {
        this.activate();
        this.browser.setURL(url);
        new WaitUntil((WaitCondition)new PageIsLoaded(this.browser), TIMEOUT);
    }

    public void refreshPage() {
        this.activate();
        this.browser.setURL(this.browser.getURL());
        new WaitUntil((WaitCondition)new PageIsLoaded(this.browser), TIMEOUT);
    }

    public void back() {
        this.activate();
        String prevUrl = this.browser.getURL();
        this.browser.back();
        new GroupWait(TIMEOUT, new WaitWrapper[]{WaitProvider.waitWhile((WaitCondition)new BrowserHasURL(this, prevUrl)), WaitProvider.waitUntil((WaitCondition)new PageIsLoaded(this.browser))});
    }

    public void forward() {
        this.activate();
        String prevUrl = this.browser.getURL();
        this.browser.forward();
        new GroupWait(TIMEOUT, new WaitWrapper[]{WaitProvider.waitWhile((WaitCondition)new BrowserHasURL(this, prevUrl)), WaitProvider.waitUntil((WaitCondition)new PageIsLoaded(this.browser))});
    }

    public String getPageURL() {
        this.activate();
        return this.browser.getURL();
    }

    public String getText() {
        this.activate();
        return this.browser.getText();
    }
}

