/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.eclipse.datatools.connectivity.ui.wizards;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.reddeer.common.condition.WaitCondition;
import org.eclipse.reddeer.common.wait.TimePeriod;
import org.eclipse.reddeer.common.wait.WaitUntil;
import org.eclipse.reddeer.core.reference.ReferencedComposite;
import org.eclipse.reddeer.eclipse.datatools.connectivity.db.generic.ui.GenericJDBCDBProfileDetailsWizardPage;
import org.eclipse.reddeer.eclipse.datatools.connectivity.oda.flatfile.ui.wizards.FolderSelectionWizardPage;
import org.eclipse.reddeer.eclipse.datatools.connectivity.ui.wizards.CPWizardSelectionPage;
import org.eclipse.reddeer.eclipse.datatools.connectivity.ui.wizards.ExtensibleProfileDetailsWizardPage;
import org.eclipse.reddeer.eclipse.datatools.enablement.msft.sqlserver.ui.connection.SQLServerDBProfileDetailsWizardPage;
import org.eclipse.reddeer.eclipse.datatools.enablement.oracle.ui.OracleDBProfileDetailsWizardPage;
import org.eclipse.reddeer.eclipse.datatools.ui.DatabaseProfile;
import org.eclipse.reddeer.eclipse.datatools.ui.DriverDefinition;
import org.eclipse.reddeer.eclipse.datatools.ui.FlatFileProfile;
import org.eclipse.reddeer.eclipse.exception.EclipseLayerException;
import org.eclipse.reddeer.eclipse.selectionwizard.NewMenuWizard;
import org.eclipse.reddeer.jface.wizard.WizardDialog;
import org.eclipse.reddeer.swt.condition.ShellIsAvailable;
import org.eclipse.reddeer.swt.impl.button.OkButton;
import org.eclipse.reddeer.swt.impl.button.PushButton;
import org.eclipse.reddeer.swt.impl.shell.DefaultShell;

public class NewCPWizard
extends NewMenuWizard {
    protected Map<String, ExtensibleProfileDetailsWizardPage> wizardMap = new HashMap<String, ExtensibleProfileDetailsWizardPage>();

    public NewCPWizard() {
        super("New Connection Profile", "Connection Profiles", "Connection Profile");
        this.wizardMap.put("Oracle", new OracleDBProfileDetailsWizardPage((WizardDialog)this));
        this.wizardMap.put("SQL Server", new SQLServerDBProfileDetailsWizardPage((WizardDialog)this));
        this.wizardMap.put("Generic JDBC", new GenericJDBCDBProfileDetailsWizardPage((WizardDialog)this));
    }

    public void createDatabaseProfile(DatabaseProfile dbProfile) {
        this.createDatabaseProfile(dbProfile, false);
    }

    public void createDatabaseProfile(DatabaseProfile dbProfile, boolean test) {
        CPWizardSelectionPage selectPage = new CPWizardSelectionPage((ReferencedComposite)this);
        selectPage.setConnectionProfile(dbProfile.getVendor());
        selectPage.setName(dbProfile.getName());
        this.next();
        ExtensibleProfileDetailsWizardPage dbPage = this.wizardMap.get(dbProfile.getVendor());
        DriverDefinition drvDef = dbProfile.getDriverDefinition();
        dbPage.setDriver(drvDef.getDriverName());
        dbPage.setDatabase(dbProfile.getDatabase());
        dbPage.setHostname(dbProfile.getHostname());
        dbPage.setPort(dbProfile.getPort());
        dbPage.setUsername(dbProfile.getUsername());
        dbPage.setPassword(dbProfile.getPassword());
        if (test) {
            String success = "Success";
            new PushButton("Test Connection").click();
            new WaitUntil((WaitCondition)new ShellIsAvailable(success), TimePeriod.DEFAULT, false);
            String text = new DefaultShell().getText();
            new OkButton().click();
            if (!text.equals(success)) {
                throw new EclipseLayerException("Connection ping failed!");
            }
        }
        this.finish();
    }

    public void createFlatFileProfile(FlatFileProfile flatProfile) {
        CPWizardSelectionPage selectPage = new CPWizardSelectionPage((ReferencedComposite)this);
        selectPage.setConnectionProfile("Flat File Data Source");
        selectPage.setName(flatProfile.getName());
        this.next();
        FolderSelectionWizardPage flatPage = new FolderSelectionWizardPage((ReferencedComposite)this);
        flatPage.setHomeFolder(flatProfile.getFolder());
        flatPage.setCharset(flatProfile.getCharset());
        flatPage.setStyle(flatProfile.getStyle());
        this.finish();
    }
}

