/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.spin.function.spif;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.Set;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.namespace.QName;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.base.CoreDatatype;
import org.eclipse.rdf4j.model.datatypes.XMLDatatypeUtil;
import org.eclipse.rdf4j.model.vocabulary.SPIF;
import org.eclipse.rdf4j.query.algebra.evaluation.ValueExprEvaluationException;
import org.eclipse.rdf4j.query.algebra.evaluation.function.BinaryFunction;

public class ParseDate
extends BinaryFunction {
    private static final DatatypeFactory datatypeFactory;

    @Override
    public String getURI() {
        return SPIF.PARSE_DATE_FUNCTION.toString();
    }

    @Override
    protected Value evaluate(ValueFactory valueFactory, Value arg1, Value arg2) throws ValueExprEvaluationException {
        if (!(arg1 instanceof Literal) || !(arg2 instanceof Literal)) {
            throw new ValueExprEvaluationException("Both arguments must be literals");
        }
        Literal value = (Literal)arg1;
        Literal format = (Literal)arg2;
        FieldAwareGregorianCalendar cal = new FieldAwareGregorianCalendar();
        SimpleDateFormat formatter = new SimpleDateFormat(format.getLabel());
        formatter.setCalendar(cal);
        try {
            formatter.parse(value.getLabel());
        }
        catch (ParseException e) {
            throw new ValueExprEvaluationException(e);
        }
        XMLGregorianCalendar xmlCal = datatypeFactory.newXMLGregorianCalendar(cal);
        if (!cal.isDateSet()) {
            xmlCal.setYear(Integer.MIN_VALUE);
            xmlCal.setMonth(Integer.MIN_VALUE);
            xmlCal.setDay(Integer.MIN_VALUE);
        }
        if (!cal.isTimeSet()) {
            xmlCal.setHour(Integer.MIN_VALUE);
            xmlCal.setMinute(Integer.MIN_VALUE);
            xmlCal.setSecond(Integer.MIN_VALUE);
        }
        if (!cal.isMillisecondSet()) {
            xmlCal.setMillisecond(Integer.MIN_VALUE);
        }
        String dateValue = xmlCal.toXMLFormat();
        QName dateType = xmlCal.getXMLSchemaType();
        if (!cal.isTimezoneSet()) {
            int len = dateValue.length();
            if (dateValue.endsWith("Z")) {
                dateValue = dateValue.substring(0, len - 1);
            } else if (dateValue.charAt(len - 6) == '+' || dateValue.charAt(len - 6) == '-') {
                dateValue = dateValue.substring(0, len - 6);
            }
        }
        return valueFactory.createLiteral(dateValue, (CoreDatatype)XMLDatatypeUtil.qnameToCoreDatatype(dateType));
    }

    static {
        try {
            datatypeFactory = DatatypeFactory.newInstance();
        }
        catch (DatatypeConfigurationException e) {
            throw new Error("Could not instantiate javax.xml.datatype.DatatypeFactory", e);
        }
    }

    static final class FieldAwareGregorianCalendar
    extends GregorianCalendar {
        Set<Integer> fieldsSet = new HashSet<Integer>();

        FieldAwareGregorianCalendar() {
        }

        @Override
        public void set(int field, int value) {
            super.set(field, value);
            this.fieldsSet.add(field);
        }

        boolean isDateSet() {
            return this.fieldsSet.contains(1) || this.fieldsSet.contains(2) || this.fieldsSet.contains(5) || this.fieldsSet.contains(7) || this.fieldsSet.contains(8) || this.fieldsSet.contains(6);
        }

        boolean isTimeSet() {
            return this.fieldsSet.contains(11) || this.fieldsSet.contains(10) || this.fieldsSet.contains(12) || this.fieldsSet.contains(13);
        }

        boolean isMillisecondSet() {
            return this.fieldsSet.contains(14);
        }

        boolean isTimezoneSet() {
            return this.fieldsSet.contains(15);
        }
    }
}

