/*
 * Decompiled with CFR 0.152.
 */
package org.mapdb;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mapdb.DBException;
import org.mapdb.StoreTrivial;
import org.mapdb.StoreTx;
import org.mapdb.Utils;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u001c\n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u0000 $2\u00020\u00012\u00020\u0002:\u0001$B!\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\bJ\b\u0010\u0018\u001a\u00020\u0019H\u0016J\b\u0010\u001a\u001a\u00020\u0019H\u0016J\u0011\u0010\u001b\u001a\u0004\u0018\u00010\u0012H\u0000\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u000e\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020 0\u001fH\u0016J\u0010\u0010!\u001a\u00020\u00192\u0006\u0010\"\u001a\u00020\u0012H\u0004J\b\u0010#\u001a\u00020\u0019H\u0016R\u0011\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u0013\u001a\n \u0015*\u0004\u0018\u00010\u00140\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006%"}, d2={"Lorg/mapdb/StoreTrivialTx;", "Lorg/mapdb/StoreTrivial;", "Lorg/mapdb/StoreTx;", "file", "Ljava/io/File;", "isThreadSafe", "", "deleteFilesAfterClose", "(Ljava/io/File;ZZ)V", "getDeleteFilesAfterClose", "()Z", "getFile", "()Ljava/io/File;", "fileChannel", "Ljava/nio/channels/FileChannel;", "fileLock", "Ljava/nio/channels/FileLock;", "lastFileNum", "", "path", "Ljava/nio/file/Path;", "kotlin.jvm.PlatformType", "getPath", "()Ljava/nio/file/Path;", "close", "", "commit", "findLattestCommitMarker", "findLattestCommitMarker$mapdb", "()Ljava/lang/Long;", "getAllFiles", "", "", "loadFrom", "number", "rollback", "Companion", "mapdb"})
@SourceDebugExtension(value={"SMAP\nStoreTrivial.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StoreTrivial.kt\norg/mapdb/StoreTrivialTx\n+ 2 Utils.kt\norg/mapdb/Utils\n*L\n1#1,478:1\n88#2,4:479\n78#2,3:483\n93#2,2:486\n78#2,3:488\n99#2,4:491\n78#2,3:495\n104#2,2:498\n88#2,7:500\n88#2,7:507\n*S KotlinDebug\n*F\n+ 1 StoreTrivial.kt\norg/mapdb/StoreTrivialTx\n*L\n352#1:479,4\n359#1:483,3\n352#1:486,2\n417#1:488,3\n424#1:491,4\n442#1:495,3\n424#1:498,2\n447#1:500,7\n458#1:507,7\n*E\n"})
public final class StoreTrivialTx
extends StoreTrivial
implements StoreTx {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final File file;
    private final boolean deleteFilesAfterClose;
    private final Path path;
    @NotNull
    private final FileChannel fileChannel;
    @NotNull
    private final FileLock fileLock;
    private long lastFileNum;
    @NotNull
    private static final String COMMIT_MARKER_SUFFIX = ".c";
    @NotNull
    private static final String DATA_SUFFIX = ".d";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public StoreTrivialTx(@NotNull File file, boolean isThreadSafe, boolean deleteFilesAfterClose) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        super(isThreadSafe);
        this.file = file;
        this.deleteFilesAfterClose = deleteFilesAfterClose;
        this.path = this.file.toPath();
        OpenOption[] openOptionArray = new OpenOption[]{StandardOpenOption.READ, StandardOpenOption.WRITE, StandardOpenOption.CREATE};
        FileChannel fileChannel = FileChannel.open(this.path, openOptionArray);
        Intrinsics.checkNotNullExpressionValue((Object)fileChannel, (String)"open(...)");
        this.fileChannel = fileChannel;
        StoreTrivialTx storeTrivialTx = this;
        try {
            StoreTrivialTx storeTrivialTx2 = storeTrivialTx;
            object = this.fileChannel.tryLock();
            Intrinsics.checkNotNull((Object)object);
        }
        catch (OverlappingFileLockException overlappingFileLockException) {
            void e;
            StoreTrivialTx storeTrivialTx3 = storeTrivialTx;
            Path path = this.path;
            Intrinsics.checkNotNull((Object)path);
            throw new DBException.FileLocked(path, (Exception)e);
        }
        storeTrivialTx2.fileLock = object;
        this.lastFileNum = -1L;
        object = Utils.INSTANCE;
        ReadWriteLock lock$iv = this.getLock();
        boolean $i$f$lockWrite = false;
        if (lock$iv != null) {
            lock$iv.writeLock().lock();
        }
        try {
            boolean bl = false;
            ByteBuffer buf = ByteBuffer.allocate(8);
            if (this.fileChannel.size() > 0L) {
                Long lattest;
                this.fileChannel.read(buf, 0L);
                long header = buf.getLong(0);
                this.fileHeaderCheck(header);
                Utils this_$iv = Utils.INSTANCE;
                boolean $i$f$logDebug = false;
                if (this_$iv.getLOG().isLoggable(Level.FINE)) {
                    Level level = Level.FINE;
                    Logger logger = this_$iv.getLOG();
                    boolean bl2 = false;
                    String string = "Opened file " + this.path;
                    logger.log(level, string);
                }
                Long l = lattest = this.findLattestCommitMarker$mapdb();
                long l2 = this.lastFileNum = l != null ? l : -1L;
                if (lattest != null) {
                    this.loadFrom(lattest);
                }
            } else {
                long header = this.fileHeaderCompose();
                buf.putLong(0, header);
                this.fileChannel.write(buf, 0L);
                this.fileChannel.force(true);
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            if (lock$iv != null) {
                lock$iv.writeLock().unlock();
            }
        }
    }

    public /* synthetic */ StoreTrivialTx(File file, boolean bl, boolean bl2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = true;
        }
        if ((n & 4) != 0) {
            bl2 = false;
        }
        this(file, bl, bl2);
    }

    @NotNull
    public final File getFile() {
        return this.file;
    }

    public final boolean getDeleteFilesAfterClose() {
        return this.deleteFilesAfterClose;
    }

    public final Path getPath() {
        return this.path;
    }

    @Nullable
    public final Long findLattestCommitMarker$mapdb() {
        Utils.INSTANCE.assertReadLock(this.getLock());
        if (this.path == null) {
            return null;
        }
        long highestCommitNumber = -1L;
        Path path = this.path.getFileName();
        Intrinsics.checkNotNull((Object)path);
        String name = ((Object)path).toString();
        Iterator iterator2 = Files.list(this.path.getParent()).iterator();
        while (iterator2.hasNext()) {
            Path child = (Path)iterator2.next();
            if (!Files.isRegularFile(child, new LinkOption[0])) continue;
            Path path2 = child.getFileName();
            Intrinsics.checkNotNull((Object)path2);
            String cname = ((Object)path2).toString();
            if (!StringsKt.startsWith$default((String)cname, (String)name, (boolean)false, (int)2, null) || !StringsKt.endsWith$default((String)cname, (String)COMMIT_MARKER_SUFFIX, (boolean)false, (int)2, null)) continue;
            char[] cArray = new char[]{'.'};
            List splited = StringsKt.split$default((CharSequence)cname.toString(), (char[])cArray, (boolean)false, (int)0, (int)6, null);
            try {
                Long commitNumber = Long.valueOf((String)splited.get(splited.size() - 2));
                Intrinsics.checkNotNull((Object)commitNumber);
                if (commitNumber <= highestCommitNumber) continue;
                highestCommitNumber = commitNumber;
            }
            catch (NumberFormatException e) {}
        }
        return highestCommitNumber == -1L ? null : Long.valueOf(highestCommitNumber);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void loadFrom(long number) {
        Utils.INSTANCE.assertWriteLock(this.getLock());
        Object object = this.path;
        Intrinsics.checkNotNull((Object)object);
        Path readFrom = Utils.INSTANCE.pathChangeSuffix((Path)object, "" + '.' + number + DATA_SUFFIX);
        Utils this_$iv = Utils.INSTANCE;
        boolean $i$f$logDebug = false;
        if (this_$iv.getLOG().isLoggable(Level.FINE)) {
            Level level = Level.FINE;
            Logger logger = this_$iv.getLOG();
            boolean bl = false;
            String string = "Loading from " + readFrom + " with length " + readFrom.toFile().length();
            logger.log(level, string);
        }
        OpenOption[] openOptionArray = new OpenOption[]{StandardOpenOption.READ};
        InputStream inputStream = Files.newInputStream(readFrom, openOptionArray);
        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"newInputStream(...)");
        object = inputStream;
        int n = 8192;
        object = object instanceof BufferedInputStream ? (BufferedInputStream)object : new BufferedInputStream((InputStream)object, n);
        Throwable throwable = null;
        try {
            BufferedInputStream it = (BufferedInputStream)object;
            boolean bl = false;
            this.loadFromInternal(it);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commit() {
        Utils utils = Utils.INSTANCE;
        ReadWriteLock lock$iv = this.getLock();
        boolean $i$f$lockRead = false;
        if (lock$iv != null) {
            lock$iv.readLock().lock();
        }
        try {
            boolean bl = false;
            long prev = this.lastFileNum;
            long next = prev + 1L;
            Object object = this.path;
            Intrinsics.checkNotNull((Object)object);
            Path saveTo = Utils.INSTANCE.pathChangeSuffix((Path)object, "" + '.' + next + DATA_SUFFIX);
            OpenOption[] openOptionArray = new OpenOption[]{StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.CREATE, StandardOpenOption.WRITE};
            OutputStream outputStream = Files.newOutputStream(saveTo, openOptionArray);
            Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)"newOutputStream(...)");
            object = outputStream;
            int n = 8192;
            object = object instanceof BufferedOutputStream ? (BufferedOutputStream)object : new BufferedOutputStream((OutputStream)object, n);
            Throwable throwable = null;
            try {
                BufferedOutputStream it = (BufferedOutputStream)object;
                boolean bl2 = false;
                this.saveTo(it);
                it = Unit.INSTANCE;
            }
            catch (Throwable it) {
                throwable = it;
                throw it;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
            }
            object = this.path;
            Intrinsics.checkNotNull((Object)object);
            Files.createFile(Utils.INSTANCE.pathChangeSuffix((Path)object, "" + '.' + next + COMMIT_MARKER_SUFFIX), new FileAttribute[0]);
            this.lastFileNum = next;
            object = this.path;
            Intrinsics.checkNotNull((Object)object);
            Files.deleteIfExists(Utils.INSTANCE.pathChangeSuffix((Path)object, "" + '.' + prev + COMMIT_MARKER_SUFFIX));
            object = this.path;
            Intrinsics.checkNotNull((Object)object);
            Files.deleteIfExists(Utils.INSTANCE.pathChangeSuffix((Path)object, "" + '.' + prev + DATA_SUFFIX));
            Utils this_$iv = Utils.INSTANCE;
            boolean $i$f$logDebug = false;
            if (this_$iv.getLOG().isLoggable(Level.FINE)) {
                Level level = Level.FINE;
                Logger logger = this_$iv.getLOG();
                boolean bl3 = false;
                String string = "Committed into " + saveTo + " with length " + saveTo.toFile().length();
                logger.log(level, string);
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            if (lock$iv != null) {
                lock$iv.readLock().unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rollback() {
        Utils utils = Utils.INSTANCE;
        ReadWriteLock lock$iv = this.getLock();
        boolean $i$f$lockWrite = false;
        if (lock$iv != null) {
            lock$iv.writeLock().lock();
        }
        try {
            boolean bl = false;
            if (this.lastFileNum == -1L) {
                this.clearInternal$mapdb();
                return;
            }
            this.loadFrom(this.lastFileNum);
            Unit unit = Unit.INSTANCE;
        }
        finally {
            if (lock$iv != null) {
                lock$iv.writeLock().unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Utils utils = Utils.INSTANCE;
        ReadWriteLock lock$iv = this.getLock();
        boolean $i$f$lockWrite = false;
        if (lock$iv != null) {
            lock$iv.writeLock().lock();
        }
        try {
            boolean bl = false;
            this.fileLock.release();
            this.fileChannel.close();
            super.close();
            if (this.deleteFilesAfterClose) {
                String f = this.file.getPath();
                long i = 0L;
                long l = this.lastFileNum;
                if (i <= l) {
                    while (true) {
                        String[] stringArray = new String[]{COMMIT_MARKER_SUFFIX, DATA_SUFFIX};
                        for (String suffix : stringArray) {
                            new File(f + '.' + i + suffix).delete();
                        }
                        if (i == l) break;
                        ++i;
                    }
                }
                this.file.delete();
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            if (lock$iv != null) {
                lock$iv.writeLock().unlock();
            }
        }
    }

    @Override
    @NotNull
    public Iterable<String> getAllFiles() {
        Object[] objectArray = new String[]{this.file.getPath()};
        return CollectionsKt.arrayListOf((Object[])objectArray);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0080D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u0004X\u0080D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006\u00a8\u0006\t"}, d2={"Lorg/mapdb/StoreTrivialTx$Companion;", "", "()V", "COMMIT_MARKER_SUFFIX", "", "getCOMMIT_MARKER_SUFFIX$mapdb", "()Ljava/lang/String;", "DATA_SUFFIX", "getDATA_SUFFIX$mapdb", "mapdb"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getCOMMIT_MARKER_SUFFIX$mapdb() {
            return COMMIT_MARKER_SUFFIX;
        }

        @NotNull
        public final String getDATA_SUFFIX$mapdb() {
            return DATA_SUFFIX;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

